/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.securityhub.model.AwsSecurityFindingIdentifier;
import com.amazonaws.services.securityhub.model.BatchUpdateFindingsUnprocessedFinding;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchUpdateFindingsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<AwsSecurityFindingIdentifier> processedFindings;
    private List<BatchUpdateFindingsUnprocessedFinding> unprocessedFindings;

    public List<AwsSecurityFindingIdentifier> getProcessedFindings() {
        return this.processedFindings;
    }

    public void setProcessedFindings(Collection<AwsSecurityFindingIdentifier> processedFindings) {
        if (processedFindings == null) {
            this.processedFindings = null;
            return;
        }
        this.processedFindings = new ArrayList<AwsSecurityFindingIdentifier>(processedFindings);
    }

    public BatchUpdateFindingsResult withProcessedFindings(AwsSecurityFindingIdentifier ... processedFindings) {
        if (this.processedFindings == null) {
            this.setProcessedFindings(new ArrayList<AwsSecurityFindingIdentifier>(processedFindings.length));
        }
        for (AwsSecurityFindingIdentifier ele : processedFindings) {
            this.processedFindings.add(ele);
        }
        return this;
    }

    public BatchUpdateFindingsResult withProcessedFindings(Collection<AwsSecurityFindingIdentifier> processedFindings) {
        this.setProcessedFindings(processedFindings);
        return this;
    }

    public List<BatchUpdateFindingsUnprocessedFinding> getUnprocessedFindings() {
        return this.unprocessedFindings;
    }

    public void setUnprocessedFindings(Collection<BatchUpdateFindingsUnprocessedFinding> unprocessedFindings) {
        if (unprocessedFindings == null) {
            this.unprocessedFindings = null;
            return;
        }
        this.unprocessedFindings = new ArrayList<BatchUpdateFindingsUnprocessedFinding>(unprocessedFindings);
    }

    public BatchUpdateFindingsResult withUnprocessedFindings(BatchUpdateFindingsUnprocessedFinding ... unprocessedFindings) {
        if (this.unprocessedFindings == null) {
            this.setUnprocessedFindings(new ArrayList<BatchUpdateFindingsUnprocessedFinding>(unprocessedFindings.length));
        }
        for (BatchUpdateFindingsUnprocessedFinding ele : unprocessedFindings) {
            this.unprocessedFindings.add(ele);
        }
        return this;
    }

    public BatchUpdateFindingsResult withUnprocessedFindings(Collection<BatchUpdateFindingsUnprocessedFinding> unprocessedFindings) {
        this.setUnprocessedFindings(unprocessedFindings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProcessedFindings() != null) {
            sb.append("ProcessedFindings: ").append(this.getProcessedFindings()).append(",");
        }
        if (this.getUnprocessedFindings() != null) {
            sb.append("UnprocessedFindings: ").append(this.getUnprocessedFindings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateFindingsResult)) {
            return false;
        }
        BatchUpdateFindingsResult other = (BatchUpdateFindingsResult)obj;
        if (other.getProcessedFindings() == null ^ this.getProcessedFindings() == null) {
            return false;
        }
        if (other.getProcessedFindings() != null && !other.getProcessedFindings().equals(this.getProcessedFindings())) {
            return false;
        }
        if (other.getUnprocessedFindings() == null ^ this.getUnprocessedFindings() == null) {
            return false;
        }
        return other.getUnprocessedFindings() == null || other.getUnprocessedFindings().equals(this.getUnprocessedFindings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProcessedFindings() == null ? 0 : this.getProcessedFindings().hashCode());
        hashCode = 31 * hashCode + (this.getUnprocessedFindings() == null ? 0 : this.getUnprocessedFindings().hashCode());
        return hashCode;
    }

    public BatchUpdateFindingsResult clone() {
        try {
            return (BatchUpdateFindingsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

