/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class EnableSecurityHubRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Map<String, String> tags;
    private Boolean enableDefaultStandards;

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public EnableSecurityHubRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public EnableSecurityHubRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public EnableSecurityHubRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setEnableDefaultStandards(Boolean enableDefaultStandards) {
        this.enableDefaultStandards = enableDefaultStandards;
    }

    public Boolean getEnableDefaultStandards() {
        return this.enableDefaultStandards;
    }

    public EnableSecurityHubRequest withEnableDefaultStandards(Boolean enableDefaultStandards) {
        this.setEnableDefaultStandards(enableDefaultStandards);
        return this;
    }

    public Boolean isEnableDefaultStandards() {
        return this.enableDefaultStandards;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getEnableDefaultStandards() != null) {
            sb.append("EnableDefaultStandards: ").append(this.getEnableDefaultStandards());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableSecurityHubRequest)) {
            return false;
        }
        EnableSecurityHubRequest other = (EnableSecurityHubRequest)obj;
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getEnableDefaultStandards() == null ^ this.getEnableDefaultStandards() == null) {
            return false;
        }
        return other.getEnableDefaultStandards() == null || other.getEnableDefaultStandards().equals(this.getEnableDefaultStandards());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getEnableDefaultStandards() == null ? 0 : this.getEnableDefaultStandards().hashCode());
        return hashCode;
    }

    public EnableSecurityHubRequest clone() {
        return (EnableSecurityHubRequest)super.clone();
    }
}

