/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.scheduler;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.scheduler.AmazonSchedulerAsync;
import com.amazonaws.services.scheduler.AmazonSchedulerAsyncClientBuilder;
import com.amazonaws.services.scheduler.AmazonSchedulerClient;
import com.amazonaws.services.scheduler.model.CreateScheduleGroupRequest;
import com.amazonaws.services.scheduler.model.CreateScheduleGroupResult;
import com.amazonaws.services.scheduler.model.CreateScheduleRequest;
import com.amazonaws.services.scheduler.model.CreateScheduleResult;
import com.amazonaws.services.scheduler.model.DeleteScheduleGroupRequest;
import com.amazonaws.services.scheduler.model.DeleteScheduleGroupResult;
import com.amazonaws.services.scheduler.model.DeleteScheduleRequest;
import com.amazonaws.services.scheduler.model.DeleteScheduleResult;
import com.amazonaws.services.scheduler.model.GetScheduleGroupRequest;
import com.amazonaws.services.scheduler.model.GetScheduleGroupResult;
import com.amazonaws.services.scheduler.model.GetScheduleRequest;
import com.amazonaws.services.scheduler.model.GetScheduleResult;
import com.amazonaws.services.scheduler.model.ListScheduleGroupsRequest;
import com.amazonaws.services.scheduler.model.ListScheduleGroupsResult;
import com.amazonaws.services.scheduler.model.ListSchedulesRequest;
import com.amazonaws.services.scheduler.model.ListSchedulesResult;
import com.amazonaws.services.scheduler.model.ListTagsForResourceRequest;
import com.amazonaws.services.scheduler.model.ListTagsForResourceResult;
import com.amazonaws.services.scheduler.model.TagResourceRequest;
import com.amazonaws.services.scheduler.model.TagResourceResult;
import com.amazonaws.services.scheduler.model.UntagResourceRequest;
import com.amazonaws.services.scheduler.model.UntagResourceResult;
import com.amazonaws.services.scheduler.model.UpdateScheduleRequest;
import com.amazonaws.services.scheduler.model.UpdateScheduleResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonSchedulerAsyncClient
extends AmazonSchedulerClient
implements AmazonSchedulerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonSchedulerAsyncClientBuilder asyncBuilder() {
        return AmazonSchedulerAsyncClientBuilder.standard();
    }

    AmazonSchedulerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonSchedulerAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateScheduleResult> createScheduleAsync(CreateScheduleRequest request) {
        return this.createScheduleAsync(request, null);
    }

    @Override
    public Future<CreateScheduleResult> createScheduleAsync(CreateScheduleRequest request, final AsyncHandler<CreateScheduleRequest, CreateScheduleResult> asyncHandler) {
        final CreateScheduleRequest finalRequest = (CreateScheduleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateScheduleResult>(){

            @Override
            public CreateScheduleResult call() throws Exception {
                CreateScheduleResult result = null;
                try {
                    result = AmazonSchedulerAsyncClient.this.executeCreateSchedule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateScheduleGroupResult> createScheduleGroupAsync(CreateScheduleGroupRequest request) {
        return this.createScheduleGroupAsync(request, null);
    }

    @Override
    public Future<CreateScheduleGroupResult> createScheduleGroupAsync(CreateScheduleGroupRequest request, final AsyncHandler<CreateScheduleGroupRequest, CreateScheduleGroupResult> asyncHandler) {
        final CreateScheduleGroupRequest finalRequest = (CreateScheduleGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateScheduleGroupResult>(){

            @Override
            public CreateScheduleGroupResult call() throws Exception {
                CreateScheduleGroupResult result = null;
                try {
                    result = AmazonSchedulerAsyncClient.this.executeCreateScheduleGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteScheduleResult> deleteScheduleAsync(DeleteScheduleRequest request) {
        return this.deleteScheduleAsync(request, null);
    }

    @Override
    public Future<DeleteScheduleResult> deleteScheduleAsync(DeleteScheduleRequest request, final AsyncHandler<DeleteScheduleRequest, DeleteScheduleResult> asyncHandler) {
        final DeleteScheduleRequest finalRequest = (DeleteScheduleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteScheduleResult>(){

            @Override
            public DeleteScheduleResult call() throws Exception {
                DeleteScheduleResult result = null;
                try {
                    result = AmazonSchedulerAsyncClient.this.executeDeleteSchedule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteScheduleGroupResult> deleteScheduleGroupAsync(DeleteScheduleGroupRequest request) {
        return this.deleteScheduleGroupAsync(request, null);
    }

    @Override
    public Future<DeleteScheduleGroupResult> deleteScheduleGroupAsync(DeleteScheduleGroupRequest request, final AsyncHandler<DeleteScheduleGroupRequest, DeleteScheduleGroupResult> asyncHandler) {
        final DeleteScheduleGroupRequest finalRequest = (DeleteScheduleGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteScheduleGroupResult>(){

            @Override
            public DeleteScheduleGroupResult call() throws Exception {
                DeleteScheduleGroupResult result = null;
                try {
                    result = AmazonSchedulerAsyncClient.this.executeDeleteScheduleGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetScheduleResult> getScheduleAsync(GetScheduleRequest request) {
        return this.getScheduleAsync(request, null);
    }

    @Override
    public Future<GetScheduleResult> getScheduleAsync(GetScheduleRequest request, final AsyncHandler<GetScheduleRequest, GetScheduleResult> asyncHandler) {
        final GetScheduleRequest finalRequest = (GetScheduleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetScheduleResult>(){

            @Override
            public GetScheduleResult call() throws Exception {
                GetScheduleResult result = null;
                try {
                    result = AmazonSchedulerAsyncClient.this.executeGetSchedule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetScheduleGroupResult> getScheduleGroupAsync(GetScheduleGroupRequest request) {
        return this.getScheduleGroupAsync(request, null);
    }

    @Override
    public Future<GetScheduleGroupResult> getScheduleGroupAsync(GetScheduleGroupRequest request, final AsyncHandler<GetScheduleGroupRequest, GetScheduleGroupResult> asyncHandler) {
        final GetScheduleGroupRequest finalRequest = (GetScheduleGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetScheduleGroupResult>(){

            @Override
            public GetScheduleGroupResult call() throws Exception {
                GetScheduleGroupResult result = null;
                try {
                    result = AmazonSchedulerAsyncClient.this.executeGetScheduleGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListScheduleGroupsResult> listScheduleGroupsAsync(ListScheduleGroupsRequest request) {
        return this.listScheduleGroupsAsync(request, null);
    }

    @Override
    public Future<ListScheduleGroupsResult> listScheduleGroupsAsync(ListScheduleGroupsRequest request, final AsyncHandler<ListScheduleGroupsRequest, ListScheduleGroupsResult> asyncHandler) {
        final ListScheduleGroupsRequest finalRequest = (ListScheduleGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListScheduleGroupsResult>(){

            @Override
            public ListScheduleGroupsResult call() throws Exception {
                ListScheduleGroupsResult result = null;
                try {
                    result = AmazonSchedulerAsyncClient.this.executeListScheduleGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSchedulesResult> listSchedulesAsync(ListSchedulesRequest request) {
        return this.listSchedulesAsync(request, null);
    }

    @Override
    public Future<ListSchedulesResult> listSchedulesAsync(ListSchedulesRequest request, final AsyncHandler<ListSchedulesRequest, ListSchedulesResult> asyncHandler) {
        final ListSchedulesRequest finalRequest = (ListSchedulesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSchedulesResult>(){

            @Override
            public ListSchedulesResult call() throws Exception {
                ListSchedulesResult result = null;
                try {
                    result = AmazonSchedulerAsyncClient.this.executeListSchedules(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonSchedulerAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonSchedulerAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonSchedulerAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateScheduleResult> updateScheduleAsync(UpdateScheduleRequest request) {
        return this.updateScheduleAsync(request, null);
    }

    @Override
    public Future<UpdateScheduleResult> updateScheduleAsync(UpdateScheduleRequest request, final AsyncHandler<UpdateScheduleRequest, UpdateScheduleResult> asyncHandler) {
        final UpdateScheduleRequest finalRequest = (UpdateScheduleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateScheduleResult>(){

            @Override
            public UpdateScheduleResult call() throws Exception {
                UpdateScheduleResult result = null;
                try {
                    result = AmazonSchedulerAsyncClient.this.executeUpdateSchedule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

