/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemakergeospatial.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The geographic extent of the Earth Observation job.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/AreaOfInterest"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AreaOfInterest implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * A GeoJSON object representing the geographic extent in the coordinate space.
     * </p>
     */
    private AreaOfInterestGeometry areaOfInterestGeometry;

    /**
     * <p>
     * A GeoJSON object representing the geographic extent in the coordinate space.
     * </p>
     * 
     * @param areaOfInterestGeometry
     *        A GeoJSON object representing the geographic extent in the coordinate space.
     */

    public void setAreaOfInterestGeometry(AreaOfInterestGeometry areaOfInterestGeometry) {
        this.areaOfInterestGeometry = areaOfInterestGeometry;
    }

    /**
     * <p>
     * A GeoJSON object representing the geographic extent in the coordinate space.
     * </p>
     * 
     * @return A GeoJSON object representing the geographic extent in the coordinate space.
     */

    public AreaOfInterestGeometry getAreaOfInterestGeometry() {
        return this.areaOfInterestGeometry;
    }

    /**
     * <p>
     * A GeoJSON object representing the geographic extent in the coordinate space.
     * </p>
     * 
     * @param areaOfInterestGeometry
     *        A GeoJSON object representing the geographic extent in the coordinate space.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AreaOfInterest withAreaOfInterestGeometry(AreaOfInterestGeometry areaOfInterestGeometry) {
        setAreaOfInterestGeometry(areaOfInterestGeometry);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAreaOfInterestGeometry() != null)
            sb.append("AreaOfInterestGeometry: ").append(getAreaOfInterestGeometry());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AreaOfInterest == false)
            return false;
        AreaOfInterest other = (AreaOfInterest) obj;
        if (other.getAreaOfInterestGeometry() == null ^ this.getAreaOfInterestGeometry() == null)
            return false;
        if (other.getAreaOfInterestGeometry() != null && other.getAreaOfInterestGeometry().equals(this.getAreaOfInterestGeometry()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAreaOfInterestGeometry() == null) ? 0 : getAreaOfInterestGeometry().hashCode());
        return hashCode;
    }

    @Override
    public AreaOfInterest clone() {
        try {
            return (AreaOfInterest) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.sagemakergeospatial.model.transform.AreaOfInterestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
