/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemakergeospatial.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListEarthObservationJobs"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListEarthObservationJobsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The total number of items to return.
     * </p>
     */
    private Integer maxResults;
    /**
     * <p>
     * If the previous response was truncated, you receive this token. Use it in your next request to receive the next
     * set of results.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * The parameter by which to sort the results.
     * </p>
     */
    private String sortBy;
    /**
     * <p>
     * An optional value that specifies whether you want the results sorted in <code>Ascending</code> or
     * <code>Descending</code> order.
     * </p>
     */
    private String sortOrder;
    /**
     * <p>
     * A filter that retrieves only jobs with a specific status.
     * </p>
     */
    private String statusEquals;

    /**
     * <p>
     * The total number of items to return.
     * </p>
     * 
     * @param maxResults
     *        The total number of items to return.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The total number of items to return.
     * </p>
     * 
     * @return The total number of items to return.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The total number of items to return.
     * </p>
     * 
     * @param maxResults
     *        The total number of items to return.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListEarthObservationJobsRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * <p>
     * If the previous response was truncated, you receive this token. Use it in your next request to receive the next
     * set of results.
     * </p>
     * 
     * @param nextToken
     *        If the previous response was truncated, you receive this token. Use it in your next request to receive the
     *        next set of results.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * If the previous response was truncated, you receive this token. Use it in your next request to receive the next
     * set of results.
     * </p>
     * 
     * @return If the previous response was truncated, you receive this token. Use it in your next request to receive
     *         the next set of results.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * If the previous response was truncated, you receive this token. Use it in your next request to receive the next
     * set of results.
     * </p>
     * 
     * @param nextToken
     *        If the previous response was truncated, you receive this token. Use it in your next request to receive the
     *        next set of results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListEarthObservationJobsRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The parameter by which to sort the results.
     * </p>
     * 
     * @param sortBy
     *        The parameter by which to sort the results.
     */

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    /**
     * <p>
     * The parameter by which to sort the results.
     * </p>
     * 
     * @return The parameter by which to sort the results.
     */

    public String getSortBy() {
        return this.sortBy;
    }

    /**
     * <p>
     * The parameter by which to sort the results.
     * </p>
     * 
     * @param sortBy
     *        The parameter by which to sort the results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListEarthObservationJobsRequest withSortBy(String sortBy) {
        setSortBy(sortBy);
        return this;
    }

    /**
     * <p>
     * An optional value that specifies whether you want the results sorted in <code>Ascending</code> or
     * <code>Descending</code> order.
     * </p>
     * 
     * @param sortOrder
     *        An optional value that specifies whether you want the results sorted in <code>Ascending</code> or
     *        <code>Descending</code> order.
     * @see SortOrder
     */

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    /**
     * <p>
     * An optional value that specifies whether you want the results sorted in <code>Ascending</code> or
     * <code>Descending</code> order.
     * </p>
     * 
     * @return An optional value that specifies whether you want the results sorted in <code>Ascending</code> or
     *         <code>Descending</code> order.
     * @see SortOrder
     */

    public String getSortOrder() {
        return this.sortOrder;
    }

    /**
     * <p>
     * An optional value that specifies whether you want the results sorted in <code>Ascending</code> or
     * <code>Descending</code> order.
     * </p>
     * 
     * @param sortOrder
     *        An optional value that specifies whether you want the results sorted in <code>Ascending</code> or
     *        <code>Descending</code> order.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SortOrder
     */

    public ListEarthObservationJobsRequest withSortOrder(String sortOrder) {
        setSortOrder(sortOrder);
        return this;
    }

    /**
     * <p>
     * An optional value that specifies whether you want the results sorted in <code>Ascending</code> or
     * <code>Descending</code> order.
     * </p>
     * 
     * @param sortOrder
     *        An optional value that specifies whether you want the results sorted in <code>Ascending</code> or
     *        <code>Descending</code> order.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SortOrder
     */

    public ListEarthObservationJobsRequest withSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder.toString();
        return this;
    }

    /**
     * <p>
     * A filter that retrieves only jobs with a specific status.
     * </p>
     * 
     * @param statusEquals
     *        A filter that retrieves only jobs with a specific status.
     * @see EarthObservationJobStatus
     */

    public void setStatusEquals(String statusEquals) {
        this.statusEquals = statusEquals;
    }

    /**
     * <p>
     * A filter that retrieves only jobs with a specific status.
     * </p>
     * 
     * @return A filter that retrieves only jobs with a specific status.
     * @see EarthObservationJobStatus
     */

    public String getStatusEquals() {
        return this.statusEquals;
    }

    /**
     * <p>
     * A filter that retrieves only jobs with a specific status.
     * </p>
     * 
     * @param statusEquals
     *        A filter that retrieves only jobs with a specific status.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see EarthObservationJobStatus
     */

    public ListEarthObservationJobsRequest withStatusEquals(String statusEquals) {
        setStatusEquals(statusEquals);
        return this;
    }

    /**
     * <p>
     * A filter that retrieves only jobs with a specific status.
     * </p>
     * 
     * @param statusEquals
     *        A filter that retrieves only jobs with a specific status.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see EarthObservationJobStatus
     */

    public ListEarthObservationJobsRequest withStatusEquals(EarthObservationJobStatus statusEquals) {
        this.statusEquals = statusEquals.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append("***Sensitive Data Redacted***").append(",");
        if (getSortBy() != null)
            sb.append("SortBy: ").append(getSortBy()).append(",");
        if (getSortOrder() != null)
            sb.append("SortOrder: ").append(getSortOrder()).append(",");
        if (getStatusEquals() != null)
            sb.append("StatusEquals: ").append(getStatusEquals());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListEarthObservationJobsRequest == false)
            return false;
        ListEarthObservationJobsRequest other = (ListEarthObservationJobsRequest) obj;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getSortBy() == null ^ this.getSortBy() == null)
            return false;
        if (other.getSortBy() != null && other.getSortBy().equals(this.getSortBy()) == false)
            return false;
        if (other.getSortOrder() == null ^ this.getSortOrder() == null)
            return false;
        if (other.getSortOrder() != null && other.getSortOrder().equals(this.getSortOrder()) == false)
            return false;
        if (other.getStatusEquals() == null ^ this.getStatusEquals() == null)
            return false;
        if (other.getStatusEquals() != null && other.getStatusEquals().equals(this.getStatusEquals()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getSortBy() == null) ? 0 : getSortBy().hashCode());
        hashCode = prime * hashCode + ((getSortOrder() == null) ? 0 : getSortOrder().hashCode());
        hashCode = prime * hashCode + ((getStatusEquals() == null) ? 0 : getStatusEquals().hashCode());
        return hashCode;
    }

    @Override
    public ListEarthObservationJobsRequest clone() {
        return (ListEarthObservationJobsRequest) super.clone();
    }

}
