/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemakergeospatial.model;

import javax.annotation.Generated;

/**
 * 
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public enum AlgorithmNameGeoMosaic {

    NEAR("NEAR"),
    BILINEAR("BILINEAR"),
    CUBIC("CUBIC"),
    CUBICSPLINE("CUBICSPLINE"),
    LANCZOS("LANCZOS"),
    AVERAGE("AVERAGE"),
    RMS("RMS"),
    MODE("MODE"),
    MAX("MAX"),
    MIN("MIN"),
    MED("MED"),
    Q1("Q1"),
    Q3("Q3"),
    SUM("SUM");

    private String value;

    private AlgorithmNameGeoMosaic(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value
     *        real value
     * @return AlgorithmNameGeoMosaic corresponding to the value
     *
     * @throws IllegalArgumentException
     *         If the specified value does not map to one of the known values in this enum.
     */
    public static AlgorithmNameGeoMosaic fromValue(String value) {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }

        for (AlgorithmNameGeoMosaic enumEntry : AlgorithmNameGeoMosaic.values()) {
            if (enumEntry.toString().equals(value)) {
                return enumEntry;
            }
        }

        throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
    }
}
