/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemakergeospatial;

import javax.annotation.Generated;

import com.amazonaws.services.sagemakergeospatial.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonSageMakerGeospatial}. Convenient method forms pass through to the
 * corresponding overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonSageMakerGeospatial implements AmazonSageMakerGeospatial {

    protected AbstractAmazonSageMakerGeospatial() {
    }

    @Override
    public DeleteEarthObservationJobResult deleteEarthObservationJob(DeleteEarthObservationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVectorEnrichmentJobResult deleteVectorEnrichmentJob(DeleteVectorEnrichmentJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ExportEarthObservationJobResult exportEarthObservationJob(ExportEarthObservationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ExportVectorEnrichmentJobResult exportVectorEnrichmentJob(ExportVectorEnrichmentJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEarthObservationJobResult getEarthObservationJob(GetEarthObservationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRasterDataCollectionResult getRasterDataCollection(GetRasterDataCollectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTileResult getTile(GetTileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVectorEnrichmentJobResult getVectorEnrichmentJob(GetVectorEnrichmentJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEarthObservationJobsResult listEarthObservationJobs(ListEarthObservationJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRasterDataCollectionsResult listRasterDataCollections(ListRasterDataCollectionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListVectorEnrichmentJobsResult listVectorEnrichmentJobs(ListVectorEnrichmentJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchRasterDataCollectionResult searchRasterDataCollection(SearchRasterDataCollectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartEarthObservationJobResult startEarthObservationJob(StartEarthObservationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartVectorEnrichmentJobResult startVectorEnrichmentJob(StartVectorEnrichmentJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopEarthObservationJobResult stopEarthObservationJob(StopEarthObservationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopVectorEnrichmentJobResult stopVectorEnrichmentJob(StopVectorEnrichmentJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
