/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakerfeaturestoreruntime;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.sagemakerfeaturestoreruntime.AmazonSageMakerFeatureStoreRuntime;
import com.amazonaws.services.sagemakerfeaturestoreruntime.AmazonSageMakerFeatureStoreRuntimeClientBuilder;
import com.amazonaws.services.sagemakerfeaturestoreruntime.model.AmazonSageMakerFeatureStoreRuntimeException;
import com.amazonaws.services.sagemakerfeaturestoreruntime.model.DeleteRecordRequest;
import com.amazonaws.services.sagemakerfeaturestoreruntime.model.DeleteRecordResult;
import com.amazonaws.services.sagemakerfeaturestoreruntime.model.GetRecordRequest;
import com.amazonaws.services.sagemakerfeaturestoreruntime.model.GetRecordResult;
import com.amazonaws.services.sagemakerfeaturestoreruntime.model.PutRecordRequest;
import com.amazonaws.services.sagemakerfeaturestoreruntime.model.PutRecordResult;
import com.amazonaws.services.sagemakerfeaturestoreruntime.model.transform.AccessForbiddenExceptionUnmarshaller;
import com.amazonaws.services.sagemakerfeaturestoreruntime.model.transform.DeleteRecordRequestProtocolMarshaller;
import com.amazonaws.services.sagemakerfeaturestoreruntime.model.transform.DeleteRecordResultJsonUnmarshaller;
import com.amazonaws.services.sagemakerfeaturestoreruntime.model.transform.GetRecordRequestProtocolMarshaller;
import com.amazonaws.services.sagemakerfeaturestoreruntime.model.transform.GetRecordResultJsonUnmarshaller;
import com.amazonaws.services.sagemakerfeaturestoreruntime.model.transform.InternalFailureExceptionUnmarshaller;
import com.amazonaws.services.sagemakerfeaturestoreruntime.model.transform.PutRecordRequestProtocolMarshaller;
import com.amazonaws.services.sagemakerfeaturestoreruntime.model.transform.PutRecordResultJsonUnmarshaller;
import com.amazonaws.services.sagemakerfeaturestoreruntime.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.sagemakerfeaturestoreruntime.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.sagemakerfeaturestoreruntime.model.transform.ValidationErrorExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonSageMakerFeatureStoreRuntimeClient
extends AmazonWebServiceClient
implements AmazonSageMakerFeatureStoreRuntime {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonSageMakerFeatureStoreRuntime.class);
    private static final String DEFAULT_SIGNING_NAME = "sagemaker";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalFailure").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalFailureExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationError").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationErrorExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailable").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceUnavailableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFound").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessForbidden").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessForbiddenExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonSageMakerFeatureStoreRuntimeException.class));

    public static AmazonSageMakerFeatureStoreRuntimeClientBuilder builder() {
        return AmazonSageMakerFeatureStoreRuntimeClientBuilder.standard();
    }

    AmazonSageMakerFeatureStoreRuntimeClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonSageMakerFeatureStoreRuntimeClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("featurestore-runtime.sagemaker");
        this.setEndpoint("featurestore-runtime.sagemaker.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/sagemakerfeaturestoreruntime/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/sagemakerfeaturestoreruntime/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public DeleteRecordResult deleteRecord(DeleteRecordRequest request) {
        request = (DeleteRecordRequest)this.beforeClientExecution(request);
        return this.executeDeleteRecord(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteRecordResult executeDeleteRecord(DeleteRecordRequest deleteRecordRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRecordRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRecordRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRecordRequestProtocolMarshaller(protocolFactory).marshall((DeleteRecordRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteRecordRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SageMaker FeatureStore Runtime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteRecord");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteRecordResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRecordResult deleteRecordResult = (DeleteRecordResult)response.getAwsResponse();
            return deleteRecordResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetRecordResult getRecord(GetRecordRequest request) {
        request = (GetRecordRequest)this.beforeClientExecution(request);
        return this.executeGetRecord(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRecordResult executeGetRecord(GetRecordRequest getRecordRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRecordRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRecordRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRecordRequestProtocolMarshaller(protocolFactory).marshall((GetRecordRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRecordRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SageMaker FeatureStore Runtime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetRecord");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRecordResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRecordResult getRecordResult = (GetRecordResult)response.getAwsResponse();
            return getRecordResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutRecordResult putRecord(PutRecordRequest request) {
        request = (PutRecordRequest)this.beforeClientExecution(request);
        return this.executePutRecord(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutRecordResult executePutRecord(PutRecordRequest putRecordRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putRecordRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutRecordRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutRecordRequestProtocolMarshaller(protocolFactory).marshall((PutRecordRequest)super.beforeMarshalling((AmazonWebServiceRequest)putRecordRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SageMaker FeatureStore Runtime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutRecord");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutRecordResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutRecordResult putRecordResult = (PutRecordResult)response.getAwsResponse();
            return putRecordResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

