/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.InferenceHubAccessConfig;
import com.amazonaws.services.sagemaker.model.ModelAccessConfig;
import com.amazonaws.services.sagemaker.model.ModelCompressionType;
import com.amazonaws.services.sagemaker.model.S3ModelDataType;
import com.amazonaws.services.sagemaker.model.transform.S3ModelDataSourceMarshaller;
import java.io.Serializable;

public class S3ModelDataSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String s3Uri;
    private String s3DataType;
    private String compressionType;
    private ModelAccessConfig modelAccessConfig;
    private InferenceHubAccessConfig hubAccessConfig;

    public void setS3Uri(String s3Uri) {
        this.s3Uri = s3Uri;
    }

    public String getS3Uri() {
        return this.s3Uri;
    }

    public S3ModelDataSource withS3Uri(String s3Uri) {
        this.setS3Uri(s3Uri);
        return this;
    }

    public void setS3DataType(String s3DataType) {
        this.s3DataType = s3DataType;
    }

    public String getS3DataType() {
        return this.s3DataType;
    }

    public S3ModelDataSource withS3DataType(String s3DataType) {
        this.setS3DataType(s3DataType);
        return this;
    }

    public S3ModelDataSource withS3DataType(S3ModelDataType s3DataType) {
        this.s3DataType = s3DataType.toString();
        return this;
    }

    public void setCompressionType(String compressionType) {
        this.compressionType = compressionType;
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    public S3ModelDataSource withCompressionType(String compressionType) {
        this.setCompressionType(compressionType);
        return this;
    }

    public S3ModelDataSource withCompressionType(ModelCompressionType compressionType) {
        this.compressionType = compressionType.toString();
        return this;
    }

    public void setModelAccessConfig(ModelAccessConfig modelAccessConfig) {
        this.modelAccessConfig = modelAccessConfig;
    }

    public ModelAccessConfig getModelAccessConfig() {
        return this.modelAccessConfig;
    }

    public S3ModelDataSource withModelAccessConfig(ModelAccessConfig modelAccessConfig) {
        this.setModelAccessConfig(modelAccessConfig);
        return this;
    }

    public void setHubAccessConfig(InferenceHubAccessConfig hubAccessConfig) {
        this.hubAccessConfig = hubAccessConfig;
    }

    public InferenceHubAccessConfig getHubAccessConfig() {
        return this.hubAccessConfig;
    }

    public S3ModelDataSource withHubAccessConfig(InferenceHubAccessConfig hubAccessConfig) {
        this.setHubAccessConfig(hubAccessConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3Uri() != null) {
            sb.append("S3Uri: ").append(this.getS3Uri()).append(",");
        }
        if (this.getS3DataType() != null) {
            sb.append("S3DataType: ").append(this.getS3DataType()).append(",");
        }
        if (this.getCompressionType() != null) {
            sb.append("CompressionType: ").append(this.getCompressionType()).append(",");
        }
        if (this.getModelAccessConfig() != null) {
            sb.append("ModelAccessConfig: ").append(this.getModelAccessConfig()).append(",");
        }
        if (this.getHubAccessConfig() != null) {
            sb.append("HubAccessConfig: ").append(this.getHubAccessConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ModelDataSource)) {
            return false;
        }
        S3ModelDataSource other = (S3ModelDataSource)obj;
        if (other.getS3Uri() == null ^ this.getS3Uri() == null) {
            return false;
        }
        if (other.getS3Uri() != null && !other.getS3Uri().equals(this.getS3Uri())) {
            return false;
        }
        if (other.getS3DataType() == null ^ this.getS3DataType() == null) {
            return false;
        }
        if (other.getS3DataType() != null && !other.getS3DataType().equals(this.getS3DataType())) {
            return false;
        }
        if (other.getCompressionType() == null ^ this.getCompressionType() == null) {
            return false;
        }
        if (other.getCompressionType() != null && !other.getCompressionType().equals(this.getCompressionType())) {
            return false;
        }
        if (other.getModelAccessConfig() == null ^ this.getModelAccessConfig() == null) {
            return false;
        }
        if (other.getModelAccessConfig() != null && !other.getModelAccessConfig().equals(this.getModelAccessConfig())) {
            return false;
        }
        if (other.getHubAccessConfig() == null ^ this.getHubAccessConfig() == null) {
            return false;
        }
        return other.getHubAccessConfig() == null || other.getHubAccessConfig().equals(this.getHubAccessConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3Uri() == null ? 0 : this.getS3Uri().hashCode());
        hashCode = 31 * hashCode + (this.getS3DataType() == null ? 0 : this.getS3DataType().hashCode());
        hashCode = 31 * hashCode + (this.getCompressionType() == null ? 0 : this.getCompressionType().hashCode());
        hashCode = 31 * hashCode + (this.getModelAccessConfig() == null ? 0 : this.getModelAccessConfig().hashCode());
        hashCode = 31 * hashCode + (this.getHubAccessConfig() == null ? 0 : this.getHubAccessConfig().hashCode());
        return hashCode;
    }

    public S3ModelDataSource clone() {
        try {
            return (S3ModelDataSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ModelDataSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

