/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.SpaceDetails;
import java.util.Date;

@SdkInternalApi
public class SpaceDetailsMarshaller {
    private static final MarshallingInfo<String> DOMAINID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainId").build();
    private static final MarshallingInfo<String> SPACENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SpaceName").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> SPACESETTINGSSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SpaceSettingsSummary").build();
    private static final MarshallingInfo<StructuredPojo> SPACESHARINGSETTINGSSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SpaceSharingSettingsSummary").build();
    private static final MarshallingInfo<StructuredPojo> OWNERSHIPSETTINGSSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnershipSettingsSummary").build();
    private static final MarshallingInfo<String> SPACEDISPLAYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SpaceDisplayName").build();
    private static final SpaceDetailsMarshaller instance = new SpaceDetailsMarshaller();

    public static SpaceDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(SpaceDetails spaceDetails, ProtocolMarshaller protocolMarshaller) {
        if (spaceDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)spaceDetails.getDomainId(), DOMAINID_BINDING);
            protocolMarshaller.marshall((Object)spaceDetails.getSpaceName(), SPACENAME_BINDING);
            protocolMarshaller.marshall((Object)spaceDetails.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)spaceDetails.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)spaceDetails.getLastModifiedTime(), LASTMODIFIEDTIME_BINDING);
            protocolMarshaller.marshall((Object)spaceDetails.getSpaceSettingsSummary(), SPACESETTINGSSUMMARY_BINDING);
            protocolMarshaller.marshall((Object)spaceDetails.getSpaceSharingSettingsSummary(), SPACESHARINGSETTINGSSUMMARY_BINDING);
            protocolMarshaller.marshall((Object)spaceDetails.getOwnershipSettingsSummary(), OWNERSHIPSETTINGSSUMMARY_BINDING);
            protocolMarshaller.marshall((Object)spaceDetails.getSpaceDisplayName(), SPACEDISPLAYNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

