/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.ModelPackage;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class ModelPackageMarshaller {
    private static final MarshallingInfo<String> MODELPACKAGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelPackageName").build();
    private static final MarshallingInfo<String> MODELPACKAGEGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelPackageGroupName").build();
    private static final MarshallingInfo<Integer> MODELPACKAGEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelPackageVersion").build();
    private static final MarshallingInfo<String> MODELPACKAGEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelPackageArn").build();
    private static final MarshallingInfo<String> MODELPACKAGEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelPackageDescription").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> INFERENCESPECIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InferenceSpecification").build();
    private static final MarshallingInfo<StructuredPojo> SOURCEALGORITHMSPECIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceAlgorithmSpecification").build();
    private static final MarshallingInfo<StructuredPojo> VALIDATIONSPECIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidationSpecification").build();
    private static final MarshallingInfo<String> MODELPACKAGESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelPackageStatus").build();
    private static final MarshallingInfo<StructuredPojo> MODELPACKAGESTATUSDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelPackageStatusDetails").build();
    private static final MarshallingInfo<Boolean> CERTIFYFORMARKETPLACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertifyForMarketplace").build();
    private static final MarshallingInfo<String> MODELAPPROVALSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelApprovalStatus").build();
    private static final MarshallingInfo<StructuredPojo> CREATEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedBy").build();
    private static final MarshallingInfo<StructuredPojo> METADATAPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetadataProperties").build();
    private static final MarshallingInfo<StructuredPojo> MODELMETRICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelMetrics").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> LASTMODIFIEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedBy").build();
    private static final MarshallingInfo<String> APPROVALDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApprovalDescription").build();
    private static final MarshallingInfo<String> DOMAIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Domain").build();
    private static final MarshallingInfo<String> TASK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Task").build();
    private static final MarshallingInfo<String> SAMPLEPAYLOADURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SamplePayloadUrl").build();
    private static final MarshallingInfo<List> ADDITIONALINFERENCESPECIFICATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdditionalInferenceSpecifications").build();
    private static final MarshallingInfo<String> SOURCEURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceUri").build();
    private static final MarshallingInfo<StructuredPojo> SECURITYCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityConfig").build();
    private static final MarshallingInfo<StructuredPojo> MODELCARD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelCard").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final MarshallingInfo<Map> CUSTOMERMETADATAPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomerMetadataProperties").build();
    private static final MarshallingInfo<StructuredPojo> DRIFTCHECKBASELINES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DriftCheckBaselines").build();
    private static final MarshallingInfo<String> SKIPMODELVALIDATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkipModelValidation").build();
    private static final ModelPackageMarshaller instance = new ModelPackageMarshaller();

    public static ModelPackageMarshaller getInstance() {
        return instance;
    }

    public void marshall(ModelPackage modelPackage, ProtocolMarshaller protocolMarshaller) {
        if (modelPackage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)modelPackage.getModelPackageName(), MODELPACKAGENAME_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getModelPackageGroupName(), MODELPACKAGEGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getModelPackageVersion(), MODELPACKAGEVERSION_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getModelPackageArn(), MODELPACKAGEARN_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getModelPackageDescription(), MODELPACKAGEDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getInferenceSpecification(), INFERENCESPECIFICATION_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getSourceAlgorithmSpecification(), SOURCEALGORITHMSPECIFICATION_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getValidationSpecification(), VALIDATIONSPECIFICATION_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getModelPackageStatus(), MODELPACKAGESTATUS_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getModelPackageStatusDetails(), MODELPACKAGESTATUSDETAILS_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getCertifyForMarketplace(), CERTIFYFORMARKETPLACE_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getModelApprovalStatus(), MODELAPPROVALSTATUS_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getCreatedBy(), CREATEDBY_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getMetadataProperties(), METADATAPROPERTIES_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getModelMetrics(), MODELMETRICS_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getLastModifiedTime(), LASTMODIFIEDTIME_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getLastModifiedBy(), LASTMODIFIEDBY_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getApprovalDescription(), APPROVALDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getDomain(), DOMAIN_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getTask(), TASK_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getSamplePayloadUrl(), SAMPLEPAYLOADURL_BINDING);
            protocolMarshaller.marshall(modelPackage.getAdditionalInferenceSpecifications(), ADDITIONALINFERENCESPECIFICATIONS_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getSourceUri(), SOURCEURI_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getSecurityConfig(), SECURITYCONFIG_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getModelCard(), MODELCARD_BINDING);
            protocolMarshaller.marshall(modelPackage.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall(modelPackage.getCustomerMetadataProperties(), CUSTOMERMETADATAPROPERTIES_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getDriftCheckBaselines(), DRIFTCHECKBASELINES_BINDING);
            protocolMarshaller.marshall((Object)modelPackage.getSkipModelValidation(), SKIPMODELVALIDATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

