/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.JupyterServerAppSettings;
import com.amazonaws.services.sagemaker.model.KernelGatewayAppSettings;
import com.amazonaws.services.sagemaker.model.RSessionAppSettings;
import com.amazonaws.services.sagemaker.model.RStudioServerProAppSettings;
import com.amazonaws.services.sagemaker.model.SharingSettings;
import com.amazonaws.services.sagemaker.model.TensorBoardAppSettings;
import com.amazonaws.services.sagemaker.model.transform.UserSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UserSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private String executionRole;
    private List<String> securityGroups;
    private SharingSettings sharingSettings;
    private JupyterServerAppSettings jupyterServerAppSettings;
    private KernelGatewayAppSettings kernelGatewayAppSettings;
    private TensorBoardAppSettings tensorBoardAppSettings;
    private RStudioServerProAppSettings rStudioServerProAppSettings;
    private RSessionAppSettings rSessionAppSettings;

    public void setExecutionRole(String executionRole) {
        this.executionRole = executionRole;
    }

    public String getExecutionRole() {
        return this.executionRole;
    }

    public UserSettings withExecutionRole(String executionRole) {
        this.setExecutionRole(executionRole);
        return this;
    }

    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new ArrayList<String>(securityGroups);
    }

    public UserSettings withSecurityGroups(String ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups(new ArrayList<String>(securityGroups.length));
        }
        for (String ele : securityGroups) {
            this.securityGroups.add(ele);
        }
        return this;
    }

    public UserSettings withSecurityGroups(Collection<String> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public void setSharingSettings(SharingSettings sharingSettings) {
        this.sharingSettings = sharingSettings;
    }

    public SharingSettings getSharingSettings() {
        return this.sharingSettings;
    }

    public UserSettings withSharingSettings(SharingSettings sharingSettings) {
        this.setSharingSettings(sharingSettings);
        return this;
    }

    public void setJupyterServerAppSettings(JupyterServerAppSettings jupyterServerAppSettings) {
        this.jupyterServerAppSettings = jupyterServerAppSettings;
    }

    public JupyterServerAppSettings getJupyterServerAppSettings() {
        return this.jupyterServerAppSettings;
    }

    public UserSettings withJupyterServerAppSettings(JupyterServerAppSettings jupyterServerAppSettings) {
        this.setJupyterServerAppSettings(jupyterServerAppSettings);
        return this;
    }

    public void setKernelGatewayAppSettings(KernelGatewayAppSettings kernelGatewayAppSettings) {
        this.kernelGatewayAppSettings = kernelGatewayAppSettings;
    }

    public KernelGatewayAppSettings getKernelGatewayAppSettings() {
        return this.kernelGatewayAppSettings;
    }

    public UserSettings withKernelGatewayAppSettings(KernelGatewayAppSettings kernelGatewayAppSettings) {
        this.setKernelGatewayAppSettings(kernelGatewayAppSettings);
        return this;
    }

    public void setTensorBoardAppSettings(TensorBoardAppSettings tensorBoardAppSettings) {
        this.tensorBoardAppSettings = tensorBoardAppSettings;
    }

    public TensorBoardAppSettings getTensorBoardAppSettings() {
        return this.tensorBoardAppSettings;
    }

    public UserSettings withTensorBoardAppSettings(TensorBoardAppSettings tensorBoardAppSettings) {
        this.setTensorBoardAppSettings(tensorBoardAppSettings);
        return this;
    }

    public void setRStudioServerProAppSettings(RStudioServerProAppSettings rStudioServerProAppSettings) {
        this.rStudioServerProAppSettings = rStudioServerProAppSettings;
    }

    public RStudioServerProAppSettings getRStudioServerProAppSettings() {
        return this.rStudioServerProAppSettings;
    }

    public UserSettings withRStudioServerProAppSettings(RStudioServerProAppSettings rStudioServerProAppSettings) {
        this.setRStudioServerProAppSettings(rStudioServerProAppSettings);
        return this;
    }

    public void setRSessionAppSettings(RSessionAppSettings rSessionAppSettings) {
        this.rSessionAppSettings = rSessionAppSettings;
    }

    public RSessionAppSettings getRSessionAppSettings() {
        return this.rSessionAppSettings;
    }

    public UserSettings withRSessionAppSettings(RSessionAppSettings rSessionAppSettings) {
        this.setRSessionAppSettings(rSessionAppSettings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExecutionRole() != null) {
            sb.append("ExecutionRole: ").append(this.getExecutionRole()).append(",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.getSecurityGroups()).append(",");
        }
        if (this.getSharingSettings() != null) {
            sb.append("SharingSettings: ").append(this.getSharingSettings()).append(",");
        }
        if (this.getJupyterServerAppSettings() != null) {
            sb.append("JupyterServerAppSettings: ").append(this.getJupyterServerAppSettings()).append(",");
        }
        if (this.getKernelGatewayAppSettings() != null) {
            sb.append("KernelGatewayAppSettings: ").append(this.getKernelGatewayAppSettings()).append(",");
        }
        if (this.getTensorBoardAppSettings() != null) {
            sb.append("TensorBoardAppSettings: ").append(this.getTensorBoardAppSettings()).append(",");
        }
        if (this.getRStudioServerProAppSettings() != null) {
            sb.append("RStudioServerProAppSettings: ").append(this.getRStudioServerProAppSettings()).append(",");
        }
        if (this.getRSessionAppSettings() != null) {
            sb.append("RSessionAppSettings: ").append(this.getRSessionAppSettings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserSettings)) {
            return false;
        }
        UserSettings other = (UserSettings)obj;
        if (other.getExecutionRole() == null ^ this.getExecutionRole() == null) {
            return false;
        }
        if (other.getExecutionRole() != null && !other.getExecutionRole().equals(this.getExecutionRole())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !other.getSecurityGroups().equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getSharingSettings() == null ^ this.getSharingSettings() == null) {
            return false;
        }
        if (other.getSharingSettings() != null && !other.getSharingSettings().equals(this.getSharingSettings())) {
            return false;
        }
        if (other.getJupyterServerAppSettings() == null ^ this.getJupyterServerAppSettings() == null) {
            return false;
        }
        if (other.getJupyterServerAppSettings() != null && !other.getJupyterServerAppSettings().equals(this.getJupyterServerAppSettings())) {
            return false;
        }
        if (other.getKernelGatewayAppSettings() == null ^ this.getKernelGatewayAppSettings() == null) {
            return false;
        }
        if (other.getKernelGatewayAppSettings() != null && !other.getKernelGatewayAppSettings().equals(this.getKernelGatewayAppSettings())) {
            return false;
        }
        if (other.getTensorBoardAppSettings() == null ^ this.getTensorBoardAppSettings() == null) {
            return false;
        }
        if (other.getTensorBoardAppSettings() != null && !other.getTensorBoardAppSettings().equals(this.getTensorBoardAppSettings())) {
            return false;
        }
        if (other.getRStudioServerProAppSettings() == null ^ this.getRStudioServerProAppSettings() == null) {
            return false;
        }
        if (other.getRStudioServerProAppSettings() != null && !other.getRStudioServerProAppSettings().equals(this.getRStudioServerProAppSettings())) {
            return false;
        }
        if (other.getRSessionAppSettings() == null ^ this.getRSessionAppSettings() == null) {
            return false;
        }
        return other.getRSessionAppSettings() == null || other.getRSessionAppSettings().equals(this.getRSessionAppSettings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExecutionRole() == null ? 0 : this.getExecutionRole().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getSharingSettings() == null ? 0 : this.getSharingSettings().hashCode());
        hashCode = 31 * hashCode + (this.getJupyterServerAppSettings() == null ? 0 : this.getJupyterServerAppSettings().hashCode());
        hashCode = 31 * hashCode + (this.getKernelGatewayAppSettings() == null ? 0 : this.getKernelGatewayAppSettings().hashCode());
        hashCode = 31 * hashCode + (this.getTensorBoardAppSettings() == null ? 0 : this.getTensorBoardAppSettings().hashCode());
        hashCode = 31 * hashCode + (this.getRStudioServerProAppSettings() == null ? 0 : this.getRStudioServerProAppSettings().hashCode());
        hashCode = 31 * hashCode + (this.getRSessionAppSettings() == null ? 0 : this.getRSessionAppSettings().hashCode());
        return hashCode;
    }

    public UserSettings clone() {
        try {
            return (UserSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

