/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.sagemaker.model.Workforce;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListWorkforcesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Workforce> workforces;
    private String nextToken;

    public List<Workforce> getWorkforces() {
        return this.workforces;
    }

    public void setWorkforces(Collection<Workforce> workforces) {
        if (workforces == null) {
            this.workforces = null;
            return;
        }
        this.workforces = new ArrayList<Workforce>(workforces);
    }

    public ListWorkforcesResult withWorkforces(Workforce ... workforces) {
        if (this.workforces == null) {
            this.setWorkforces(new ArrayList<Workforce>(workforces.length));
        }
        for (Workforce ele : workforces) {
            this.workforces.add(ele);
        }
        return this;
    }

    public ListWorkforcesResult withWorkforces(Collection<Workforce> workforces) {
        this.setWorkforces(workforces);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListWorkforcesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWorkforces() != null) {
            sb.append("Workforces: ").append(this.getWorkforces()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkforcesResult)) {
            return false;
        }
        ListWorkforcesResult other = (ListWorkforcesResult)obj;
        if (other.getWorkforces() == null ^ this.getWorkforces() == null) {
            return false;
        }
        if (other.getWorkforces() != null && !other.getWorkforces().equals(this.getWorkforces())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWorkforces() == null ? 0 : this.getWorkforces().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListWorkforcesResult clone() {
        try {
            return (ListWorkforcesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

