/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.Destination;
import com.amazonaws.services.s3control.model.transform.AccessControlTranslationStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.EncryptionConfigurationStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.MetricsStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.ReplicationTimeStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class DestinationStaxUnmarshaller
implements Unmarshaller<Destination, StaxUnmarshallerContext> {
    private static DestinationStaxUnmarshaller instance;

    public Destination unmarshall(StaxUnmarshallerContext context) throws Exception {
        Destination destination = new Destination();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return destination;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Account", targetDepth)) {
                    destination.setAccount(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Bucket", targetDepth)) {
                    destination.setBucket(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReplicationTime", targetDepth)) {
                    destination.setReplicationTime(ReplicationTimeStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AccessControlTranslation", targetDepth)) {
                    destination.setAccessControlTranslation(AccessControlTranslationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EncryptionConfiguration", targetDepth)) {
                    destination.setEncryptionConfiguration(EncryptionConfigurationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Metrics", targetDepth)) {
                    destination.setMetrics(MetricsStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("StorageClass", targetDepth)) continue;
                destination.setStorageClass(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return destination;
    }

    public static DestinationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DestinationStaxUnmarshaller();
        }
        return instance;
    }
}

