/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.NoncurrentVersionExpiration;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class NoncurrentVersionExpirationStaxUnmarshaller
implements Unmarshaller<NoncurrentVersionExpiration, StaxUnmarshallerContext> {
    private static NoncurrentVersionExpirationStaxUnmarshaller instance;

    public NoncurrentVersionExpiration unmarshall(StaxUnmarshallerContext context) throws Exception {
        NoncurrentVersionExpiration noncurrentVersionExpiration = new NoncurrentVersionExpiration();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return noncurrentVersionExpiration;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("NoncurrentDays", targetDepth)) {
                    noncurrentVersionExpiration.setNoncurrentDays(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("NewerNoncurrentVersions", targetDepth)) continue;
                noncurrentVersionExpiration.setNewerNoncurrentVersions(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return noncurrentVersionExpiration;
    }

    public static NoncurrentVersionExpirationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new NoncurrentVersionExpirationStaxUnmarshaller();
        }
        return instance;
    }
}

