/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.Include;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class IncludeStaxUnmarshaller
implements Unmarshaller<Include, StaxUnmarshallerContext> {
    private static IncludeStaxUnmarshaller instance;

    public Include unmarshall(StaxUnmarshallerContext context) throws Exception {
        Include include = new Include();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return include;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Buckets", targetDepth)) {
                    include.withBuckets(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("Buckets/Arn", targetDepth)) {
                    include.withBuckets(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Regions", targetDepth)) {
                    include.withRegions(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("Regions/Region", targetDepth)) continue;
                include.withRegions(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return include;
    }

    public static IncludeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new IncludeStaxUnmarshaller();
        }
        return instance;
    }
}

