/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.s3control.AWSS3ControlAsync;
import com.amazonaws.services.s3control.AWSS3ControlAsyncClientBuilder;
import com.amazonaws.services.s3control.AWSS3ControlClient;
import com.amazonaws.services.s3control.model.CreateAccessPointRequest;
import com.amazonaws.services.s3control.model.CreateAccessPointResult;
import com.amazonaws.services.s3control.model.CreateBucketRequest;
import com.amazonaws.services.s3control.model.CreateBucketResult;
import com.amazonaws.services.s3control.model.CreateJobRequest;
import com.amazonaws.services.s3control.model.CreateJobResult;
import com.amazonaws.services.s3control.model.DeleteAccessPointPolicyRequest;
import com.amazonaws.services.s3control.model.DeleteAccessPointPolicyResult;
import com.amazonaws.services.s3control.model.DeleteAccessPointRequest;
import com.amazonaws.services.s3control.model.DeleteAccessPointResult;
import com.amazonaws.services.s3control.model.DeleteBucketLifecycleConfigurationRequest;
import com.amazonaws.services.s3control.model.DeleteBucketLifecycleConfigurationResult;
import com.amazonaws.services.s3control.model.DeleteBucketPolicyRequest;
import com.amazonaws.services.s3control.model.DeleteBucketPolicyResult;
import com.amazonaws.services.s3control.model.DeleteBucketRequest;
import com.amazonaws.services.s3control.model.DeleteBucketResult;
import com.amazonaws.services.s3control.model.DeleteBucketTaggingRequest;
import com.amazonaws.services.s3control.model.DeleteBucketTaggingResult;
import com.amazonaws.services.s3control.model.DeleteJobTaggingRequest;
import com.amazonaws.services.s3control.model.DeleteJobTaggingResult;
import com.amazonaws.services.s3control.model.DeletePublicAccessBlockRequest;
import com.amazonaws.services.s3control.model.DeletePublicAccessBlockResult;
import com.amazonaws.services.s3control.model.DescribeJobRequest;
import com.amazonaws.services.s3control.model.DescribeJobResult;
import com.amazonaws.services.s3control.model.GetAccessPointPolicyRequest;
import com.amazonaws.services.s3control.model.GetAccessPointPolicyResult;
import com.amazonaws.services.s3control.model.GetAccessPointPolicyStatusRequest;
import com.amazonaws.services.s3control.model.GetAccessPointPolicyStatusResult;
import com.amazonaws.services.s3control.model.GetAccessPointRequest;
import com.amazonaws.services.s3control.model.GetAccessPointResult;
import com.amazonaws.services.s3control.model.GetBucketLifecycleConfigurationRequest;
import com.amazonaws.services.s3control.model.GetBucketLifecycleConfigurationResult;
import com.amazonaws.services.s3control.model.GetBucketPolicyRequest;
import com.amazonaws.services.s3control.model.GetBucketPolicyResult;
import com.amazonaws.services.s3control.model.GetBucketRequest;
import com.amazonaws.services.s3control.model.GetBucketResult;
import com.amazonaws.services.s3control.model.GetBucketTaggingRequest;
import com.amazonaws.services.s3control.model.GetBucketTaggingResult;
import com.amazonaws.services.s3control.model.GetJobTaggingRequest;
import com.amazonaws.services.s3control.model.GetJobTaggingResult;
import com.amazonaws.services.s3control.model.GetPublicAccessBlockRequest;
import com.amazonaws.services.s3control.model.GetPublicAccessBlockResult;
import com.amazonaws.services.s3control.model.ListAccessPointsRequest;
import com.amazonaws.services.s3control.model.ListAccessPointsResult;
import com.amazonaws.services.s3control.model.ListJobsRequest;
import com.amazonaws.services.s3control.model.ListJobsResult;
import com.amazonaws.services.s3control.model.ListRegionalBucketsRequest;
import com.amazonaws.services.s3control.model.ListRegionalBucketsResult;
import com.amazonaws.services.s3control.model.PutAccessPointPolicyRequest;
import com.amazonaws.services.s3control.model.PutAccessPointPolicyResult;
import com.amazonaws.services.s3control.model.PutBucketLifecycleConfigurationRequest;
import com.amazonaws.services.s3control.model.PutBucketLifecycleConfigurationResult;
import com.amazonaws.services.s3control.model.PutBucketPolicyRequest;
import com.amazonaws.services.s3control.model.PutBucketPolicyResult;
import com.amazonaws.services.s3control.model.PutBucketTaggingRequest;
import com.amazonaws.services.s3control.model.PutBucketTaggingResult;
import com.amazonaws.services.s3control.model.PutJobTaggingRequest;
import com.amazonaws.services.s3control.model.PutJobTaggingResult;
import com.amazonaws.services.s3control.model.PutPublicAccessBlockRequest;
import com.amazonaws.services.s3control.model.PutPublicAccessBlockResult;
import com.amazonaws.services.s3control.model.UpdateJobPriorityRequest;
import com.amazonaws.services.s3control.model.UpdateJobPriorityResult;
import com.amazonaws.services.s3control.model.UpdateJobStatusRequest;
import com.amazonaws.services.s3control.model.UpdateJobStatusResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSS3ControlAsyncClient
extends AWSS3ControlClient
implements AWSS3ControlAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSS3ControlAsyncClientBuilder asyncBuilder() {
        return AWSS3ControlAsyncClientBuilder.standard();
    }

    AWSS3ControlAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSS3ControlAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateAccessPointResult> createAccessPointAsync(CreateAccessPointRequest request) {
        return this.createAccessPointAsync(request, null);
    }

    @Override
    public Future<CreateAccessPointResult> createAccessPointAsync(CreateAccessPointRequest request, final AsyncHandler<CreateAccessPointRequest, CreateAccessPointResult> asyncHandler) {
        final CreateAccessPointRequest finalRequest = (CreateAccessPointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAccessPointResult>(){

            @Override
            public CreateAccessPointResult call() throws Exception {
                CreateAccessPointResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeCreateAccessPoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateBucketResult> createBucketAsync(CreateBucketRequest request) {
        return this.createBucketAsync(request, null);
    }

    @Override
    public Future<CreateBucketResult> createBucketAsync(CreateBucketRequest request, final AsyncHandler<CreateBucketRequest, CreateBucketResult> asyncHandler) {
        final CreateBucketRequest finalRequest = (CreateBucketRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateBucketResult>(){

            @Override
            public CreateBucketResult call() throws Exception {
                CreateBucketResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeCreateBucket(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateJobResult> createJobAsync(CreateJobRequest request) {
        return this.createJobAsync(request, null);
    }

    @Override
    public Future<CreateJobResult> createJobAsync(CreateJobRequest request, final AsyncHandler<CreateJobRequest, CreateJobResult> asyncHandler) {
        final CreateJobRequest finalRequest = (CreateJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateJobResult>(){

            @Override
            public CreateJobResult call() throws Exception {
                CreateJobResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeCreateJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAccessPointResult> deleteAccessPointAsync(DeleteAccessPointRequest request) {
        return this.deleteAccessPointAsync(request, null);
    }

    @Override
    public Future<DeleteAccessPointResult> deleteAccessPointAsync(DeleteAccessPointRequest request, final AsyncHandler<DeleteAccessPointRequest, DeleteAccessPointResult> asyncHandler) {
        final DeleteAccessPointRequest finalRequest = (DeleteAccessPointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAccessPointResult>(){

            @Override
            public DeleteAccessPointResult call() throws Exception {
                DeleteAccessPointResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeDeleteAccessPoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAccessPointPolicyResult> deleteAccessPointPolicyAsync(DeleteAccessPointPolicyRequest request) {
        return this.deleteAccessPointPolicyAsync(request, null);
    }

    @Override
    public Future<DeleteAccessPointPolicyResult> deleteAccessPointPolicyAsync(DeleteAccessPointPolicyRequest request, final AsyncHandler<DeleteAccessPointPolicyRequest, DeleteAccessPointPolicyResult> asyncHandler) {
        final DeleteAccessPointPolicyRequest finalRequest = (DeleteAccessPointPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAccessPointPolicyResult>(){

            @Override
            public DeleteAccessPointPolicyResult call() throws Exception {
                DeleteAccessPointPolicyResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeDeleteAccessPointPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteBucketResult> deleteBucketAsync(DeleteBucketRequest request) {
        return this.deleteBucketAsync(request, null);
    }

    @Override
    public Future<DeleteBucketResult> deleteBucketAsync(DeleteBucketRequest request, final AsyncHandler<DeleteBucketRequest, DeleteBucketResult> asyncHandler) {
        final DeleteBucketRequest finalRequest = (DeleteBucketRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteBucketResult>(){

            @Override
            public DeleteBucketResult call() throws Exception {
                DeleteBucketResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeDeleteBucket(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteBucketLifecycleConfigurationResult> deleteBucketLifecycleConfigurationAsync(DeleteBucketLifecycleConfigurationRequest request) {
        return this.deleteBucketLifecycleConfigurationAsync(request, null);
    }

    @Override
    public Future<DeleteBucketLifecycleConfigurationResult> deleteBucketLifecycleConfigurationAsync(DeleteBucketLifecycleConfigurationRequest request, final AsyncHandler<DeleteBucketLifecycleConfigurationRequest, DeleteBucketLifecycleConfigurationResult> asyncHandler) {
        final DeleteBucketLifecycleConfigurationRequest finalRequest = (DeleteBucketLifecycleConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteBucketLifecycleConfigurationResult>(){

            @Override
            public DeleteBucketLifecycleConfigurationResult call() throws Exception {
                DeleteBucketLifecycleConfigurationResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeDeleteBucketLifecycleConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteBucketPolicyResult> deleteBucketPolicyAsync(DeleteBucketPolicyRequest request) {
        return this.deleteBucketPolicyAsync(request, null);
    }

    @Override
    public Future<DeleteBucketPolicyResult> deleteBucketPolicyAsync(DeleteBucketPolicyRequest request, final AsyncHandler<DeleteBucketPolicyRequest, DeleteBucketPolicyResult> asyncHandler) {
        final DeleteBucketPolicyRequest finalRequest = (DeleteBucketPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteBucketPolicyResult>(){

            @Override
            public DeleteBucketPolicyResult call() throws Exception {
                DeleteBucketPolicyResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeDeleteBucketPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteBucketTaggingResult> deleteBucketTaggingAsync(DeleteBucketTaggingRequest request) {
        return this.deleteBucketTaggingAsync(request, null);
    }

    @Override
    public Future<DeleteBucketTaggingResult> deleteBucketTaggingAsync(DeleteBucketTaggingRequest request, final AsyncHandler<DeleteBucketTaggingRequest, DeleteBucketTaggingResult> asyncHandler) {
        final DeleteBucketTaggingRequest finalRequest = (DeleteBucketTaggingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteBucketTaggingResult>(){

            @Override
            public DeleteBucketTaggingResult call() throws Exception {
                DeleteBucketTaggingResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeDeleteBucketTagging(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteJobTaggingResult> deleteJobTaggingAsync(DeleteJobTaggingRequest request) {
        return this.deleteJobTaggingAsync(request, null);
    }

    @Override
    public Future<DeleteJobTaggingResult> deleteJobTaggingAsync(DeleteJobTaggingRequest request, final AsyncHandler<DeleteJobTaggingRequest, DeleteJobTaggingResult> asyncHandler) {
        final DeleteJobTaggingRequest finalRequest = (DeleteJobTaggingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteJobTaggingResult>(){

            @Override
            public DeleteJobTaggingResult call() throws Exception {
                DeleteJobTaggingResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeDeleteJobTagging(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePublicAccessBlockResult> deletePublicAccessBlockAsync(DeletePublicAccessBlockRequest request) {
        return this.deletePublicAccessBlockAsync(request, null);
    }

    @Override
    public Future<DeletePublicAccessBlockResult> deletePublicAccessBlockAsync(DeletePublicAccessBlockRequest request, final AsyncHandler<DeletePublicAccessBlockRequest, DeletePublicAccessBlockResult> asyncHandler) {
        final DeletePublicAccessBlockRequest finalRequest = (DeletePublicAccessBlockRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePublicAccessBlockResult>(){

            @Override
            public DeletePublicAccessBlockResult call() throws Exception {
                DeletePublicAccessBlockResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeDeletePublicAccessBlock(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeJobResult> describeJobAsync(DescribeJobRequest request) {
        return this.describeJobAsync(request, null);
    }

    @Override
    public Future<DescribeJobResult> describeJobAsync(DescribeJobRequest request, final AsyncHandler<DescribeJobRequest, DescribeJobResult> asyncHandler) {
        final DescribeJobRequest finalRequest = (DescribeJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeJobResult>(){

            @Override
            public DescribeJobResult call() throws Exception {
                DescribeJobResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeDescribeJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAccessPointResult> getAccessPointAsync(GetAccessPointRequest request) {
        return this.getAccessPointAsync(request, null);
    }

    @Override
    public Future<GetAccessPointResult> getAccessPointAsync(GetAccessPointRequest request, final AsyncHandler<GetAccessPointRequest, GetAccessPointResult> asyncHandler) {
        final GetAccessPointRequest finalRequest = (GetAccessPointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAccessPointResult>(){

            @Override
            public GetAccessPointResult call() throws Exception {
                GetAccessPointResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeGetAccessPoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAccessPointPolicyResult> getAccessPointPolicyAsync(GetAccessPointPolicyRequest request) {
        return this.getAccessPointPolicyAsync(request, null);
    }

    @Override
    public Future<GetAccessPointPolicyResult> getAccessPointPolicyAsync(GetAccessPointPolicyRequest request, final AsyncHandler<GetAccessPointPolicyRequest, GetAccessPointPolicyResult> asyncHandler) {
        final GetAccessPointPolicyRequest finalRequest = (GetAccessPointPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAccessPointPolicyResult>(){

            @Override
            public GetAccessPointPolicyResult call() throws Exception {
                GetAccessPointPolicyResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeGetAccessPointPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAccessPointPolicyStatusResult> getAccessPointPolicyStatusAsync(GetAccessPointPolicyStatusRequest request) {
        return this.getAccessPointPolicyStatusAsync(request, null);
    }

    @Override
    public Future<GetAccessPointPolicyStatusResult> getAccessPointPolicyStatusAsync(GetAccessPointPolicyStatusRequest request, final AsyncHandler<GetAccessPointPolicyStatusRequest, GetAccessPointPolicyStatusResult> asyncHandler) {
        final GetAccessPointPolicyStatusRequest finalRequest = (GetAccessPointPolicyStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAccessPointPolicyStatusResult>(){

            @Override
            public GetAccessPointPolicyStatusResult call() throws Exception {
                GetAccessPointPolicyStatusResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeGetAccessPointPolicyStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBucketResult> getBucketAsync(GetBucketRequest request) {
        return this.getBucketAsync(request, null);
    }

    @Override
    public Future<GetBucketResult> getBucketAsync(GetBucketRequest request, final AsyncHandler<GetBucketRequest, GetBucketResult> asyncHandler) {
        final GetBucketRequest finalRequest = (GetBucketRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetBucketResult>(){

            @Override
            public GetBucketResult call() throws Exception {
                GetBucketResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeGetBucket(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBucketLifecycleConfigurationResult> getBucketLifecycleConfigurationAsync(GetBucketLifecycleConfigurationRequest request) {
        return this.getBucketLifecycleConfigurationAsync(request, null);
    }

    @Override
    public Future<GetBucketLifecycleConfigurationResult> getBucketLifecycleConfigurationAsync(GetBucketLifecycleConfigurationRequest request, final AsyncHandler<GetBucketLifecycleConfigurationRequest, GetBucketLifecycleConfigurationResult> asyncHandler) {
        final GetBucketLifecycleConfigurationRequest finalRequest = (GetBucketLifecycleConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetBucketLifecycleConfigurationResult>(){

            @Override
            public GetBucketLifecycleConfigurationResult call() throws Exception {
                GetBucketLifecycleConfigurationResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeGetBucketLifecycleConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBucketPolicyResult> getBucketPolicyAsync(GetBucketPolicyRequest request) {
        return this.getBucketPolicyAsync(request, null);
    }

    @Override
    public Future<GetBucketPolicyResult> getBucketPolicyAsync(GetBucketPolicyRequest request, final AsyncHandler<GetBucketPolicyRequest, GetBucketPolicyResult> asyncHandler) {
        final GetBucketPolicyRequest finalRequest = (GetBucketPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetBucketPolicyResult>(){

            @Override
            public GetBucketPolicyResult call() throws Exception {
                GetBucketPolicyResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeGetBucketPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBucketTaggingResult> getBucketTaggingAsync(GetBucketTaggingRequest request) {
        return this.getBucketTaggingAsync(request, null);
    }

    @Override
    public Future<GetBucketTaggingResult> getBucketTaggingAsync(GetBucketTaggingRequest request, final AsyncHandler<GetBucketTaggingRequest, GetBucketTaggingResult> asyncHandler) {
        final GetBucketTaggingRequest finalRequest = (GetBucketTaggingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetBucketTaggingResult>(){

            @Override
            public GetBucketTaggingResult call() throws Exception {
                GetBucketTaggingResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeGetBucketTagging(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetJobTaggingResult> getJobTaggingAsync(GetJobTaggingRequest request) {
        return this.getJobTaggingAsync(request, null);
    }

    @Override
    public Future<GetJobTaggingResult> getJobTaggingAsync(GetJobTaggingRequest request, final AsyncHandler<GetJobTaggingRequest, GetJobTaggingResult> asyncHandler) {
        final GetJobTaggingRequest finalRequest = (GetJobTaggingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetJobTaggingResult>(){

            @Override
            public GetJobTaggingResult call() throws Exception {
                GetJobTaggingResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeGetJobTagging(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPublicAccessBlockResult> getPublicAccessBlockAsync(GetPublicAccessBlockRequest request) {
        return this.getPublicAccessBlockAsync(request, null);
    }

    @Override
    public Future<GetPublicAccessBlockResult> getPublicAccessBlockAsync(GetPublicAccessBlockRequest request, final AsyncHandler<GetPublicAccessBlockRequest, GetPublicAccessBlockResult> asyncHandler) {
        final GetPublicAccessBlockRequest finalRequest = (GetPublicAccessBlockRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPublicAccessBlockResult>(){

            @Override
            public GetPublicAccessBlockResult call() throws Exception {
                GetPublicAccessBlockResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeGetPublicAccessBlock(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAccessPointsResult> listAccessPointsAsync(ListAccessPointsRequest request) {
        return this.listAccessPointsAsync(request, null);
    }

    @Override
    public Future<ListAccessPointsResult> listAccessPointsAsync(ListAccessPointsRequest request, final AsyncHandler<ListAccessPointsRequest, ListAccessPointsResult> asyncHandler) {
        final ListAccessPointsRequest finalRequest = (ListAccessPointsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAccessPointsResult>(){

            @Override
            public ListAccessPointsResult call() throws Exception {
                ListAccessPointsResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeListAccessPoints(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(ListJobsRequest request) {
        return this.listJobsAsync(request, null);
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(ListJobsRequest request, final AsyncHandler<ListJobsRequest, ListJobsResult> asyncHandler) {
        final ListJobsRequest finalRequest = (ListJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListJobsResult>(){

            @Override
            public ListJobsResult call() throws Exception {
                ListJobsResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeListJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRegionalBucketsResult> listRegionalBucketsAsync(ListRegionalBucketsRequest request) {
        return this.listRegionalBucketsAsync(request, null);
    }

    @Override
    public Future<ListRegionalBucketsResult> listRegionalBucketsAsync(ListRegionalBucketsRequest request, final AsyncHandler<ListRegionalBucketsRequest, ListRegionalBucketsResult> asyncHandler) {
        final ListRegionalBucketsRequest finalRequest = (ListRegionalBucketsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRegionalBucketsResult>(){

            @Override
            public ListRegionalBucketsResult call() throws Exception {
                ListRegionalBucketsResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeListRegionalBuckets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutAccessPointPolicyResult> putAccessPointPolicyAsync(PutAccessPointPolicyRequest request) {
        return this.putAccessPointPolicyAsync(request, null);
    }

    @Override
    public Future<PutAccessPointPolicyResult> putAccessPointPolicyAsync(PutAccessPointPolicyRequest request, final AsyncHandler<PutAccessPointPolicyRequest, PutAccessPointPolicyResult> asyncHandler) {
        final PutAccessPointPolicyRequest finalRequest = (PutAccessPointPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutAccessPointPolicyResult>(){

            @Override
            public PutAccessPointPolicyResult call() throws Exception {
                PutAccessPointPolicyResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executePutAccessPointPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutBucketLifecycleConfigurationResult> putBucketLifecycleConfigurationAsync(PutBucketLifecycleConfigurationRequest request) {
        return this.putBucketLifecycleConfigurationAsync(request, null);
    }

    @Override
    public Future<PutBucketLifecycleConfigurationResult> putBucketLifecycleConfigurationAsync(PutBucketLifecycleConfigurationRequest request, final AsyncHandler<PutBucketLifecycleConfigurationRequest, PutBucketLifecycleConfigurationResult> asyncHandler) {
        final PutBucketLifecycleConfigurationRequest finalRequest = (PutBucketLifecycleConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutBucketLifecycleConfigurationResult>(){

            @Override
            public PutBucketLifecycleConfigurationResult call() throws Exception {
                PutBucketLifecycleConfigurationResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executePutBucketLifecycleConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutBucketPolicyResult> putBucketPolicyAsync(PutBucketPolicyRequest request) {
        return this.putBucketPolicyAsync(request, null);
    }

    @Override
    public Future<PutBucketPolicyResult> putBucketPolicyAsync(PutBucketPolicyRequest request, final AsyncHandler<PutBucketPolicyRequest, PutBucketPolicyResult> asyncHandler) {
        final PutBucketPolicyRequest finalRequest = (PutBucketPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutBucketPolicyResult>(){

            @Override
            public PutBucketPolicyResult call() throws Exception {
                PutBucketPolicyResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executePutBucketPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutBucketTaggingResult> putBucketTaggingAsync(PutBucketTaggingRequest request) {
        return this.putBucketTaggingAsync(request, null);
    }

    @Override
    public Future<PutBucketTaggingResult> putBucketTaggingAsync(PutBucketTaggingRequest request, final AsyncHandler<PutBucketTaggingRequest, PutBucketTaggingResult> asyncHandler) {
        final PutBucketTaggingRequest finalRequest = (PutBucketTaggingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutBucketTaggingResult>(){

            @Override
            public PutBucketTaggingResult call() throws Exception {
                PutBucketTaggingResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executePutBucketTagging(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutJobTaggingResult> putJobTaggingAsync(PutJobTaggingRequest request) {
        return this.putJobTaggingAsync(request, null);
    }

    @Override
    public Future<PutJobTaggingResult> putJobTaggingAsync(PutJobTaggingRequest request, final AsyncHandler<PutJobTaggingRequest, PutJobTaggingResult> asyncHandler) {
        final PutJobTaggingRequest finalRequest = (PutJobTaggingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutJobTaggingResult>(){

            @Override
            public PutJobTaggingResult call() throws Exception {
                PutJobTaggingResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executePutJobTagging(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutPublicAccessBlockResult> putPublicAccessBlockAsync(PutPublicAccessBlockRequest request) {
        return this.putPublicAccessBlockAsync(request, null);
    }

    @Override
    public Future<PutPublicAccessBlockResult> putPublicAccessBlockAsync(PutPublicAccessBlockRequest request, final AsyncHandler<PutPublicAccessBlockRequest, PutPublicAccessBlockResult> asyncHandler) {
        final PutPublicAccessBlockRequest finalRequest = (PutPublicAccessBlockRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutPublicAccessBlockResult>(){

            @Override
            public PutPublicAccessBlockResult call() throws Exception {
                PutPublicAccessBlockResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executePutPublicAccessBlock(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateJobPriorityResult> updateJobPriorityAsync(UpdateJobPriorityRequest request) {
        return this.updateJobPriorityAsync(request, null);
    }

    @Override
    public Future<UpdateJobPriorityResult> updateJobPriorityAsync(UpdateJobPriorityRequest request, final AsyncHandler<UpdateJobPriorityRequest, UpdateJobPriorityResult> asyncHandler) {
        final UpdateJobPriorityRequest finalRequest = (UpdateJobPriorityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateJobPriorityResult>(){

            @Override
            public UpdateJobPriorityResult call() throws Exception {
                UpdateJobPriorityResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeUpdateJobPriority(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateJobStatusResult> updateJobStatusAsync(UpdateJobStatusRequest request) {
        return this.updateJobStatusAsync(request, null);
    }

    @Override
    public Future<UpdateJobStatusResult> updateJobStatusAsync(UpdateJobStatusRequest request, final AsyncHandler<UpdateJobStatusRequest, UpdateJobStatusResult> asyncHandler) {
        final UpdateJobStatusRequest finalRequest = (UpdateJobStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateJobStatusResult>(){

            @Override
            public UpdateJobStatusResult call() throws Exception {
                UpdateJobStatusResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeUpdateJobStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

