/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3control.model.JobStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListJobsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String accountId;
    private List<String> jobStatuses;
    private String nextToken;
    private Integer maxResults;

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public ListJobsRequest withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public List<String> getJobStatuses() {
        return this.jobStatuses;
    }

    public void setJobStatuses(Collection<String> jobStatuses) {
        if (jobStatuses == null) {
            this.jobStatuses = null;
            return;
        }
        this.jobStatuses = new ArrayList<String>(jobStatuses);
    }

    public ListJobsRequest withJobStatuses(String ... jobStatuses) {
        if (this.jobStatuses == null) {
            this.setJobStatuses(new ArrayList<String>(jobStatuses.length));
        }
        for (String ele : jobStatuses) {
            this.jobStatuses.add(ele);
        }
        return this;
    }

    public ListJobsRequest withJobStatuses(Collection<String> jobStatuses) {
        this.setJobStatuses(jobStatuses);
        return this;
    }

    public ListJobsRequest withJobStatuses(JobStatus ... jobStatuses) {
        ArrayList<String> jobStatusesCopy = new ArrayList<String>(jobStatuses.length);
        for (JobStatus value : jobStatuses) {
            jobStatusesCopy.add(value.toString());
        }
        if (this.getJobStatuses() == null) {
            this.setJobStatuses(jobStatusesCopy);
        } else {
            this.getJobStatuses().addAll(jobStatusesCopy);
        }
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListJobsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListJobsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getJobStatuses() != null) {
            sb.append("JobStatuses: ").append(this.getJobStatuses()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsRequest)) {
            return false;
        }
        ListJobsRequest other = (ListJobsRequest)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getJobStatuses() == null ^ this.getJobStatuses() == null) {
            return false;
        }
        if (other.getJobStatuses() != null && !other.getJobStatuses().equals(this.getJobStatuses())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getJobStatuses() == null ? 0 : this.getJobStatuses().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    public ListJobsRequest clone() {
        return (ListJobsRequest)super.clone();
    }
}

