/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.services.s3.UploadObjectObserver;
import com.amazonaws.services.s3.internal.MultiFileOutputStream;
import com.amazonaws.services.s3.model.AbstractPutObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import java.io.File;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;

public class UploadObjectRequest
extends AbstractPutObjectRequest {
    static final int MIN_PART_SIZE = 0x500000;
    private long partSize = 0x500000L;
    private ExecutorService executorService;
    private MultiFileOutputStream multiFileOutputStream;
    private UploadObjectObserver uploadObjectObserver;
    private long diskLimit = Long.MAX_VALUE;

    public UploadObjectRequest(String bucketName, String key, File file) {
        super(bucketName, key, file);
    }

    public UploadObjectRequest(String bucketName, String key, InputStream input, ObjectMetadata metadata) {
        super(bucketName, key, input, metadata);
    }

    @Override
    public UploadObjectRequest clone() {
        ObjectMetadata metadata = this.getMetadata();
        UploadObjectRequest cloned = (UploadObjectRequest)((AbstractPutObjectRequest)((AbstractPutObjectRequest)((AbstractPutObjectRequest)((AbstractPutObjectRequest)((AbstractPutObjectRequest)new UploadObjectRequest(this.getBucketName(), this.getKey(), this.getFile()).withPartSize(this.getPartSize()).withExecutorService(this.getExecutorService()).withAccessControlList(this.getAccessControlList())).withCannedAcl(this.getCannedAcl())).withInputStream(this.getInputStream())).withMetadata(metadata == null ? null : metadata.clone())).withStorageClass(this.getStorageClass())).withSSECustomerKey(this.getSSECustomerKey());
        return (UploadObjectRequest)this.copyBaseTo(cloned);
    }

    public long getPartSize() {
        return this.partSize;
    }

    public UploadObjectRequest withPartSize(long partSize) {
        if (partSize < 0x500000L) {
            throw new IllegalArgumentException("partSize must be at least 5242880");
        }
        this.partSize = partSize;
        return this;
    }

    public long getDiskLimit() {
        return this.diskLimit;
    }

    public UploadObjectRequest withDiskLimit(long diskLimit) {
        this.diskLimit = diskLimit;
        return this;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public UploadObjectRequest withExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public MultiFileOutputStream getMultiFileOutputStream() {
        return this.multiFileOutputStream;
    }

    public UploadObjectRequest withMultiFileOutputStream(MultiFileOutputStream multiFileOutputStream) {
        this.multiFileOutputStream = multiFileOutputStream;
        return this;
    }

    public UploadObjectObserver getUploadObjectObserver() {
        return this.uploadObjectObserver;
    }

    public UploadObjectRequest withUploadObjectObserver(UploadObjectObserver uploadObjectObserver) {
        this.uploadObjectObserver = uploadObjectObserver;
        return this;
    }
}

