/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.arn.Arn;
import com.amazonaws.arn.ArnConverter;
import com.amazonaws.services.s3.S3AccessPointResource;
import com.amazonaws.services.s3.S3BucketResource;
import com.amazonaws.services.s3.S3ObjectResource;
import com.amazonaws.services.s3.S3Resource;
import com.amazonaws.services.s3.S3ResourceType;

@SdkInternalApi
public class S3ArnConverter
implements ArnConverter<S3Resource> {
    private static final S3ArnConverter INSTANCE = new S3ArnConverter();

    private S3ArnConverter() {
    }

    public static S3ArnConverter getInstance() {
        return INSTANCE;
    }

    public S3Resource convertArn(Arn arn) {
        S3ResourceType s3ResourceType;
        Arn v2Arn = this.convertToV2Arn(arn);
        try {
            s3ResourceType = S3ResourceType.fromValue(v2Arn.getResource().getResourceType());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown ARN type '" + v2Arn.getResource().getResourceType() + "'");
        }
        switch (s3ResourceType) {
            case OBJECT: {
                return this.parseS3ObjectArn(v2Arn);
            }
            case ACCESS_POINT: {
                return this.parseS3AccessPointArn(v2Arn);
            }
            case BUCKET: {
                return this.parseS3BucketArn(v2Arn);
            }
        }
        throw new IllegalArgumentException("Unknown ARN type '" + v2Arn.getResource().getResourceType() + "'");
    }

    private Arn convertToV2Arn(Arn arn) {
        if (!this.isV1Arn(arn)) {
            return arn;
        }
        String resource = arn.getResourceAsString();
        if (resource.contains("/")) {
            return arn.toBuilder().withResource("object:" + arn.getResourceAsString()).build();
        }
        return arn.toBuilder().withResource("bucket_name:" + arn.getResourceAsString()).build();
    }

    private S3BucketResource parseS3BucketArn(Arn arn) {
        return S3BucketResource.builder().withPartition(arn.getPartition()).withRegion(arn.getRegion()).withAccountId(arn.getAccountId()).withBucketName(arn.getResource().getResource()).build();
    }

    private S3AccessPointResource parseS3AccessPointArn(Arn arn) {
        return S3AccessPointResource.builder().withPartition(arn.getPartition()).withRegion(arn.getRegion()).withAccountId(arn.getAccountId()).withAccessPointName(arn.getResource().getResource()).build();
    }

    private S3ObjectResource parseS3ObjectArn(Arn arn) {
        String resourceString = arn.getResource().getResource();
        String[] splitResourceString = resourceString.split("/");
        if (splitResourceString.length < 2) {
            throw new IllegalArgumentException("Invalid format for S3 object resource ARN");
        }
        String bucketName = splitResourceString[0];
        String key = splitResourceString[1];
        return S3ObjectResource.builder().withPartition(arn.getPartition()).withRegion(arn.getRegion()).withAccountId(arn.getAccountId()).withBucketName(bucketName).withKey(key).build();
    }

    private boolean isV1Arn(Arn arn) {
        return arn.getAccountId() == null && arn.getRegion() == null;
    }
}

