/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DelegationSet
implements Serializable {
    private String id;
    private String callerReference;
    private ListWithAutoConstructFlag<String> nameServers;

    public DelegationSet() {
    }

    public DelegationSet(List<String> nameServers) {
        this.setNameServers(nameServers);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DelegationSet withId(String id) {
        this.id = id;
        return this;
    }

    public String getCallerReference() {
        return this.callerReference;
    }

    public void setCallerReference(String callerReference) {
        this.callerReference = callerReference;
    }

    public DelegationSet withCallerReference(String callerReference) {
        this.callerReference = callerReference;
        return this;
    }

    public List<String> getNameServers() {
        if (this.nameServers == null) {
            this.nameServers = new ListWithAutoConstructFlag();
            this.nameServers.setAutoConstruct(true);
        }
        return this.nameServers;
    }

    public void setNameServers(Collection<String> nameServers) {
        if (nameServers == null) {
            this.nameServers = null;
            return;
        }
        ListWithAutoConstructFlag nameServersCopy = new ListWithAutoConstructFlag(nameServers.size());
        nameServersCopy.addAll(nameServers);
        this.nameServers = nameServersCopy;
    }

    public DelegationSet withNameServers(String ... nameServers) {
        if (this.getNameServers() == null) {
            this.setNameServers(new ArrayList<String>(nameServers.length));
        }
        for (String value : nameServers) {
            this.getNameServers().add(value);
        }
        return this;
    }

    public DelegationSet withNameServers(Collection<String> nameServers) {
        if (nameServers == null) {
            this.nameServers = null;
        } else {
            ListWithAutoConstructFlag nameServersCopy = new ListWithAutoConstructFlag(nameServers.size());
            nameServersCopy.addAll(nameServers);
            this.nameServers = nameServersCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: " + this.getId() + ",");
        }
        if (this.getCallerReference() != null) {
            sb.append("CallerReference: " + this.getCallerReference() + ",");
        }
        if (this.getNameServers() != null) {
            sb.append("NameServers: " + this.getNameServers());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getCallerReference() == null ? 0 : this.getCallerReference().hashCode());
        hashCode = 31 * hashCode + (this.getNameServers() == null ? 0 : this.getNameServers().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DelegationSet)) {
            return false;
        }
        DelegationSet other = (DelegationSet)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getCallerReference() == null ^ this.getCallerReference() == null) {
            return false;
        }
        if (other.getCallerReference() != null && !other.getCallerReference().equals(this.getCallerReference())) {
            return false;
        }
        if (other.getNameServers() == null ^ this.getNameServers() == null) {
            return false;
        }
        return other.getNameServers() == null || other.getNameServers().equals(this.getNameServers());
    }
}

