/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model.transform;

import com.amazonaws.services.robomaker.model.DataSource;
import com.amazonaws.services.robomaker.model.transform.S3KeyOutputJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class DataSourceJsonUnmarshaller
implements Unmarshaller<DataSource, JsonUnmarshallerContext> {
    private static DataSourceJsonUnmarshaller instance;

    public DataSource unmarshall(JsonUnmarshallerContext context) throws Exception {
        DataSource dataSource = new DataSource();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    dataSource.setName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("s3Bucket", targetDepth)) {
                    context.nextToken();
                    dataSource.setS3Bucket((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("s3Keys", targetDepth)) {
                    context.nextToken();
                    dataSource.setS3Keys(new ListUnmarshaller((Unmarshaller)S3KeyOutputJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("type", targetDepth)) {
                    context.nextToken();
                    dataSource.setType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("destination", targetDepth)) {
                    context.nextToken();
                    dataSource.setDestination((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return dataSource;
    }

    public static DataSourceJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DataSourceJsonUnmarshaller();
        }
        return instance;
    }
}

