/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.robomaker.model.OutputLocation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateWorldExportJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientRequestToken;
    private List<String> worlds;
    private OutputLocation outputLocation;
    private String iamRole;
    private Map<String, String> tags;

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public CreateWorldExportJobRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public List<String> getWorlds() {
        return this.worlds;
    }

    public void setWorlds(Collection<String> worlds) {
        if (worlds == null) {
            this.worlds = null;
            return;
        }
        this.worlds = new ArrayList<String>(worlds);
    }

    public CreateWorldExportJobRequest withWorlds(String ... worlds) {
        if (this.worlds == null) {
            this.setWorlds(new ArrayList<String>(worlds.length));
        }
        for (String ele : worlds) {
            this.worlds.add(ele);
        }
        return this;
    }

    public CreateWorldExportJobRequest withWorlds(Collection<String> worlds) {
        this.setWorlds(worlds);
        return this;
    }

    public void setOutputLocation(OutputLocation outputLocation) {
        this.outputLocation = outputLocation;
    }

    public OutputLocation getOutputLocation() {
        return this.outputLocation;
    }

    public CreateWorldExportJobRequest withOutputLocation(OutputLocation outputLocation) {
        this.setOutputLocation(outputLocation);
        return this;
    }

    public void setIamRole(String iamRole) {
        this.iamRole = iamRole;
    }

    public String getIamRole() {
        return this.iamRole;
    }

    public CreateWorldExportJobRequest withIamRole(String iamRole) {
        this.setIamRole(iamRole);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateWorldExportJobRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateWorldExportJobRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateWorldExportJobRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getWorlds() != null) {
            sb.append("Worlds: ").append(this.getWorlds()).append(",");
        }
        if (this.getOutputLocation() != null) {
            sb.append("OutputLocation: ").append(this.getOutputLocation()).append(",");
        }
        if (this.getIamRole() != null) {
            sb.append("IamRole: ").append(this.getIamRole()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorldExportJobRequest)) {
            return false;
        }
        CreateWorldExportJobRequest other = (CreateWorldExportJobRequest)obj;
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getWorlds() == null ^ this.getWorlds() == null) {
            return false;
        }
        if (other.getWorlds() != null && !other.getWorlds().equals(this.getWorlds())) {
            return false;
        }
        if (other.getOutputLocation() == null ^ this.getOutputLocation() == null) {
            return false;
        }
        if (other.getOutputLocation() != null && !other.getOutputLocation().equals(this.getOutputLocation())) {
            return false;
        }
        if (other.getIamRole() == null ^ this.getIamRole() == null) {
            return false;
        }
        if (other.getIamRole() != null && !other.getIamRole().equals(this.getIamRole())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getWorlds() == null ? 0 : this.getWorlds().hashCode());
        hashCode = 31 * hashCode + (this.getOutputLocation() == null ? 0 : this.getOutputLocation().hashCode());
        hashCode = 31 * hashCode + (this.getIamRole() == null ? 0 : this.getIamRole().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateWorldExportJobRequest clone() {
        return (CreateWorldExportJobRequest)super.clone();
    }
}

