/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.robomaker.model.PortForwardingConfig;
import com.amazonaws.services.robomaker.model.transform.LaunchConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LaunchConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String packageName;
    private String launchFile;
    private Map<String, String> environmentVariables;
    private PortForwardingConfig portForwardingConfig;
    private Boolean streamUI;
    private List<String> command;

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public LaunchConfig withPackageName(String packageName) {
        this.setPackageName(packageName);
        return this;
    }

    public void setLaunchFile(String launchFile) {
        this.launchFile = launchFile;
    }

    public String getLaunchFile() {
        return this.launchFile;
    }

    public LaunchConfig withLaunchFile(String launchFile) {
        this.setLaunchFile(launchFile);
        return this;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public LaunchConfig withEnvironmentVariables(Map<String, String> environmentVariables) {
        this.setEnvironmentVariables(environmentVariables);
        return this;
    }

    public LaunchConfig addEnvironmentVariablesEntry(String key, String value) {
        if (null == this.environmentVariables) {
            this.environmentVariables = new HashMap<String, String>();
        }
        if (this.environmentVariables.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.environmentVariables.put(key, value);
        return this;
    }

    public LaunchConfig clearEnvironmentVariablesEntries() {
        this.environmentVariables = null;
        return this;
    }

    public void setPortForwardingConfig(PortForwardingConfig portForwardingConfig) {
        this.portForwardingConfig = portForwardingConfig;
    }

    public PortForwardingConfig getPortForwardingConfig() {
        return this.portForwardingConfig;
    }

    public LaunchConfig withPortForwardingConfig(PortForwardingConfig portForwardingConfig) {
        this.setPortForwardingConfig(portForwardingConfig);
        return this;
    }

    public void setStreamUI(Boolean streamUI) {
        this.streamUI = streamUI;
    }

    public Boolean getStreamUI() {
        return this.streamUI;
    }

    public LaunchConfig withStreamUI(Boolean streamUI) {
        this.setStreamUI(streamUI);
        return this;
    }

    public Boolean isStreamUI() {
        return this.streamUI;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public void setCommand(Collection<String> command) {
        if (command == null) {
            this.command = null;
            return;
        }
        this.command = new ArrayList<String>(command);
    }

    public LaunchConfig withCommand(String ... command) {
        if (this.command == null) {
            this.setCommand(new ArrayList<String>(command.length));
        }
        for (String ele : command) {
            this.command.add(ele);
        }
        return this;
    }

    public LaunchConfig withCommand(Collection<String> command) {
        this.setCommand(command);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPackageName() != null) {
            sb.append("PackageName: ").append(this.getPackageName()).append(",");
        }
        if (this.getLaunchFile() != null) {
            sb.append("LaunchFile: ").append(this.getLaunchFile()).append(",");
        }
        if (this.getEnvironmentVariables() != null) {
            sb.append("EnvironmentVariables: ").append(this.getEnvironmentVariables()).append(",");
        }
        if (this.getPortForwardingConfig() != null) {
            sb.append("PortForwardingConfig: ").append(this.getPortForwardingConfig()).append(",");
        }
        if (this.getStreamUI() != null) {
            sb.append("StreamUI: ").append(this.getStreamUI()).append(",");
        }
        if (this.getCommand() != null) {
            sb.append("Command: ").append(this.getCommand());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchConfig)) {
            return false;
        }
        LaunchConfig other = (LaunchConfig)obj;
        if (other.getPackageName() == null ^ this.getPackageName() == null) {
            return false;
        }
        if (other.getPackageName() != null && !other.getPackageName().equals(this.getPackageName())) {
            return false;
        }
        if (other.getLaunchFile() == null ^ this.getLaunchFile() == null) {
            return false;
        }
        if (other.getLaunchFile() != null && !other.getLaunchFile().equals(this.getLaunchFile())) {
            return false;
        }
        if (other.getEnvironmentVariables() == null ^ this.getEnvironmentVariables() == null) {
            return false;
        }
        if (other.getEnvironmentVariables() != null && !other.getEnvironmentVariables().equals(this.getEnvironmentVariables())) {
            return false;
        }
        if (other.getPortForwardingConfig() == null ^ this.getPortForwardingConfig() == null) {
            return false;
        }
        if (other.getPortForwardingConfig() != null && !other.getPortForwardingConfig().equals(this.getPortForwardingConfig())) {
            return false;
        }
        if (other.getStreamUI() == null ^ this.getStreamUI() == null) {
            return false;
        }
        if (other.getStreamUI() != null && !other.getStreamUI().equals(this.getStreamUI())) {
            return false;
        }
        if (other.getCommand() == null ^ this.getCommand() == null) {
            return false;
        }
        return other.getCommand() == null || other.getCommand().equals(this.getCommand());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPackageName() == null ? 0 : this.getPackageName().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchFile() == null ? 0 : this.getLaunchFile().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentVariables() == null ? 0 : this.getEnvironmentVariables().hashCode());
        hashCode = 31 * hashCode + (this.getPortForwardingConfig() == null ? 0 : this.getPortForwardingConfig().hashCode());
        hashCode = 31 * hashCode + (this.getStreamUI() == null ? 0 : this.getStreamUI().hashCode());
        hashCode = 31 * hashCode + (this.getCommand() == null ? 0 : this.getCommand().hashCode());
        return hashCode;
    }

    public LaunchConfig clone() {
        try {
            return (LaunchConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LaunchConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

