/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.robomaker.model.RenderingEngine;
import com.amazonaws.services.robomaker.model.RobotSoftwareSuite;
import com.amazonaws.services.robomaker.model.SimulationSoftwareSuite;
import com.amazonaws.services.robomaker.model.SourceConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateSimulationApplicationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String application;
    private List<SourceConfig> sources;
    private SimulationSoftwareSuite simulationSoftwareSuite;
    private RobotSoftwareSuite robotSoftwareSuite;
    private RenderingEngine renderingEngine;
    private String currentRevisionId;

    public void setApplication(String application) {
        this.application = application;
    }

    public String getApplication() {
        return this.application;
    }

    public UpdateSimulationApplicationRequest withApplication(String application) {
        this.setApplication(application);
        return this;
    }

    public List<SourceConfig> getSources() {
        return this.sources;
    }

    public void setSources(Collection<SourceConfig> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new ArrayList<SourceConfig>(sources);
    }

    public UpdateSimulationApplicationRequest withSources(SourceConfig ... sources) {
        if (this.sources == null) {
            this.setSources(new ArrayList<SourceConfig>(sources.length));
        }
        for (SourceConfig ele : sources) {
            this.sources.add(ele);
        }
        return this;
    }

    public UpdateSimulationApplicationRequest withSources(Collection<SourceConfig> sources) {
        this.setSources(sources);
        return this;
    }

    public void setSimulationSoftwareSuite(SimulationSoftwareSuite simulationSoftwareSuite) {
        this.simulationSoftwareSuite = simulationSoftwareSuite;
    }

    public SimulationSoftwareSuite getSimulationSoftwareSuite() {
        return this.simulationSoftwareSuite;
    }

    public UpdateSimulationApplicationRequest withSimulationSoftwareSuite(SimulationSoftwareSuite simulationSoftwareSuite) {
        this.setSimulationSoftwareSuite(simulationSoftwareSuite);
        return this;
    }

    public void setRobotSoftwareSuite(RobotSoftwareSuite robotSoftwareSuite) {
        this.robotSoftwareSuite = robotSoftwareSuite;
    }

    public RobotSoftwareSuite getRobotSoftwareSuite() {
        return this.robotSoftwareSuite;
    }

    public UpdateSimulationApplicationRequest withRobotSoftwareSuite(RobotSoftwareSuite robotSoftwareSuite) {
        this.setRobotSoftwareSuite(robotSoftwareSuite);
        return this;
    }

    public void setRenderingEngine(RenderingEngine renderingEngine) {
        this.renderingEngine = renderingEngine;
    }

    public RenderingEngine getRenderingEngine() {
        return this.renderingEngine;
    }

    public UpdateSimulationApplicationRequest withRenderingEngine(RenderingEngine renderingEngine) {
        this.setRenderingEngine(renderingEngine);
        return this;
    }

    public void setCurrentRevisionId(String currentRevisionId) {
        this.currentRevisionId = currentRevisionId;
    }

    public String getCurrentRevisionId() {
        return this.currentRevisionId;
    }

    public UpdateSimulationApplicationRequest withCurrentRevisionId(String currentRevisionId) {
        this.setCurrentRevisionId(currentRevisionId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplication() != null) {
            sb.append("Application: ").append(this.getApplication()).append(",");
        }
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources()).append(",");
        }
        if (this.getSimulationSoftwareSuite() != null) {
            sb.append("SimulationSoftwareSuite: ").append(this.getSimulationSoftwareSuite()).append(",");
        }
        if (this.getRobotSoftwareSuite() != null) {
            sb.append("RobotSoftwareSuite: ").append(this.getRobotSoftwareSuite()).append(",");
        }
        if (this.getRenderingEngine() != null) {
            sb.append("RenderingEngine: ").append(this.getRenderingEngine()).append(",");
        }
        if (this.getCurrentRevisionId() != null) {
            sb.append("CurrentRevisionId: ").append(this.getCurrentRevisionId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSimulationApplicationRequest)) {
            return false;
        }
        UpdateSimulationApplicationRequest other = (UpdateSimulationApplicationRequest)obj;
        if (other.getApplication() == null ^ this.getApplication() == null) {
            return false;
        }
        if (other.getApplication() != null && !other.getApplication().equals(this.getApplication())) {
            return false;
        }
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        if (other.getSources() != null && !other.getSources().equals(this.getSources())) {
            return false;
        }
        if (other.getSimulationSoftwareSuite() == null ^ this.getSimulationSoftwareSuite() == null) {
            return false;
        }
        if (other.getSimulationSoftwareSuite() != null && !other.getSimulationSoftwareSuite().equals(this.getSimulationSoftwareSuite())) {
            return false;
        }
        if (other.getRobotSoftwareSuite() == null ^ this.getRobotSoftwareSuite() == null) {
            return false;
        }
        if (other.getRobotSoftwareSuite() != null && !other.getRobotSoftwareSuite().equals(this.getRobotSoftwareSuite())) {
            return false;
        }
        if (other.getRenderingEngine() == null ^ this.getRenderingEngine() == null) {
            return false;
        }
        if (other.getRenderingEngine() != null && !other.getRenderingEngine().equals(this.getRenderingEngine())) {
            return false;
        }
        if (other.getCurrentRevisionId() == null ^ this.getCurrentRevisionId() == null) {
            return false;
        }
        return other.getCurrentRevisionId() == null || other.getCurrentRevisionId().equals(this.getCurrentRevisionId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplication() == null ? 0 : this.getApplication().hashCode());
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        hashCode = 31 * hashCode + (this.getSimulationSoftwareSuite() == null ? 0 : this.getSimulationSoftwareSuite().hashCode());
        hashCode = 31 * hashCode + (this.getRobotSoftwareSuite() == null ? 0 : this.getRobotSoftwareSuite().hashCode());
        hashCode = 31 * hashCode + (this.getRenderingEngine() == null ? 0 : this.getRenderingEngine().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentRevisionId() == null ? 0 : this.getCurrentRevisionId().hashCode());
        return hashCode;
    }

    public UpdateSimulationApplicationRequest clone() {
        return (UpdateSimulationApplicationRequest)super.clone();
    }
}

