/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.robomaker.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Information about a simulation job.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/SimulationJob" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SimulationJob implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the simulation job.
     * </p>
     */
    private String arn;
    /**
     * <p>
     * The name of the simulation job.
     * </p>
     */
    private String name;
    /**
     * <p>
     * Status of the simulation job.
     * </p>
     */
    private String status;
    /**
     * <p>
     * The time, in milliseconds since the epoch, when the simulation job was last started.
     * </p>
     */
    private java.util.Date lastStartedAt;
    /**
     * <p>
     * The time, in milliseconds since the epoch, when the simulation job was last updated.
     * </p>
     */
    private java.util.Date lastUpdatedAt;
    /**
     * <p>
     * The failure behavior the simulation job.
     * </p>
     * <dl>
     * <dt>Continue</dt>
     * <dd>
     * <p>
     * Restart the simulation job in the same host instance.
     * </p>
     * </dd>
     * <dt>Fail</dt>
     * <dd>
     * <p>
     * Stop the simulation job and terminate the instance.
     * </p>
     * </dd>
     * </dl>
     */
    private String failureBehavior;
    /**
     * <p>
     * The failure code of the simulation job if it failed.
     * </p>
     */
    private String failureCode;
    /**
     * <p>
     * The reason why the simulation job failed.
     * </p>
     */
    private String failureReason;
    /**
     * <p>
     * A unique identifier for this <code>SimulationJob</code> request.
     * </p>
     */
    private String clientRequestToken;
    /**
     * <p>
     * Location for output files generated by the simulation job.
     * </p>
     */
    private OutputLocation outputLocation;
    /**
     * <p>
     * The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.
     * </p>
     */
    private Long maxJobDurationInSeconds;
    /**
     * <p>
     * The simulation job execution duration in milliseconds.
     * </p>
     */
    private Long simulationTimeMillis;
    /**
     * <p>
     * The IAM role that allows the simulation instance to call the AWS APIs that are specified in its associated
     * policies on your behalf. This is how credentials are passed in to your simulation job.
     * </p>
     */
    private String iamRole;
    /**
     * <p>
     * A list of robot applications.
     * </p>
     */
    private java.util.List<RobotApplicationConfig> robotApplications;
    /**
     * <p>
     * A list of simulation applications.
     * </p>
     */
    private java.util.List<SimulationApplicationConfig> simulationApplications;
    /**
     * <p>
     * A map that contains tag keys and tag values that are attached to the simulation job.
     * </p>
     */
    private java.util.Map<String, String> tags;
    /**
     * <p>
     * VPC configuration information.
     * </p>
     */
    private VPCConfigResponse vpcConfig;

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the simulation job.
     * </p>
     * 
     * @param arn
     *        The Amazon Resource Name (ARN) of the simulation job.
     */

    public void setArn(String arn) {
        this.arn = arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the simulation job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the simulation job.
     */

    public String getArn() {
        return this.arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the simulation job.
     * </p>
     * 
     * @param arn
     *        The Amazon Resource Name (ARN) of the simulation job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SimulationJob withArn(String arn) {
        setArn(arn);
        return this;
    }

    /**
     * <p>
     * The name of the simulation job.
     * </p>
     * 
     * @param name
     *        The name of the simulation job.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the simulation job.
     * </p>
     * 
     * @return The name of the simulation job.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the simulation job.
     * </p>
     * 
     * @param name
     *        The name of the simulation job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SimulationJob withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * Status of the simulation job.
     * </p>
     * 
     * @param status
     *        Status of the simulation job.
     * @see SimulationJobStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * Status of the simulation job.
     * </p>
     * 
     * @return Status of the simulation job.
     * @see SimulationJobStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * Status of the simulation job.
     * </p>
     * 
     * @param status
     *        Status of the simulation job.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SimulationJobStatus
     */

    public SimulationJob withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * Status of the simulation job.
     * </p>
     * 
     * @param status
     *        Status of the simulation job.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SimulationJobStatus
     */

    public SimulationJob withStatus(SimulationJobStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the simulation job was last started.
     * </p>
     * 
     * @param lastStartedAt
     *        The time, in milliseconds since the epoch, when the simulation job was last started.
     */

    public void setLastStartedAt(java.util.Date lastStartedAt) {
        this.lastStartedAt = lastStartedAt;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the simulation job was last started.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the simulation job was last started.
     */

    public java.util.Date getLastStartedAt() {
        return this.lastStartedAt;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the simulation job was last started.
     * </p>
     * 
     * @param lastStartedAt
     *        The time, in milliseconds since the epoch, when the simulation job was last started.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SimulationJob withLastStartedAt(java.util.Date lastStartedAt) {
        setLastStartedAt(lastStartedAt);
        return this;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the simulation job was last updated.
     * </p>
     * 
     * @param lastUpdatedAt
     *        The time, in milliseconds since the epoch, when the simulation job was last updated.
     */

    public void setLastUpdatedAt(java.util.Date lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the simulation job was last updated.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the simulation job was last updated.
     */

    public java.util.Date getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the simulation job was last updated.
     * </p>
     * 
     * @param lastUpdatedAt
     *        The time, in milliseconds since the epoch, when the simulation job was last updated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SimulationJob withLastUpdatedAt(java.util.Date lastUpdatedAt) {
        setLastUpdatedAt(lastUpdatedAt);
        return this;
    }

    /**
     * <p>
     * The failure behavior the simulation job.
     * </p>
     * <dl>
     * <dt>Continue</dt>
     * <dd>
     * <p>
     * Restart the simulation job in the same host instance.
     * </p>
     * </dd>
     * <dt>Fail</dt>
     * <dd>
     * <p>
     * Stop the simulation job and terminate the instance.
     * </p>
     * </dd>
     * </dl>
     * 
     * @param failureBehavior
     *        The failure behavior the simulation job.</p>
     *        <dl>
     *        <dt>Continue</dt>
     *        <dd>
     *        <p>
     *        Restart the simulation job in the same host instance.
     *        </p>
     *        </dd>
     *        <dt>Fail</dt>
     *        <dd>
     *        <p>
     *        Stop the simulation job and terminate the instance.
     *        </p>
     *        </dd>
     * @see FailureBehavior
     */

    public void setFailureBehavior(String failureBehavior) {
        this.failureBehavior = failureBehavior;
    }

    /**
     * <p>
     * The failure behavior the simulation job.
     * </p>
     * <dl>
     * <dt>Continue</dt>
     * <dd>
     * <p>
     * Restart the simulation job in the same host instance.
     * </p>
     * </dd>
     * <dt>Fail</dt>
     * <dd>
     * <p>
     * Stop the simulation job and terminate the instance.
     * </p>
     * </dd>
     * </dl>
     * 
     * @return The failure behavior the simulation job.</p>
     *         <dl>
     *         <dt>Continue</dt>
     *         <dd>
     *         <p>
     *         Restart the simulation job in the same host instance.
     *         </p>
     *         </dd>
     *         <dt>Fail</dt>
     *         <dd>
     *         <p>
     *         Stop the simulation job and terminate the instance.
     *         </p>
     *         </dd>
     * @see FailureBehavior
     */

    public String getFailureBehavior() {
        return this.failureBehavior;
    }

    /**
     * <p>
     * The failure behavior the simulation job.
     * </p>
     * <dl>
     * <dt>Continue</dt>
     * <dd>
     * <p>
     * Restart the simulation job in the same host instance.
     * </p>
     * </dd>
     * <dt>Fail</dt>
     * <dd>
     * <p>
     * Stop the simulation job and terminate the instance.
     * </p>
     * </dd>
     * </dl>
     * 
     * @param failureBehavior
     *        The failure behavior the simulation job.</p>
     *        <dl>
     *        <dt>Continue</dt>
     *        <dd>
     *        <p>
     *        Restart the simulation job in the same host instance.
     *        </p>
     *        </dd>
     *        <dt>Fail</dt>
     *        <dd>
     *        <p>
     *        Stop the simulation job and terminate the instance.
     *        </p>
     *        </dd>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see FailureBehavior
     */

    public SimulationJob withFailureBehavior(String failureBehavior) {
        setFailureBehavior(failureBehavior);
        return this;
    }

    /**
     * <p>
     * The failure behavior the simulation job.
     * </p>
     * <dl>
     * <dt>Continue</dt>
     * <dd>
     * <p>
     * Restart the simulation job in the same host instance.
     * </p>
     * </dd>
     * <dt>Fail</dt>
     * <dd>
     * <p>
     * Stop the simulation job and terminate the instance.
     * </p>
     * </dd>
     * </dl>
     * 
     * @param failureBehavior
     *        The failure behavior the simulation job.</p>
     *        <dl>
     *        <dt>Continue</dt>
     *        <dd>
     *        <p>
     *        Restart the simulation job in the same host instance.
     *        </p>
     *        </dd>
     *        <dt>Fail</dt>
     *        <dd>
     *        <p>
     *        Stop the simulation job and terminate the instance.
     *        </p>
     *        </dd>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see FailureBehavior
     */

    public SimulationJob withFailureBehavior(FailureBehavior failureBehavior) {
        this.failureBehavior = failureBehavior.toString();
        return this;
    }

    /**
     * <p>
     * The failure code of the simulation job if it failed.
     * </p>
     * 
     * @param failureCode
     *        The failure code of the simulation job if it failed.
     * @see SimulationJobErrorCode
     */

    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    /**
     * <p>
     * The failure code of the simulation job if it failed.
     * </p>
     * 
     * @return The failure code of the simulation job if it failed.
     * @see SimulationJobErrorCode
     */

    public String getFailureCode() {
        return this.failureCode;
    }

    /**
     * <p>
     * The failure code of the simulation job if it failed.
     * </p>
     * 
     * @param failureCode
     *        The failure code of the simulation job if it failed.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SimulationJobErrorCode
     */

    public SimulationJob withFailureCode(String failureCode) {
        setFailureCode(failureCode);
        return this;
    }

    /**
     * <p>
     * The failure code of the simulation job if it failed.
     * </p>
     * 
     * @param failureCode
     *        The failure code of the simulation job if it failed.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SimulationJobErrorCode
     */

    public SimulationJob withFailureCode(SimulationJobErrorCode failureCode) {
        this.failureCode = failureCode.toString();
        return this;
    }

    /**
     * <p>
     * The reason why the simulation job failed.
     * </p>
     * 
     * @param failureReason
     *        The reason why the simulation job failed.
     */

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    /**
     * <p>
     * The reason why the simulation job failed.
     * </p>
     * 
     * @return The reason why the simulation job failed.
     */

    public String getFailureReason() {
        return this.failureReason;
    }

    /**
     * <p>
     * The reason why the simulation job failed.
     * </p>
     * 
     * @param failureReason
     *        The reason why the simulation job failed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SimulationJob withFailureReason(String failureReason) {
        setFailureReason(failureReason);
        return this;
    }

    /**
     * <p>
     * A unique identifier for this <code>SimulationJob</code> request.
     * </p>
     * 
     * @param clientRequestToken
     *        A unique identifier for this <code>SimulationJob</code> request.
     */

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    /**
     * <p>
     * A unique identifier for this <code>SimulationJob</code> request.
     * </p>
     * 
     * @return A unique identifier for this <code>SimulationJob</code> request.
     */

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    /**
     * <p>
     * A unique identifier for this <code>SimulationJob</code> request.
     * </p>
     * 
     * @param clientRequestToken
     *        A unique identifier for this <code>SimulationJob</code> request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SimulationJob withClientRequestToken(String clientRequestToken) {
        setClientRequestToken(clientRequestToken);
        return this;
    }

    /**
     * <p>
     * Location for output files generated by the simulation job.
     * </p>
     * 
     * @param outputLocation
     *        Location for output files generated by the simulation job.
     */

    public void setOutputLocation(OutputLocation outputLocation) {
        this.outputLocation = outputLocation;
    }

    /**
     * <p>
     * Location for output files generated by the simulation job.
     * </p>
     * 
     * @return Location for output files generated by the simulation job.
     */

    public OutputLocation getOutputLocation() {
        return this.outputLocation;
    }

    /**
     * <p>
     * Location for output files generated by the simulation job.
     * </p>
     * 
     * @param outputLocation
     *        Location for output files generated by the simulation job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SimulationJob withOutputLocation(OutputLocation outputLocation) {
        setOutputLocation(outputLocation);
        return this;
    }

    /**
     * <p>
     * The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.
     * </p>
     * 
     * @param maxJobDurationInSeconds
     *        The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.
     */

    public void setMaxJobDurationInSeconds(Long maxJobDurationInSeconds) {
        this.maxJobDurationInSeconds = maxJobDurationInSeconds;
    }

    /**
     * <p>
     * The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.
     * </p>
     * 
     * @return The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.
     */

    public Long getMaxJobDurationInSeconds() {
        return this.maxJobDurationInSeconds;
    }

    /**
     * <p>
     * The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.
     * </p>
     * 
     * @param maxJobDurationInSeconds
     *        The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SimulationJob withMaxJobDurationInSeconds(Long maxJobDurationInSeconds) {
        setMaxJobDurationInSeconds(maxJobDurationInSeconds);
        return this;
    }

    /**
     * <p>
     * The simulation job execution duration in milliseconds.
     * </p>
     * 
     * @param simulationTimeMillis
     *        The simulation job execution duration in milliseconds.
     */

    public void setSimulationTimeMillis(Long simulationTimeMillis) {
        this.simulationTimeMillis = simulationTimeMillis;
    }

    /**
     * <p>
     * The simulation job execution duration in milliseconds.
     * </p>
     * 
     * @return The simulation job execution duration in milliseconds.
     */

    public Long getSimulationTimeMillis() {
        return this.simulationTimeMillis;
    }

    /**
     * <p>
     * The simulation job execution duration in milliseconds.
     * </p>
     * 
     * @param simulationTimeMillis
     *        The simulation job execution duration in milliseconds.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SimulationJob withSimulationTimeMillis(Long simulationTimeMillis) {
        setSimulationTimeMillis(simulationTimeMillis);
        return this;
    }

    /**
     * <p>
     * The IAM role that allows the simulation instance to call the AWS APIs that are specified in its associated
     * policies on your behalf. This is how credentials are passed in to your simulation job.
     * </p>
     * 
     * @param iamRole
     *        The IAM role that allows the simulation instance to call the AWS APIs that are specified in its associated
     *        policies on your behalf. This is how credentials are passed in to your simulation job.
     */

    public void setIamRole(String iamRole) {
        this.iamRole = iamRole;
    }

    /**
     * <p>
     * The IAM role that allows the simulation instance to call the AWS APIs that are specified in its associated
     * policies on your behalf. This is how credentials are passed in to your simulation job.
     * </p>
     * 
     * @return The IAM role that allows the simulation instance to call the AWS APIs that are specified in its
     *         associated policies on your behalf. This is how credentials are passed in to your simulation job.
     */

    public String getIamRole() {
        return this.iamRole;
    }

    /**
     * <p>
     * The IAM role that allows the simulation instance to call the AWS APIs that are specified in its associated
     * policies on your behalf. This is how credentials are passed in to your simulation job.
     * </p>
     * 
     * @param iamRole
     *        The IAM role that allows the simulation instance to call the AWS APIs that are specified in its associated
     *        policies on your behalf. This is how credentials are passed in to your simulation job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SimulationJob withIamRole(String iamRole) {
        setIamRole(iamRole);
        return this;
    }

    /**
     * <p>
     * A list of robot applications.
     * </p>
     * 
     * @return A list of robot applications.
     */

    public java.util.List<RobotApplicationConfig> getRobotApplications() {
        return robotApplications;
    }

    /**
     * <p>
     * A list of robot applications.
     * </p>
     * 
     * @param robotApplications
     *        A list of robot applications.
     */

    public void setRobotApplications(java.util.Collection<RobotApplicationConfig> robotApplications) {
        if (robotApplications == null) {
            this.robotApplications = null;
            return;
        }

        this.robotApplications = new java.util.ArrayList<RobotApplicationConfig>(robotApplications);
    }

    /**
     * <p>
     * A list of robot applications.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setRobotApplications(java.util.Collection)} or {@link #withRobotApplications(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param robotApplications
     *        A list of robot applications.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SimulationJob withRobotApplications(RobotApplicationConfig... robotApplications) {
        if (this.robotApplications == null) {
            setRobotApplications(new java.util.ArrayList<RobotApplicationConfig>(robotApplications.length));
        }
        for (RobotApplicationConfig ele : robotApplications) {
            this.robotApplications.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of robot applications.
     * </p>
     * 
     * @param robotApplications
     *        A list of robot applications.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SimulationJob withRobotApplications(java.util.Collection<RobotApplicationConfig> robotApplications) {
        setRobotApplications(robotApplications);
        return this;
    }

    /**
     * <p>
     * A list of simulation applications.
     * </p>
     * 
     * @return A list of simulation applications.
     */

    public java.util.List<SimulationApplicationConfig> getSimulationApplications() {
        return simulationApplications;
    }

    /**
     * <p>
     * A list of simulation applications.
     * </p>
     * 
     * @param simulationApplications
     *        A list of simulation applications.
     */

    public void setSimulationApplications(java.util.Collection<SimulationApplicationConfig> simulationApplications) {
        if (simulationApplications == null) {
            this.simulationApplications = null;
            return;
        }

        this.simulationApplications = new java.util.ArrayList<SimulationApplicationConfig>(simulationApplications);
    }

    /**
     * <p>
     * A list of simulation applications.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSimulationApplications(java.util.Collection)} or
     * {@link #withSimulationApplications(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param simulationApplications
     *        A list of simulation applications.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SimulationJob withSimulationApplications(SimulationApplicationConfig... simulationApplications) {
        if (this.simulationApplications == null) {
            setSimulationApplications(new java.util.ArrayList<SimulationApplicationConfig>(simulationApplications.length));
        }
        for (SimulationApplicationConfig ele : simulationApplications) {
            this.simulationApplications.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of simulation applications.
     * </p>
     * 
     * @param simulationApplications
     *        A list of simulation applications.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SimulationJob withSimulationApplications(java.util.Collection<SimulationApplicationConfig> simulationApplications) {
        setSimulationApplications(simulationApplications);
        return this;
    }

    /**
     * <p>
     * A map that contains tag keys and tag values that are attached to the simulation job.
     * </p>
     * 
     * @return A map that contains tag keys and tag values that are attached to the simulation job.
     */

    public java.util.Map<String, String> getTags() {
        return tags;
    }

    /**
     * <p>
     * A map that contains tag keys and tag values that are attached to the simulation job.
     * </p>
     * 
     * @param tags
     *        A map that contains tag keys and tag values that are attached to the simulation job.
     */

    public void setTags(java.util.Map<String, String> tags) {
        this.tags = tags;
    }

    /**
     * <p>
     * A map that contains tag keys and tag values that are attached to the simulation job.
     * </p>
     * 
     * @param tags
     *        A map that contains tag keys and tag values that are attached to the simulation job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SimulationJob withTags(java.util.Map<String, String> tags) {
        setTags(tags);
        return this;
    }

    public SimulationJob addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new java.util.HashMap<String, String>();
        }
        if (this.tags.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.tags.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into Tags.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SimulationJob clearTagsEntries() {
        this.tags = null;
        return this;
    }

    /**
     * <p>
     * VPC configuration information.
     * </p>
     * 
     * @param vpcConfig
     *        VPC configuration information.
     */

    public void setVpcConfig(VPCConfigResponse vpcConfig) {
        this.vpcConfig = vpcConfig;
    }

    /**
     * <p>
     * VPC configuration information.
     * </p>
     * 
     * @return VPC configuration information.
     */

    public VPCConfigResponse getVpcConfig() {
        return this.vpcConfig;
    }

    /**
     * <p>
     * VPC configuration information.
     * </p>
     * 
     * @param vpcConfig
     *        VPC configuration information.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SimulationJob withVpcConfig(VPCConfigResponse vpcConfig) {
        setVpcConfig(vpcConfig);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getArn() != null)
            sb.append("Arn: ").append(getArn()).append(",");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getLastStartedAt() != null)
            sb.append("LastStartedAt: ").append(getLastStartedAt()).append(",");
        if (getLastUpdatedAt() != null)
            sb.append("LastUpdatedAt: ").append(getLastUpdatedAt()).append(",");
        if (getFailureBehavior() != null)
            sb.append("FailureBehavior: ").append(getFailureBehavior()).append(",");
        if (getFailureCode() != null)
            sb.append("FailureCode: ").append(getFailureCode()).append(",");
        if (getFailureReason() != null)
            sb.append("FailureReason: ").append(getFailureReason()).append(",");
        if (getClientRequestToken() != null)
            sb.append("ClientRequestToken: ").append(getClientRequestToken()).append(",");
        if (getOutputLocation() != null)
            sb.append("OutputLocation: ").append(getOutputLocation()).append(",");
        if (getMaxJobDurationInSeconds() != null)
            sb.append("MaxJobDurationInSeconds: ").append(getMaxJobDurationInSeconds()).append(",");
        if (getSimulationTimeMillis() != null)
            sb.append("SimulationTimeMillis: ").append(getSimulationTimeMillis()).append(",");
        if (getIamRole() != null)
            sb.append("IamRole: ").append(getIamRole()).append(",");
        if (getRobotApplications() != null)
            sb.append("RobotApplications: ").append(getRobotApplications()).append(",");
        if (getSimulationApplications() != null)
            sb.append("SimulationApplications: ").append(getSimulationApplications()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags()).append(",");
        if (getVpcConfig() != null)
            sb.append("VpcConfig: ").append(getVpcConfig());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof SimulationJob == false)
            return false;
        SimulationJob other = (SimulationJob) obj;
        if (other.getArn() == null ^ this.getArn() == null)
            return false;
        if (other.getArn() != null && other.getArn().equals(this.getArn()) == false)
            return false;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getLastStartedAt() == null ^ this.getLastStartedAt() == null)
            return false;
        if (other.getLastStartedAt() != null && other.getLastStartedAt().equals(this.getLastStartedAt()) == false)
            return false;
        if (other.getLastUpdatedAt() == null ^ this.getLastUpdatedAt() == null)
            return false;
        if (other.getLastUpdatedAt() != null && other.getLastUpdatedAt().equals(this.getLastUpdatedAt()) == false)
            return false;
        if (other.getFailureBehavior() == null ^ this.getFailureBehavior() == null)
            return false;
        if (other.getFailureBehavior() != null && other.getFailureBehavior().equals(this.getFailureBehavior()) == false)
            return false;
        if (other.getFailureCode() == null ^ this.getFailureCode() == null)
            return false;
        if (other.getFailureCode() != null && other.getFailureCode().equals(this.getFailureCode()) == false)
            return false;
        if (other.getFailureReason() == null ^ this.getFailureReason() == null)
            return false;
        if (other.getFailureReason() != null && other.getFailureReason().equals(this.getFailureReason()) == false)
            return false;
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null)
            return false;
        if (other.getClientRequestToken() != null && other.getClientRequestToken().equals(this.getClientRequestToken()) == false)
            return false;
        if (other.getOutputLocation() == null ^ this.getOutputLocation() == null)
            return false;
        if (other.getOutputLocation() != null && other.getOutputLocation().equals(this.getOutputLocation()) == false)
            return false;
        if (other.getMaxJobDurationInSeconds() == null ^ this.getMaxJobDurationInSeconds() == null)
            return false;
        if (other.getMaxJobDurationInSeconds() != null && other.getMaxJobDurationInSeconds().equals(this.getMaxJobDurationInSeconds()) == false)
            return false;
        if (other.getSimulationTimeMillis() == null ^ this.getSimulationTimeMillis() == null)
            return false;
        if (other.getSimulationTimeMillis() != null && other.getSimulationTimeMillis().equals(this.getSimulationTimeMillis()) == false)
            return false;
        if (other.getIamRole() == null ^ this.getIamRole() == null)
            return false;
        if (other.getIamRole() != null && other.getIamRole().equals(this.getIamRole()) == false)
            return false;
        if (other.getRobotApplications() == null ^ this.getRobotApplications() == null)
            return false;
        if (other.getRobotApplications() != null && other.getRobotApplications().equals(this.getRobotApplications()) == false)
            return false;
        if (other.getSimulationApplications() == null ^ this.getSimulationApplications() == null)
            return false;
        if (other.getSimulationApplications() != null && other.getSimulationApplications().equals(this.getSimulationApplications()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        if (other.getVpcConfig() == null ^ this.getVpcConfig() == null)
            return false;
        if (other.getVpcConfig() != null && other.getVpcConfig().equals(this.getVpcConfig()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getArn() == null) ? 0 : getArn().hashCode());
        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getLastStartedAt() == null) ? 0 : getLastStartedAt().hashCode());
        hashCode = prime * hashCode + ((getLastUpdatedAt() == null) ? 0 : getLastUpdatedAt().hashCode());
        hashCode = prime * hashCode + ((getFailureBehavior() == null) ? 0 : getFailureBehavior().hashCode());
        hashCode = prime * hashCode + ((getFailureCode() == null) ? 0 : getFailureCode().hashCode());
        hashCode = prime * hashCode + ((getFailureReason() == null) ? 0 : getFailureReason().hashCode());
        hashCode = prime * hashCode + ((getClientRequestToken() == null) ? 0 : getClientRequestToken().hashCode());
        hashCode = prime * hashCode + ((getOutputLocation() == null) ? 0 : getOutputLocation().hashCode());
        hashCode = prime * hashCode + ((getMaxJobDurationInSeconds() == null) ? 0 : getMaxJobDurationInSeconds().hashCode());
        hashCode = prime * hashCode + ((getSimulationTimeMillis() == null) ? 0 : getSimulationTimeMillis().hashCode());
        hashCode = prime * hashCode + ((getIamRole() == null) ? 0 : getIamRole().hashCode());
        hashCode = prime * hashCode + ((getRobotApplications() == null) ? 0 : getRobotApplications().hashCode());
        hashCode = prime * hashCode + ((getSimulationApplications() == null) ? 0 : getSimulationApplications().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        hashCode = prime * hashCode + ((getVpcConfig() == null) ? 0 : getVpcConfig().hashCode());
        return hashCode;
    }

    @Override
    public SimulationJob clone() {
        try {
            return (SimulationJob) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.robomaker.model.transform.SimulationJobMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
