/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourcegroups.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.resourcegroups.model.Group;
import com.amazonaws.services.resourcegroups.model.GroupIdentifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListGroupsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<GroupIdentifier> groupIdentifiers;
    @Deprecated
    private List<Group> groups;
    private String nextToken;

    public List<GroupIdentifier> getGroupIdentifiers() {
        return this.groupIdentifiers;
    }

    public void setGroupIdentifiers(Collection<GroupIdentifier> groupIdentifiers) {
        if (groupIdentifiers == null) {
            this.groupIdentifiers = null;
            return;
        }
        this.groupIdentifiers = new ArrayList<GroupIdentifier>(groupIdentifiers);
    }

    public ListGroupsResult withGroupIdentifiers(GroupIdentifier ... groupIdentifiers) {
        if (this.groupIdentifiers == null) {
            this.setGroupIdentifiers(new ArrayList<GroupIdentifier>(groupIdentifiers.length));
        }
        for (GroupIdentifier ele : groupIdentifiers) {
            this.groupIdentifiers.add(ele);
        }
        return this;
    }

    public ListGroupsResult withGroupIdentifiers(Collection<GroupIdentifier> groupIdentifiers) {
        this.setGroupIdentifiers(groupIdentifiers);
        return this;
    }

    @Deprecated
    public List<Group> getGroups() {
        return this.groups;
    }

    @Deprecated
    public void setGroups(Collection<Group> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        this.groups = new ArrayList<Group>(groups);
    }

    @Deprecated
    public ListGroupsResult withGroups(Group ... groups) {
        if (this.groups == null) {
            this.setGroups(new ArrayList<Group>(groups.length));
        }
        for (Group ele : groups) {
            this.groups.add(ele);
        }
        return this;
    }

    @Deprecated
    public ListGroupsResult withGroups(Collection<Group> groups) {
        this.setGroups(groups);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListGroupsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroupIdentifiers() != null) {
            sb.append("GroupIdentifiers: ").append(this.getGroupIdentifiers()).append(",");
        }
        if (this.getGroups() != null) {
            sb.append("Groups: ").append(this.getGroups()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupsResult)) {
            return false;
        }
        ListGroupsResult other = (ListGroupsResult)obj;
        if (other.getGroupIdentifiers() == null ^ this.getGroupIdentifiers() == null) {
            return false;
        }
        if (other.getGroupIdentifiers() != null && !other.getGroupIdentifiers().equals(this.getGroupIdentifiers())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroupIdentifiers() == null ? 0 : this.getGroupIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListGroupsResult clone() {
        try {
            return (ListGroupsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

