/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.resiliencehub.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.resiliencehub.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * AppSummary JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AppSummaryJsonUnmarshaller implements Unmarshaller<AppSummary, JsonUnmarshallerContext> {

    public AppSummary unmarshall(JsonUnmarshallerContext context) throws Exception {
        AppSummary appSummary = new AppSummary();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("appArn", targetDepth)) {
                    context.nextToken();
                    appSummary.setAppArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("assessmentSchedule", targetDepth)) {
                    context.nextToken();
                    appSummary.setAssessmentSchedule(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("complianceStatus", targetDepth)) {
                    context.nextToken();
                    appSummary.setComplianceStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("creationTime", targetDepth)) {
                    context.nextToken();
                    appSummary.setCreationTime(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    appSummary.setDescription(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("driftStatus", targetDepth)) {
                    context.nextToken();
                    appSummary.setDriftStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("lastAppComplianceEvaluationTime", targetDepth)) {
                    context.nextToken();
                    appSummary.setLastAppComplianceEvaluationTime(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    appSummary.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("resiliencyScore", targetDepth)) {
                    context.nextToken();
                    appSummary.setResiliencyScore(context.getUnmarshaller(Double.class).unmarshall(context));
                }
                if (context.testExpression("rpoInSecs", targetDepth)) {
                    context.nextToken();
                    appSummary.setRpoInSecs(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("rtoInSecs", targetDepth)) {
                    context.nextToken();
                    appSummary.setRtoInSecs(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    appSummary.setStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return appSummary;
    }

    private static AppSummaryJsonUnmarshaller instance;

    public static AppSummaryJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new AppSummaryJsonUnmarshaller();
        return instance;
    }
}
