/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resiliencehub.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.resiliencehub.model.AppVersionSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListAppVersionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<AppVersionSummary> appVersions;
    private String nextToken;

    public List<AppVersionSummary> getAppVersions() {
        return this.appVersions;
    }

    public void setAppVersions(Collection<AppVersionSummary> appVersions) {
        if (appVersions == null) {
            this.appVersions = null;
            return;
        }
        this.appVersions = new ArrayList<AppVersionSummary>(appVersions);
    }

    public ListAppVersionsResult withAppVersions(AppVersionSummary ... appVersions) {
        if (this.appVersions == null) {
            this.setAppVersions(new ArrayList<AppVersionSummary>(appVersions.length));
        }
        for (AppVersionSummary ele : appVersions) {
            this.appVersions.add(ele);
        }
        return this;
    }

    public ListAppVersionsResult withAppVersions(Collection<AppVersionSummary> appVersions) {
        this.setAppVersions(appVersions);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListAppVersionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAppVersions() != null) {
            sb.append("AppVersions: ").append(this.getAppVersions()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppVersionsResult)) {
            return false;
        }
        ListAppVersionsResult other = (ListAppVersionsResult)obj;
        if (other.getAppVersions() == null ^ this.getAppVersions() == null) {
            return false;
        }
        if (other.getAppVersions() != null && !other.getAppVersions().equals(this.getAppVersions())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAppVersions() == null ? 0 : this.getAppVersions().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListAppVersionsResult clone() {
        try {
            return (ListAppVersionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

