/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.resiliencehub.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeApp" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeAppResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The specified application, returned as an object with details including compliance status, creation time,
     * description, resiliency score, and more.
     * </p>
     */
    private App app;

    /**
     * <p>
     * The specified application, returned as an object with details including compliance status, creation time,
     * description, resiliency score, and more.
     * </p>
     * 
     * @param app
     *        The specified application, returned as an object with details including compliance status, creation time,
     *        description, resiliency score, and more.
     */

    public void setApp(App app) {
        this.app = app;
    }

    /**
     * <p>
     * The specified application, returned as an object with details including compliance status, creation time,
     * description, resiliency score, and more.
     * </p>
     * 
     * @return The specified application, returned as an object with details including compliance status, creation time,
     *         description, resiliency score, and more.
     */

    public App getApp() {
        return this.app;
    }

    /**
     * <p>
     * The specified application, returned as an object with details including compliance status, creation time,
     * description, resiliency score, and more.
     * </p>
     * 
     * @param app
     *        The specified application, returned as an object with details including compliance status, creation time,
     *        description, resiliency score, and more.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeAppResult withApp(App app) {
        setApp(app);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getApp() != null)
            sb.append("App: ").append(getApp());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeAppResult == false)
            return false;
        DescribeAppResult other = (DescribeAppResult) obj;
        if (other.getApp() == null ^ this.getApp() == null)
            return false;
        if (other.getApp() != null && other.getApp().equals(this.getApp()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getApp() == null) ? 0 : getApp().hashCode());
        return hashCode;
    }

    @Override
    public DescribeAppResult clone() {
        try {
            return (DescribeAppResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
