/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.rekognition.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.rekognition.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * ContentModerationDetectionMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class ContentModerationDetectionMarshaller {

    private static final MarshallingInfo<Long> TIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Timestamp").build();
    private static final MarshallingInfo<StructuredPojo> MODERATIONLABEL_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModerationLabel").build();
    private static final MarshallingInfo<Long> STARTTIMESTAMPMILLIS_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTimestampMillis").build();
    private static final MarshallingInfo<Long> ENDTIMESTAMPMILLIS_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTimestampMillis").build();
    private static final MarshallingInfo<Long> DURATIONMILLIS_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DurationMillis").build();
    private static final MarshallingInfo<List> CONTENTTYPES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ContentTypes").build();

    private static final ContentModerationDetectionMarshaller instance = new ContentModerationDetectionMarshaller();

    public static ContentModerationDetectionMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(ContentModerationDetection contentModerationDetection, ProtocolMarshaller protocolMarshaller) {

        if (contentModerationDetection == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(contentModerationDetection.getTimestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall(contentModerationDetection.getModerationLabel(), MODERATIONLABEL_BINDING);
            protocolMarshaller.marshall(contentModerationDetection.getStartTimestampMillis(), STARTTIMESTAMPMILLIS_BINDING);
            protocolMarshaller.marshall(contentModerationDetection.getEndTimestampMillis(), ENDTIMESTAMPMILLIS_BINDING);
            protocolMarshaller.marshall(contentModerationDetection.getDurationMillis(), DURATIONMILLIS_BINDING);
            protocolMarshaller.marshall(contentModerationDetection.getContentTypes(), CONTENTTYPES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
