/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.rekognition.model.GetLabelDetectionRequestMetadata;
import com.amazonaws.services.rekognition.model.LabelDetection;
import com.amazonaws.services.rekognition.model.Video;
import com.amazonaws.services.rekognition.model.VideoJobStatus;
import com.amazonaws.services.rekognition.model.VideoMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetLabelDetectionResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String jobStatus;
    private String statusMessage;
    private VideoMetadata videoMetadata;
    private String nextToken;
    private List<LabelDetection> labels;
    private String labelModelVersion;
    private String jobId;
    private Video video;
    private String jobTag;
    private GetLabelDetectionRequestMetadata getRequestMetadata;

    public void setJobStatus(String jobStatus) {
        this.jobStatus = jobStatus;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public GetLabelDetectionResult withJobStatus(String jobStatus) {
        this.setJobStatus(jobStatus);
        return this;
    }

    public GetLabelDetectionResult withJobStatus(VideoJobStatus jobStatus) {
        this.jobStatus = jobStatus.toString();
        return this;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public GetLabelDetectionResult withStatusMessage(String statusMessage) {
        this.setStatusMessage(statusMessage);
        return this;
    }

    public void setVideoMetadata(VideoMetadata videoMetadata) {
        this.videoMetadata = videoMetadata;
    }

    public VideoMetadata getVideoMetadata() {
        return this.videoMetadata;
    }

    public GetLabelDetectionResult withVideoMetadata(VideoMetadata videoMetadata) {
        this.setVideoMetadata(videoMetadata);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetLabelDetectionResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<LabelDetection> getLabels() {
        return this.labels;
    }

    public void setLabels(Collection<LabelDetection> labels) {
        if (labels == null) {
            this.labels = null;
            return;
        }
        this.labels = new ArrayList<LabelDetection>(labels);
    }

    public GetLabelDetectionResult withLabels(LabelDetection ... labels) {
        if (this.labels == null) {
            this.setLabels(new ArrayList<LabelDetection>(labels.length));
        }
        for (LabelDetection ele : labels) {
            this.labels.add(ele);
        }
        return this;
    }

    public GetLabelDetectionResult withLabels(Collection<LabelDetection> labels) {
        this.setLabels(labels);
        return this;
    }

    public void setLabelModelVersion(String labelModelVersion) {
        this.labelModelVersion = labelModelVersion;
    }

    public String getLabelModelVersion() {
        return this.labelModelVersion;
    }

    public GetLabelDetectionResult withLabelModelVersion(String labelModelVersion) {
        this.setLabelModelVersion(labelModelVersion);
        return this;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public GetLabelDetectionResult withJobId(String jobId) {
        this.setJobId(jobId);
        return this;
    }

    public void setVideo(Video video) {
        this.video = video;
    }

    public Video getVideo() {
        return this.video;
    }

    public GetLabelDetectionResult withVideo(Video video) {
        this.setVideo(video);
        return this;
    }

    public void setJobTag(String jobTag) {
        this.jobTag = jobTag;
    }

    public String getJobTag() {
        return this.jobTag;
    }

    public GetLabelDetectionResult withJobTag(String jobTag) {
        this.setJobTag(jobTag);
        return this;
    }

    public void setGetRequestMetadata(GetLabelDetectionRequestMetadata getRequestMetadata) {
        this.getRequestMetadata = getRequestMetadata;
    }

    public GetLabelDetectionRequestMetadata getGetRequestMetadata() {
        return this.getRequestMetadata;
    }

    public GetLabelDetectionResult withGetRequestMetadata(GetLabelDetectionRequestMetadata getRequestMetadata) {
        this.setGetRequestMetadata(getRequestMetadata);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobStatus() != null) {
            sb.append("JobStatus: ").append(this.getJobStatus()).append(",");
        }
        if (this.getStatusMessage() != null) {
            sb.append("StatusMessage: ").append(this.getStatusMessage()).append(",");
        }
        if (this.getVideoMetadata() != null) {
            sb.append("VideoMetadata: ").append(this.getVideoMetadata()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getLabels() != null) {
            sb.append("Labels: ").append(this.getLabels()).append(",");
        }
        if (this.getLabelModelVersion() != null) {
            sb.append("LabelModelVersion: ").append(this.getLabelModelVersion()).append(",");
        }
        if (this.getJobId() != null) {
            sb.append("JobId: ").append(this.getJobId()).append(",");
        }
        if (this.getVideo() != null) {
            sb.append("Video: ").append(this.getVideo()).append(",");
        }
        if (this.getJobTag() != null) {
            sb.append("JobTag: ").append(this.getJobTag()).append(",");
        }
        if (this.getGetRequestMetadata() != null) {
            sb.append("GetRequestMetadata: ").append(this.getGetRequestMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLabelDetectionResult)) {
            return false;
        }
        GetLabelDetectionResult other = (GetLabelDetectionResult)obj;
        if (other.getJobStatus() == null ^ this.getJobStatus() == null) {
            return false;
        }
        if (other.getJobStatus() != null && !other.getJobStatus().equals(this.getJobStatus())) {
            return false;
        }
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null) {
            return false;
        }
        if (other.getStatusMessage() != null && !other.getStatusMessage().equals(this.getStatusMessage())) {
            return false;
        }
        if (other.getVideoMetadata() == null ^ this.getVideoMetadata() == null) {
            return false;
        }
        if (other.getVideoMetadata() != null && !other.getVideoMetadata().equals(this.getVideoMetadata())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getLabels() == null ^ this.getLabels() == null) {
            return false;
        }
        if (other.getLabels() != null && !other.getLabels().equals(this.getLabels())) {
            return false;
        }
        if (other.getLabelModelVersion() == null ^ this.getLabelModelVersion() == null) {
            return false;
        }
        if (other.getLabelModelVersion() != null && !other.getLabelModelVersion().equals(this.getLabelModelVersion())) {
            return false;
        }
        if (other.getJobId() == null ^ this.getJobId() == null) {
            return false;
        }
        if (other.getJobId() != null && !other.getJobId().equals(this.getJobId())) {
            return false;
        }
        if (other.getVideo() == null ^ this.getVideo() == null) {
            return false;
        }
        if (other.getVideo() != null && !other.getVideo().equals(this.getVideo())) {
            return false;
        }
        if (other.getJobTag() == null ^ this.getJobTag() == null) {
            return false;
        }
        if (other.getJobTag() != null && !other.getJobTag().equals(this.getJobTag())) {
            return false;
        }
        if (other.getGetRequestMetadata() == null ^ this.getGetRequestMetadata() == null) {
            return false;
        }
        return other.getGetRequestMetadata() == null || other.getGetRequestMetadata().equals(this.getGetRequestMetadata());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobStatus() == null ? 0 : this.getJobStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusMessage() == null ? 0 : this.getStatusMessage().hashCode());
        hashCode = 31 * hashCode + (this.getVideoMetadata() == null ? 0 : this.getVideoMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getLabels() == null ? 0 : this.getLabels().hashCode());
        hashCode = 31 * hashCode + (this.getLabelModelVersion() == null ? 0 : this.getLabelModelVersion().hashCode());
        hashCode = 31 * hashCode + (this.getJobId() == null ? 0 : this.getJobId().hashCode());
        hashCode = 31 * hashCode + (this.getVideo() == null ? 0 : this.getVideo().hashCode());
        hashCode = 31 * hashCode + (this.getJobTag() == null ? 0 : this.getJobTag().hashCode());
        hashCode = 31 * hashCode + (this.getGetRequestMetadata() == null ? 0 : this.getGetRequestMetadata().hashCode());
        return hashCode;
    }

    public GetLabelDetectionResult clone() {
        try {
            return (GetLabelDetectionResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

