/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.rekognition.model.HumanLoopActivationOutput;
import com.amazonaws.services.rekognition.model.ModerationLabel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DetectModerationLabelsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ModerationLabel> moderationLabels;
    private String moderationModelVersion;
    private HumanLoopActivationOutput humanLoopActivationOutput;

    public List<ModerationLabel> getModerationLabels() {
        return this.moderationLabels;
    }

    public void setModerationLabels(Collection<ModerationLabel> moderationLabels) {
        if (moderationLabels == null) {
            this.moderationLabels = null;
            return;
        }
        this.moderationLabels = new ArrayList<ModerationLabel>(moderationLabels);
    }

    public DetectModerationLabelsResult withModerationLabels(ModerationLabel ... moderationLabels) {
        if (this.moderationLabels == null) {
            this.setModerationLabels(new ArrayList<ModerationLabel>(moderationLabels.length));
        }
        for (ModerationLabel ele : moderationLabels) {
            this.moderationLabels.add(ele);
        }
        return this;
    }

    public DetectModerationLabelsResult withModerationLabels(Collection<ModerationLabel> moderationLabels) {
        this.setModerationLabels(moderationLabels);
        return this;
    }

    public void setModerationModelVersion(String moderationModelVersion) {
        this.moderationModelVersion = moderationModelVersion;
    }

    public String getModerationModelVersion() {
        return this.moderationModelVersion;
    }

    public DetectModerationLabelsResult withModerationModelVersion(String moderationModelVersion) {
        this.setModerationModelVersion(moderationModelVersion);
        return this;
    }

    public void setHumanLoopActivationOutput(HumanLoopActivationOutput humanLoopActivationOutput) {
        this.humanLoopActivationOutput = humanLoopActivationOutput;
    }

    public HumanLoopActivationOutput getHumanLoopActivationOutput() {
        return this.humanLoopActivationOutput;
    }

    public DetectModerationLabelsResult withHumanLoopActivationOutput(HumanLoopActivationOutput humanLoopActivationOutput) {
        this.setHumanLoopActivationOutput(humanLoopActivationOutput);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getModerationLabels() != null) {
            sb.append("ModerationLabels: ").append(this.getModerationLabels()).append(",");
        }
        if (this.getModerationModelVersion() != null) {
            sb.append("ModerationModelVersion: ").append(this.getModerationModelVersion()).append(",");
        }
        if (this.getHumanLoopActivationOutput() != null) {
            sb.append("HumanLoopActivationOutput: ").append(this.getHumanLoopActivationOutput());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectModerationLabelsResult)) {
            return false;
        }
        DetectModerationLabelsResult other = (DetectModerationLabelsResult)obj;
        if (other.getModerationLabels() == null ^ this.getModerationLabels() == null) {
            return false;
        }
        if (other.getModerationLabels() != null && !other.getModerationLabels().equals(this.getModerationLabels())) {
            return false;
        }
        if (other.getModerationModelVersion() == null ^ this.getModerationModelVersion() == null) {
            return false;
        }
        if (other.getModerationModelVersion() != null && !other.getModerationModelVersion().equals(this.getModerationModelVersion())) {
            return false;
        }
        if (other.getHumanLoopActivationOutput() == null ^ this.getHumanLoopActivationOutput() == null) {
            return false;
        }
        return other.getHumanLoopActivationOutput() == null || other.getHumanLoopActivationOutput().equals(this.getHumanLoopActivationOutput());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getModerationLabels() == null ? 0 : this.getModerationLabels().hashCode());
        hashCode = 31 * hashCode + (this.getModerationModelVersion() == null ? 0 : this.getModerationModelVersion().hashCode());
        hashCode = 31 * hashCode + (this.getHumanLoopActivationOutput() == null ? 0 : this.getHumanLoopActivationOutput().hashCode());
        return hashCode;
    }

    public DetectModerationLabelsResult clone() {
        try {
            return (DetectModerationLabelsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

