/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.rekognition.model.ProtectiveEquipmentPerson;
import com.amazonaws.services.rekognition.model.ProtectiveEquipmentSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DetectProtectiveEquipmentResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String protectiveEquipmentModelVersion;
    private List<ProtectiveEquipmentPerson> persons;
    private ProtectiveEquipmentSummary summary;

    public void setProtectiveEquipmentModelVersion(String protectiveEquipmentModelVersion) {
        this.protectiveEquipmentModelVersion = protectiveEquipmentModelVersion;
    }

    public String getProtectiveEquipmentModelVersion() {
        return this.protectiveEquipmentModelVersion;
    }

    public DetectProtectiveEquipmentResult withProtectiveEquipmentModelVersion(String protectiveEquipmentModelVersion) {
        this.setProtectiveEquipmentModelVersion(protectiveEquipmentModelVersion);
        return this;
    }

    public List<ProtectiveEquipmentPerson> getPersons() {
        return this.persons;
    }

    public void setPersons(Collection<ProtectiveEquipmentPerson> persons) {
        if (persons == null) {
            this.persons = null;
            return;
        }
        this.persons = new ArrayList<ProtectiveEquipmentPerson>(persons);
    }

    public DetectProtectiveEquipmentResult withPersons(ProtectiveEquipmentPerson ... persons) {
        if (this.persons == null) {
            this.setPersons(new ArrayList<ProtectiveEquipmentPerson>(persons.length));
        }
        for (ProtectiveEquipmentPerson ele : persons) {
            this.persons.add(ele);
        }
        return this;
    }

    public DetectProtectiveEquipmentResult withPersons(Collection<ProtectiveEquipmentPerson> persons) {
        this.setPersons(persons);
        return this;
    }

    public void setSummary(ProtectiveEquipmentSummary summary) {
        this.summary = summary;
    }

    public ProtectiveEquipmentSummary getSummary() {
        return this.summary;
    }

    public DetectProtectiveEquipmentResult withSummary(ProtectiveEquipmentSummary summary) {
        this.setSummary(summary);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProtectiveEquipmentModelVersion() != null) {
            sb.append("ProtectiveEquipmentModelVersion: ").append(this.getProtectiveEquipmentModelVersion()).append(",");
        }
        if (this.getPersons() != null) {
            sb.append("Persons: ").append(this.getPersons()).append(",");
        }
        if (this.getSummary() != null) {
            sb.append("Summary: ").append(this.getSummary());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectProtectiveEquipmentResult)) {
            return false;
        }
        DetectProtectiveEquipmentResult other = (DetectProtectiveEquipmentResult)obj;
        if (other.getProtectiveEquipmentModelVersion() == null ^ this.getProtectiveEquipmentModelVersion() == null) {
            return false;
        }
        if (other.getProtectiveEquipmentModelVersion() != null && !other.getProtectiveEquipmentModelVersion().equals(this.getProtectiveEquipmentModelVersion())) {
            return false;
        }
        if (other.getPersons() == null ^ this.getPersons() == null) {
            return false;
        }
        if (other.getPersons() != null && !other.getPersons().equals(this.getPersons())) {
            return false;
        }
        if (other.getSummary() == null ^ this.getSummary() == null) {
            return false;
        }
        return other.getSummary() == null || other.getSummary().equals(this.getSummary());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProtectiveEquipmentModelVersion() == null ? 0 : this.getProtectiveEquipmentModelVersion().hashCode());
        hashCode = 31 * hashCode + (this.getPersons() == null ? 0 : this.getPersons().hashCode());
        hashCode = 31 * hashCode + (this.getSummary() == null ? 0 : this.getSummary().hashCode());
        return hashCode;
    }

    public DetectProtectiveEquipmentResult clone() {
        try {
            return (DetectProtectiveEquipmentResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

