/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.rekognition.model.FaceMatch;
import com.amazonaws.services.rekognition.model.transform.FaceJsonMarshaller;

public class FaceMatchJsonMarshaller {
    private static FaceMatchJsonMarshaller instance;

    public void marshall(FaceMatch faceMatch, StructuredJsonGenerator jsonGenerator) {
        if (faceMatch == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (faceMatch.getSimilarity() != null) {
                jsonGenerator.writeFieldName("Similarity").writeValue(faceMatch.getSimilarity().floatValue());
            }
            if (faceMatch.getFace() != null) {
                jsonGenerator.writeFieldName("Face");
                FaceJsonMarshaller.getInstance().marshall(faceMatch.getFace(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FaceMatchJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FaceMatchJsonMarshaller();
        }
        return instance;
    }
}

