/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.redshiftserverless.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateNamespace"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateNamespaceRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The ID of the Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials
     * secret. You can only use this parameter if <code>manageAdminPassword</code> is true.
     * </p>
     */
    private String adminPasswordSecretKmsKeyId;
    /**
     * <p>
     * The password of the administrator for the first database created in the namespace.
     * </p>
     * <p>
     * You can't use <code>adminUserPassword</code> if <code>manageAdminPassword</code> is true.
     * </p>
     */
    private String adminUserPassword;
    /**
     * <p>
     * The username of the administrator for the first database created in the namespace.
     * </p>
     */
    private String adminUsername;
    /**
     * <p>
     * The name of the first database created in the namespace.
     * </p>
     */
    private String dbName;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
     * </p>
     */
    private String defaultIamRoleArn;
    /**
     * <p>
     * A list of IAM roles to associate with the namespace.
     * </p>
     */
    private java.util.List<String> iamRoles;
    /**
     * <p>
     * The ID of the Amazon Web Services Key Management Service key used to encrypt your data.
     * </p>
     */
    private String kmsKeyId;
    /**
     * <p>
     * The types of logs the namespace can export. Available export types are <code>userlog</code>,
     * <code>connectionlog</code>, and <code>useractivitylog</code>.
     * </p>
     */
    private java.util.List<String> logExports;
    /**
     * <p>
     * If <code>true</code>, Amazon Redshift uses Secrets Manager to manage the namespace's admin credentials. You can't
     * use <code>adminUserPassword</code> if <code>manageAdminPassword</code> is true. If
     * <code>manageAdminPassword</code> is false or not set, Amazon Redshift uses <code>adminUserPassword</code> for the
     * admin user account's password.
     * </p>
     */
    private Boolean manageAdminPassword;
    /**
     * <p>
     * The name of the namespace.
     * </p>
     */
    private String namespaceName;
    /**
     * <p>
     * The ARN for the Redshift application that integrates with IAM Identity Center.
     * </p>
     */
    private String redshiftIdcApplicationArn;
    /**
     * <p>
     * A list of tag instances.
     * </p>
     */
    private java.util.List<Tag> tags;

    /**
     * <p>
     * The ID of the Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials
     * secret. You can only use this parameter if <code>manageAdminPassword</code> is true.
     * </p>
     * 
     * @param adminPasswordSecretKmsKeyId
     *        The ID of the Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials
     *        secret. You can only use this parameter if <code>manageAdminPassword</code> is true.
     */

    public void setAdminPasswordSecretKmsKeyId(String adminPasswordSecretKmsKeyId) {
        this.adminPasswordSecretKmsKeyId = adminPasswordSecretKmsKeyId;
    }

    /**
     * <p>
     * The ID of the Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials
     * secret. You can only use this parameter if <code>manageAdminPassword</code> is true.
     * </p>
     * 
     * @return The ID of the Key Management Service (KMS) key used to encrypt and store the namespace's admin
     *         credentials secret. You can only use this parameter if <code>manageAdminPassword</code> is true.
     */

    public String getAdminPasswordSecretKmsKeyId() {
        return this.adminPasswordSecretKmsKeyId;
    }

    /**
     * <p>
     * The ID of the Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials
     * secret. You can only use this parameter if <code>manageAdminPassword</code> is true.
     * </p>
     * 
     * @param adminPasswordSecretKmsKeyId
     *        The ID of the Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials
     *        secret. You can only use this parameter if <code>manageAdminPassword</code> is true.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateNamespaceRequest withAdminPasswordSecretKmsKeyId(String adminPasswordSecretKmsKeyId) {
        setAdminPasswordSecretKmsKeyId(adminPasswordSecretKmsKeyId);
        return this;
    }

    /**
     * <p>
     * The password of the administrator for the first database created in the namespace.
     * </p>
     * <p>
     * You can't use <code>adminUserPassword</code> if <code>manageAdminPassword</code> is true.
     * </p>
     * 
     * @param adminUserPassword
     *        The password of the administrator for the first database created in the namespace.</p>
     *        <p>
     *        You can't use <code>adminUserPassword</code> if <code>manageAdminPassword</code> is true.
     */

    public void setAdminUserPassword(String adminUserPassword) {
        this.adminUserPassword = adminUserPassword;
    }

    /**
     * <p>
     * The password of the administrator for the first database created in the namespace.
     * </p>
     * <p>
     * You can't use <code>adminUserPassword</code> if <code>manageAdminPassword</code> is true.
     * </p>
     * 
     * @return The password of the administrator for the first database created in the namespace.</p>
     *         <p>
     *         You can't use <code>adminUserPassword</code> if <code>manageAdminPassword</code> is true.
     */

    public String getAdminUserPassword() {
        return this.adminUserPassword;
    }

    /**
     * <p>
     * The password of the administrator for the first database created in the namespace.
     * </p>
     * <p>
     * You can't use <code>adminUserPassword</code> if <code>manageAdminPassword</code> is true.
     * </p>
     * 
     * @param adminUserPassword
     *        The password of the administrator for the first database created in the namespace.</p>
     *        <p>
     *        You can't use <code>adminUserPassword</code> if <code>manageAdminPassword</code> is true.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateNamespaceRequest withAdminUserPassword(String adminUserPassword) {
        setAdminUserPassword(adminUserPassword);
        return this;
    }

    /**
     * <p>
     * The username of the administrator for the first database created in the namespace.
     * </p>
     * 
     * @param adminUsername
     *        The username of the administrator for the first database created in the namespace.
     */

    public void setAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
    }

    /**
     * <p>
     * The username of the administrator for the first database created in the namespace.
     * </p>
     * 
     * @return The username of the administrator for the first database created in the namespace.
     */

    public String getAdminUsername() {
        return this.adminUsername;
    }

    /**
     * <p>
     * The username of the administrator for the first database created in the namespace.
     * </p>
     * 
     * @param adminUsername
     *        The username of the administrator for the first database created in the namespace.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateNamespaceRequest withAdminUsername(String adminUsername) {
        setAdminUsername(adminUsername);
        return this;
    }

    /**
     * <p>
     * The name of the first database created in the namespace.
     * </p>
     * 
     * @param dbName
     *        The name of the first database created in the namespace.
     */

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    /**
     * <p>
     * The name of the first database created in the namespace.
     * </p>
     * 
     * @return The name of the first database created in the namespace.
     */

    public String getDbName() {
        return this.dbName;
    }

    /**
     * <p>
     * The name of the first database created in the namespace.
     * </p>
     * 
     * @param dbName
     *        The name of the first database created in the namespace.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateNamespaceRequest withDbName(String dbName) {
        setDbName(dbName);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
     * </p>
     * 
     * @param defaultIamRoleArn
     *        The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
     */

    public void setDefaultIamRoleArn(String defaultIamRoleArn) {
        this.defaultIamRoleArn = defaultIamRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
     */

    public String getDefaultIamRoleArn() {
        return this.defaultIamRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
     * </p>
     * 
     * @param defaultIamRoleArn
     *        The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateNamespaceRequest withDefaultIamRoleArn(String defaultIamRoleArn) {
        setDefaultIamRoleArn(defaultIamRoleArn);
        return this;
    }

    /**
     * <p>
     * A list of IAM roles to associate with the namespace.
     * </p>
     * 
     * @return A list of IAM roles to associate with the namespace.
     */

    public java.util.List<String> getIamRoles() {
        return iamRoles;
    }

    /**
     * <p>
     * A list of IAM roles to associate with the namespace.
     * </p>
     * 
     * @param iamRoles
     *        A list of IAM roles to associate with the namespace.
     */

    public void setIamRoles(java.util.Collection<String> iamRoles) {
        if (iamRoles == null) {
            this.iamRoles = null;
            return;
        }

        this.iamRoles = new java.util.ArrayList<String>(iamRoles);
    }

    /**
     * <p>
     * A list of IAM roles to associate with the namespace.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setIamRoles(java.util.Collection)} or {@link #withIamRoles(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param iamRoles
     *        A list of IAM roles to associate with the namespace.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateNamespaceRequest withIamRoles(String... iamRoles) {
        if (this.iamRoles == null) {
            setIamRoles(new java.util.ArrayList<String>(iamRoles.length));
        }
        for (String ele : iamRoles) {
            this.iamRoles.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of IAM roles to associate with the namespace.
     * </p>
     * 
     * @param iamRoles
     *        A list of IAM roles to associate with the namespace.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateNamespaceRequest withIamRoles(java.util.Collection<String> iamRoles) {
        setIamRoles(iamRoles);
        return this;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services Key Management Service key used to encrypt your data.
     * </p>
     * 
     * @param kmsKeyId
     *        The ID of the Amazon Web Services Key Management Service key used to encrypt your data.
     */

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services Key Management Service key used to encrypt your data.
     * </p>
     * 
     * @return The ID of the Amazon Web Services Key Management Service key used to encrypt your data.
     */

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services Key Management Service key used to encrypt your data.
     * </p>
     * 
     * @param kmsKeyId
     *        The ID of the Amazon Web Services Key Management Service key used to encrypt your data.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateNamespaceRequest withKmsKeyId(String kmsKeyId) {
        setKmsKeyId(kmsKeyId);
        return this;
    }

    /**
     * <p>
     * The types of logs the namespace can export. Available export types are <code>userlog</code>,
     * <code>connectionlog</code>, and <code>useractivitylog</code>.
     * </p>
     * 
     * @return The types of logs the namespace can export. Available export types are <code>userlog</code>,
     *         <code>connectionlog</code>, and <code>useractivitylog</code>.
     * @see LogExport
     */

    public java.util.List<String> getLogExports() {
        return logExports;
    }

    /**
     * <p>
     * The types of logs the namespace can export. Available export types are <code>userlog</code>,
     * <code>connectionlog</code>, and <code>useractivitylog</code>.
     * </p>
     * 
     * @param logExports
     *        The types of logs the namespace can export. Available export types are <code>userlog</code>,
     *        <code>connectionlog</code>, and <code>useractivitylog</code>.
     * @see LogExport
     */

    public void setLogExports(java.util.Collection<String> logExports) {
        if (logExports == null) {
            this.logExports = null;
            return;
        }

        this.logExports = new java.util.ArrayList<String>(logExports);
    }

    /**
     * <p>
     * The types of logs the namespace can export. Available export types are <code>userlog</code>,
     * <code>connectionlog</code>, and <code>useractivitylog</code>.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setLogExports(java.util.Collection)} or {@link #withLogExports(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param logExports
     *        The types of logs the namespace can export. Available export types are <code>userlog</code>,
     *        <code>connectionlog</code>, and <code>useractivitylog</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see LogExport
     */

    public CreateNamespaceRequest withLogExports(String... logExports) {
        if (this.logExports == null) {
            setLogExports(new java.util.ArrayList<String>(logExports.length));
        }
        for (String ele : logExports) {
            this.logExports.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The types of logs the namespace can export. Available export types are <code>userlog</code>,
     * <code>connectionlog</code>, and <code>useractivitylog</code>.
     * </p>
     * 
     * @param logExports
     *        The types of logs the namespace can export. Available export types are <code>userlog</code>,
     *        <code>connectionlog</code>, and <code>useractivitylog</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see LogExport
     */

    public CreateNamespaceRequest withLogExports(java.util.Collection<String> logExports) {
        setLogExports(logExports);
        return this;
    }

    /**
     * <p>
     * The types of logs the namespace can export. Available export types are <code>userlog</code>,
     * <code>connectionlog</code>, and <code>useractivitylog</code>.
     * </p>
     * 
     * @param logExports
     *        The types of logs the namespace can export. Available export types are <code>userlog</code>,
     *        <code>connectionlog</code>, and <code>useractivitylog</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see LogExport
     */

    public CreateNamespaceRequest withLogExports(LogExport... logExports) {
        java.util.ArrayList<String> logExportsCopy = new java.util.ArrayList<String>(logExports.length);
        for (LogExport value : logExports) {
            logExportsCopy.add(value.toString());
        }
        if (getLogExports() == null) {
            setLogExports(logExportsCopy);
        } else {
            getLogExports().addAll(logExportsCopy);
        }
        return this;
    }

    /**
     * <p>
     * If <code>true</code>, Amazon Redshift uses Secrets Manager to manage the namespace's admin credentials. You can't
     * use <code>adminUserPassword</code> if <code>manageAdminPassword</code> is true. If
     * <code>manageAdminPassword</code> is false or not set, Amazon Redshift uses <code>adminUserPassword</code> for the
     * admin user account's password.
     * </p>
     * 
     * @param manageAdminPassword
     *        If <code>true</code>, Amazon Redshift uses Secrets Manager to manage the namespace's admin credentials.
     *        You can't use <code>adminUserPassword</code> if <code>manageAdminPassword</code> is true. If
     *        <code>manageAdminPassword</code> is false or not set, Amazon Redshift uses <code>adminUserPassword</code>
     *        for the admin user account's password.
     */

    public void setManageAdminPassword(Boolean manageAdminPassword) {
        this.manageAdminPassword = manageAdminPassword;
    }

    /**
     * <p>
     * If <code>true</code>, Amazon Redshift uses Secrets Manager to manage the namespace's admin credentials. You can't
     * use <code>adminUserPassword</code> if <code>manageAdminPassword</code> is true. If
     * <code>manageAdminPassword</code> is false or not set, Amazon Redshift uses <code>adminUserPassword</code> for the
     * admin user account's password.
     * </p>
     * 
     * @return If <code>true</code>, Amazon Redshift uses Secrets Manager to manage the namespace's admin credentials.
     *         You can't use <code>adminUserPassword</code> if <code>manageAdminPassword</code> is true. If
     *         <code>manageAdminPassword</code> is false or not set, Amazon Redshift uses <code>adminUserPassword</code>
     *         for the admin user account's password.
     */

    public Boolean getManageAdminPassword() {
        return this.manageAdminPassword;
    }

    /**
     * <p>
     * If <code>true</code>, Amazon Redshift uses Secrets Manager to manage the namespace's admin credentials. You can't
     * use <code>adminUserPassword</code> if <code>manageAdminPassword</code> is true. If
     * <code>manageAdminPassword</code> is false or not set, Amazon Redshift uses <code>adminUserPassword</code> for the
     * admin user account's password.
     * </p>
     * 
     * @param manageAdminPassword
     *        If <code>true</code>, Amazon Redshift uses Secrets Manager to manage the namespace's admin credentials.
     *        You can't use <code>adminUserPassword</code> if <code>manageAdminPassword</code> is true. If
     *        <code>manageAdminPassword</code> is false or not set, Amazon Redshift uses <code>adminUserPassword</code>
     *        for the admin user account's password.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateNamespaceRequest withManageAdminPassword(Boolean manageAdminPassword) {
        setManageAdminPassword(manageAdminPassword);
        return this;
    }

    /**
     * <p>
     * If <code>true</code>, Amazon Redshift uses Secrets Manager to manage the namespace's admin credentials. You can't
     * use <code>adminUserPassword</code> if <code>manageAdminPassword</code> is true. If
     * <code>manageAdminPassword</code> is false or not set, Amazon Redshift uses <code>adminUserPassword</code> for the
     * admin user account's password.
     * </p>
     * 
     * @return If <code>true</code>, Amazon Redshift uses Secrets Manager to manage the namespace's admin credentials.
     *         You can't use <code>adminUserPassword</code> if <code>manageAdminPassword</code> is true. If
     *         <code>manageAdminPassword</code> is false or not set, Amazon Redshift uses <code>adminUserPassword</code>
     *         for the admin user account's password.
     */

    public Boolean isManageAdminPassword() {
        return this.manageAdminPassword;
    }

    /**
     * <p>
     * The name of the namespace.
     * </p>
     * 
     * @param namespaceName
     *        The name of the namespace.
     */

    public void setNamespaceName(String namespaceName) {
        this.namespaceName = namespaceName;
    }

    /**
     * <p>
     * The name of the namespace.
     * </p>
     * 
     * @return The name of the namespace.
     */

    public String getNamespaceName() {
        return this.namespaceName;
    }

    /**
     * <p>
     * The name of the namespace.
     * </p>
     * 
     * @param namespaceName
     *        The name of the namespace.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateNamespaceRequest withNamespaceName(String namespaceName) {
        setNamespaceName(namespaceName);
        return this;
    }

    /**
     * <p>
     * The ARN for the Redshift application that integrates with IAM Identity Center.
     * </p>
     * 
     * @param redshiftIdcApplicationArn
     *        The ARN for the Redshift application that integrates with IAM Identity Center.
     */

    public void setRedshiftIdcApplicationArn(String redshiftIdcApplicationArn) {
        this.redshiftIdcApplicationArn = redshiftIdcApplicationArn;
    }

    /**
     * <p>
     * The ARN for the Redshift application that integrates with IAM Identity Center.
     * </p>
     * 
     * @return The ARN for the Redshift application that integrates with IAM Identity Center.
     */

    public String getRedshiftIdcApplicationArn() {
        return this.redshiftIdcApplicationArn;
    }

    /**
     * <p>
     * The ARN for the Redshift application that integrates with IAM Identity Center.
     * </p>
     * 
     * @param redshiftIdcApplicationArn
     *        The ARN for the Redshift application that integrates with IAM Identity Center.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateNamespaceRequest withRedshiftIdcApplicationArn(String redshiftIdcApplicationArn) {
        setRedshiftIdcApplicationArn(redshiftIdcApplicationArn);
        return this;
    }

    /**
     * <p>
     * A list of tag instances.
     * </p>
     * 
     * @return A list of tag instances.
     */

    public java.util.List<Tag> getTags() {
        return tags;
    }

    /**
     * <p>
     * A list of tag instances.
     * </p>
     * 
     * @param tags
     *        A list of tag instances.
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new java.util.ArrayList<Tag>(tags);
    }

    /**
     * <p>
     * A list of tag instances.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     *        A list of tag instances.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateNamespaceRequest withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new java.util.ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of tag instances.
     * </p>
     * 
     * @param tags
     *        A list of tag instances.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateNamespaceRequest withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAdminPasswordSecretKmsKeyId() != null)
            sb.append("AdminPasswordSecretKmsKeyId: ").append(getAdminPasswordSecretKmsKeyId()).append(",");
        if (getAdminUserPassword() != null)
            sb.append("AdminUserPassword: ").append("***Sensitive Data Redacted***").append(",");
        if (getAdminUsername() != null)
            sb.append("AdminUsername: ").append("***Sensitive Data Redacted***").append(",");
        if (getDbName() != null)
            sb.append("DbName: ").append(getDbName()).append(",");
        if (getDefaultIamRoleArn() != null)
            sb.append("DefaultIamRoleArn: ").append(getDefaultIamRoleArn()).append(",");
        if (getIamRoles() != null)
            sb.append("IamRoles: ").append(getIamRoles()).append(",");
        if (getKmsKeyId() != null)
            sb.append("KmsKeyId: ").append(getKmsKeyId()).append(",");
        if (getLogExports() != null)
            sb.append("LogExports: ").append(getLogExports()).append(",");
        if (getManageAdminPassword() != null)
            sb.append("ManageAdminPassword: ").append(getManageAdminPassword()).append(",");
        if (getNamespaceName() != null)
            sb.append("NamespaceName: ").append(getNamespaceName()).append(",");
        if (getRedshiftIdcApplicationArn() != null)
            sb.append("RedshiftIdcApplicationArn: ").append(getRedshiftIdcApplicationArn()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateNamespaceRequest == false)
            return false;
        CreateNamespaceRequest other = (CreateNamespaceRequest) obj;
        if (other.getAdminPasswordSecretKmsKeyId() == null ^ this.getAdminPasswordSecretKmsKeyId() == null)
            return false;
        if (other.getAdminPasswordSecretKmsKeyId() != null && other.getAdminPasswordSecretKmsKeyId().equals(this.getAdminPasswordSecretKmsKeyId()) == false)
            return false;
        if (other.getAdminUserPassword() == null ^ this.getAdminUserPassword() == null)
            return false;
        if (other.getAdminUserPassword() != null && other.getAdminUserPassword().equals(this.getAdminUserPassword()) == false)
            return false;
        if (other.getAdminUsername() == null ^ this.getAdminUsername() == null)
            return false;
        if (other.getAdminUsername() != null && other.getAdminUsername().equals(this.getAdminUsername()) == false)
            return false;
        if (other.getDbName() == null ^ this.getDbName() == null)
            return false;
        if (other.getDbName() != null && other.getDbName().equals(this.getDbName()) == false)
            return false;
        if (other.getDefaultIamRoleArn() == null ^ this.getDefaultIamRoleArn() == null)
            return false;
        if (other.getDefaultIamRoleArn() != null && other.getDefaultIamRoleArn().equals(this.getDefaultIamRoleArn()) == false)
            return false;
        if (other.getIamRoles() == null ^ this.getIamRoles() == null)
            return false;
        if (other.getIamRoles() != null && other.getIamRoles().equals(this.getIamRoles()) == false)
            return false;
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null)
            return false;
        if (other.getKmsKeyId() != null && other.getKmsKeyId().equals(this.getKmsKeyId()) == false)
            return false;
        if (other.getLogExports() == null ^ this.getLogExports() == null)
            return false;
        if (other.getLogExports() != null && other.getLogExports().equals(this.getLogExports()) == false)
            return false;
        if (other.getManageAdminPassword() == null ^ this.getManageAdminPassword() == null)
            return false;
        if (other.getManageAdminPassword() != null && other.getManageAdminPassword().equals(this.getManageAdminPassword()) == false)
            return false;
        if (other.getNamespaceName() == null ^ this.getNamespaceName() == null)
            return false;
        if (other.getNamespaceName() != null && other.getNamespaceName().equals(this.getNamespaceName()) == false)
            return false;
        if (other.getRedshiftIdcApplicationArn() == null ^ this.getRedshiftIdcApplicationArn() == null)
            return false;
        if (other.getRedshiftIdcApplicationArn() != null && other.getRedshiftIdcApplicationArn().equals(this.getRedshiftIdcApplicationArn()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAdminPasswordSecretKmsKeyId() == null) ? 0 : getAdminPasswordSecretKmsKeyId().hashCode());
        hashCode = prime * hashCode + ((getAdminUserPassword() == null) ? 0 : getAdminUserPassword().hashCode());
        hashCode = prime * hashCode + ((getAdminUsername() == null) ? 0 : getAdminUsername().hashCode());
        hashCode = prime * hashCode + ((getDbName() == null) ? 0 : getDbName().hashCode());
        hashCode = prime * hashCode + ((getDefaultIamRoleArn() == null) ? 0 : getDefaultIamRoleArn().hashCode());
        hashCode = prime * hashCode + ((getIamRoles() == null) ? 0 : getIamRoles().hashCode());
        hashCode = prime * hashCode + ((getKmsKeyId() == null) ? 0 : getKmsKeyId().hashCode());
        hashCode = prime * hashCode + ((getLogExports() == null) ? 0 : getLogExports().hashCode());
        hashCode = prime * hashCode + ((getManageAdminPassword() == null) ? 0 : getManageAdminPassword().hashCode());
        hashCode = prime * hashCode + ((getNamespaceName() == null) ? 0 : getNamespaceName().hashCode());
        hashCode = prime * hashCode + ((getRedshiftIdcApplicationArn() == null) ? 0 : getRedshiftIdcApplicationArn().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateNamespaceRequest clone() {
        return (CreateNamespaceRequest) super.clone();
    }

}
