/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.redshiftdataapi.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/GetStatementResult" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetStatementResultRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The identifier of the SQL statement whose results are to be fetched. This value is a universally unique
     * identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates then number of the SQL statement. For
     * example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the
     * second SQL statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>,
     * <code>ExecuteStatment</code>, and <code>ListStatements</code>.
     * </p>
     */
    private String id;
    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned NextToken
     * value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response
     * records have been retrieved for the request.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * The identifier of the SQL statement whose results are to be fetched. This value is a universally unique
     * identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates then number of the SQL statement. For
     * example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the
     * second SQL statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>,
     * <code>ExecuteStatment</code>, and <code>ListStatements</code>.
     * </p>
     * 
     * @param id
     *        The identifier of the SQL statement whose results are to be fetched. This value is a universally unique
     *        identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates then number of the SQL
     *        statement. For example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of
     *        <code>:2</code> that indicates the second SQL statement of a batch query. This identifier is returned by
     *        <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>, and <code>ListStatements</code>.
     */

    public void setId(String id) {
        this.id = id;
    }

    /**
     * <p>
     * The identifier of the SQL statement whose results are to be fetched. This value is a universally unique
     * identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates then number of the SQL statement. For
     * example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the
     * second SQL statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>,
     * <code>ExecuteStatment</code>, and <code>ListStatements</code>.
     * </p>
     * 
     * @return The identifier of the SQL statement whose results are to be fetched. This value is a universally unique
     *         identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates then number of the SQL
     *         statement. For example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of
     *         <code>:2</code> that indicates the second SQL statement of a batch query. This identifier is returned by
     *         <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>, and <code>ListStatements</code>.
     */

    public String getId() {
        return this.id;
    }

    /**
     * <p>
     * The identifier of the SQL statement whose results are to be fetched. This value is a universally unique
     * identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates then number of the SQL statement. For
     * example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the
     * second SQL statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>,
     * <code>ExecuteStatment</code>, and <code>ListStatements</code>.
     * </p>
     * 
     * @param id
     *        The identifier of the SQL statement whose results are to be fetched. This value is a universally unique
     *        identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates then number of the SQL
     *        statement. For example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of
     *        <code>:2</code> that indicates the second SQL statement of a batch query. This identifier is returned by
     *        <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>, and <code>ListStatements</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetStatementResultRequest withId(String id) {
        setId(id);
        return this;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned NextToken
     * value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response
     * records have been retrieved for the request.
     * </p>
     * 
     * @param nextToken
     *        A value that indicates the starting point for the next set of response records in a subsequent request. If
     *        a value is returned in a response, you can retrieve the next set of records by providing this returned
     *        NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty,
     *        all response records have been retrieved for the request.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned NextToken
     * value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response
     * records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is
     *         empty, all response records have been retrieved for the request.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned NextToken
     * value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response
     * records have been retrieved for the request.
     * </p>
     * 
     * @param nextToken
     *        A value that indicates the starting point for the next set of response records in a subsequent request. If
     *        a value is returned in a response, you can retrieve the next set of records by providing this returned
     *        NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty,
     *        all response records have been retrieved for the request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetStatementResultRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getId() != null)
            sb.append("Id: ").append(getId()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetStatementResultRequest == false)
            return false;
        GetStatementResultRequest other = (GetStatementResultRequest) obj;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public GetStatementResultRequest clone() {
        return (GetStatementResultRequest) super.clone();
    }

}
