/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.services.redshift.model.InboundIntegration;
import com.amazonaws.services.redshift.model.IntegrationError;
import com.amazonaws.services.redshift.model.transform.IntegrationErrorStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class InboundIntegrationStaxUnmarshaller
implements Unmarshaller<InboundIntegration, StaxUnmarshallerContext> {
    private static InboundIntegrationStaxUnmarshaller instance;

    public InboundIntegration unmarshall(StaxUnmarshallerContext context) throws Exception {
        InboundIntegration inboundIntegration = new InboundIntegration();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return inboundIntegration;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("IntegrationArn", targetDepth)) {
                    inboundIntegration.setIntegrationArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SourceArn", targetDepth)) {
                    inboundIntegration.setSourceArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TargetArn", targetDepth)) {
                    inboundIntegration.setTargetArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    inboundIntegration.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Errors", targetDepth)) {
                    inboundIntegration.withErrors(new ArrayList<IntegrationError>());
                    continue;
                }
                if (context.testExpression("Errors/IntegrationError", targetDepth)) {
                    inboundIntegration.withErrors(IntegrationErrorStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CreateTime", targetDepth)) continue;
                inboundIntegration.setCreateTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return inboundIntegration;
    }

    public static InboundIntegrationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new InboundIntegrationStaxUnmarshaller();
        }
        return instance;
    }
}

