/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateClusterRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String dBName;
    private String clusterIdentifier;
    private String clusterType;
    private String nodeType;
    private String masterUsername;
    private String masterUserPassword;
    private SdkInternalList<String> clusterSecurityGroups;
    private SdkInternalList<String> vpcSecurityGroupIds;
    private String clusterSubnetGroupName;
    private String availabilityZone;
    private String preferredMaintenanceWindow;
    private String clusterParameterGroupName;
    private Integer automatedSnapshotRetentionPeriod;
    private Integer port;
    private String clusterVersion;
    private Boolean allowVersionUpgrade;
    private Integer numberOfNodes;
    private Boolean publiclyAccessible;
    private Boolean encrypted;
    private String hsmClientCertificateIdentifier;
    private String hsmConfigurationIdentifier;
    private String elasticIp;
    private SdkInternalList<Tag> tags;
    private String kmsKeyId;
    private Boolean enhancedVpcRouting;
    private String additionalInfo;
    private SdkInternalList<String> iamRoles;

    public void setDBName(String dBName) {
        this.dBName = dBName;
    }

    public String getDBName() {
        return this.dBName;
    }

    public CreateClusterRequest withDBName(String dBName) {
        this.setDBName(dBName);
        return this;
    }

    public void setClusterIdentifier(String clusterIdentifier) {
        this.clusterIdentifier = clusterIdentifier;
    }

    public String getClusterIdentifier() {
        return this.clusterIdentifier;
    }

    public CreateClusterRequest withClusterIdentifier(String clusterIdentifier) {
        this.setClusterIdentifier(clusterIdentifier);
        return this;
    }

    public void setClusterType(String clusterType) {
        this.clusterType = clusterType;
    }

    public String getClusterType() {
        return this.clusterType;
    }

    public CreateClusterRequest withClusterType(String clusterType) {
        this.setClusterType(clusterType);
        return this;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public CreateClusterRequest withNodeType(String nodeType) {
        this.setNodeType(nodeType);
        return this;
    }

    public void setMasterUsername(String masterUsername) {
        this.masterUsername = masterUsername;
    }

    public String getMasterUsername() {
        return this.masterUsername;
    }

    public CreateClusterRequest withMasterUsername(String masterUsername) {
        this.setMasterUsername(masterUsername);
        return this;
    }

    public void setMasterUserPassword(String masterUserPassword) {
        this.masterUserPassword = masterUserPassword;
    }

    public String getMasterUserPassword() {
        return this.masterUserPassword;
    }

    public CreateClusterRequest withMasterUserPassword(String masterUserPassword) {
        this.setMasterUserPassword(masterUserPassword);
        return this;
    }

    public List<String> getClusterSecurityGroups() {
        if (this.clusterSecurityGroups == null) {
            this.clusterSecurityGroups = new SdkInternalList();
        }
        return this.clusterSecurityGroups;
    }

    public void setClusterSecurityGroups(Collection<String> clusterSecurityGroups) {
        if (clusterSecurityGroups == null) {
            this.clusterSecurityGroups = null;
            return;
        }
        this.clusterSecurityGroups = new SdkInternalList(clusterSecurityGroups);
    }

    public CreateClusterRequest withClusterSecurityGroups(String ... clusterSecurityGroups) {
        if (this.clusterSecurityGroups == null) {
            this.setClusterSecurityGroups((Collection<String>)new SdkInternalList(clusterSecurityGroups.length));
        }
        for (String ele : clusterSecurityGroups) {
            this.clusterSecurityGroups.add((Object)ele);
        }
        return this;
    }

    public CreateClusterRequest withClusterSecurityGroups(Collection<String> clusterSecurityGroups) {
        this.setClusterSecurityGroups(clusterSecurityGroups);
        return this;
    }

    public List<String> getVpcSecurityGroupIds() {
        if (this.vpcSecurityGroupIds == null) {
            this.vpcSecurityGroupIds = new SdkInternalList();
        }
        return this.vpcSecurityGroupIds;
    }

    public void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
        if (vpcSecurityGroupIds == null) {
            this.vpcSecurityGroupIds = null;
            return;
        }
        this.vpcSecurityGroupIds = new SdkInternalList(vpcSecurityGroupIds);
    }

    public CreateClusterRequest withVpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
        if (this.vpcSecurityGroupIds == null) {
            this.setVpcSecurityGroupIds((Collection<String>)new SdkInternalList(vpcSecurityGroupIds.length));
        }
        for (String ele : vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds.add((Object)ele);
        }
        return this;
    }

    public CreateClusterRequest withVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
        this.setVpcSecurityGroupIds(vpcSecurityGroupIds);
        return this;
    }

    public void setClusterSubnetGroupName(String clusterSubnetGroupName) {
        this.clusterSubnetGroupName = clusterSubnetGroupName;
    }

    public String getClusterSubnetGroupName() {
        return this.clusterSubnetGroupName;
    }

    public CreateClusterRequest withClusterSubnetGroupName(String clusterSubnetGroupName) {
        this.setClusterSubnetGroupName(clusterSubnetGroupName);
        return this;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public CreateClusterRequest withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public CreateClusterRequest withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.setPreferredMaintenanceWindow(preferredMaintenanceWindow);
        return this;
    }

    public void setClusterParameterGroupName(String clusterParameterGroupName) {
        this.clusterParameterGroupName = clusterParameterGroupName;
    }

    public String getClusterParameterGroupName() {
        return this.clusterParameterGroupName;
    }

    public CreateClusterRequest withClusterParameterGroupName(String clusterParameterGroupName) {
        this.setClusterParameterGroupName(clusterParameterGroupName);
        return this;
    }

    public void setAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
        this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
    }

    public Integer getAutomatedSnapshotRetentionPeriod() {
        return this.automatedSnapshotRetentionPeriod;
    }

    public CreateClusterRequest withAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
        this.setAutomatedSnapshotRetentionPeriod(automatedSnapshotRetentionPeriod);
        return this;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getPort() {
        return this.port;
    }

    public CreateClusterRequest withPort(Integer port) {
        this.setPort(port);
        return this;
    }

    public void setClusterVersion(String clusterVersion) {
        this.clusterVersion = clusterVersion;
    }

    public String getClusterVersion() {
        return this.clusterVersion;
    }

    public CreateClusterRequest withClusterVersion(String clusterVersion) {
        this.setClusterVersion(clusterVersion);
        return this;
    }

    public void setAllowVersionUpgrade(Boolean allowVersionUpgrade) {
        this.allowVersionUpgrade = allowVersionUpgrade;
    }

    public Boolean getAllowVersionUpgrade() {
        return this.allowVersionUpgrade;
    }

    public CreateClusterRequest withAllowVersionUpgrade(Boolean allowVersionUpgrade) {
        this.setAllowVersionUpgrade(allowVersionUpgrade);
        return this;
    }

    public Boolean isAllowVersionUpgrade() {
        return this.allowVersionUpgrade;
    }

    public void setNumberOfNodes(Integer numberOfNodes) {
        this.numberOfNodes = numberOfNodes;
    }

    public Integer getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public CreateClusterRequest withNumberOfNodes(Integer numberOfNodes) {
        this.setNumberOfNodes(numberOfNodes);
        return this;
    }

    public void setPubliclyAccessible(Boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
    }

    public Boolean getPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public CreateClusterRequest withPubliclyAccessible(Boolean publiclyAccessible) {
        this.setPubliclyAccessible(publiclyAccessible);
        return this;
    }

    public Boolean isPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public void setEncrypted(Boolean encrypted) {
        this.encrypted = encrypted;
    }

    public Boolean getEncrypted() {
        return this.encrypted;
    }

    public CreateClusterRequest withEncrypted(Boolean encrypted) {
        this.setEncrypted(encrypted);
        return this;
    }

    public Boolean isEncrypted() {
        return this.encrypted;
    }

    public void setHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
        this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
    }

    public String getHsmClientCertificateIdentifier() {
        return this.hsmClientCertificateIdentifier;
    }

    public CreateClusterRequest withHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
        this.setHsmClientCertificateIdentifier(hsmClientCertificateIdentifier);
        return this;
    }

    public void setHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
        this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
    }

    public String getHsmConfigurationIdentifier() {
        return this.hsmConfigurationIdentifier;
    }

    public CreateClusterRequest withHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
        this.setHsmConfigurationIdentifier(hsmConfigurationIdentifier);
        return this;
    }

    public void setElasticIp(String elasticIp) {
        this.elasticIp = elasticIp;
    }

    public String getElasticIp() {
        return this.elasticIp;
    }

    public CreateClusterRequest withElasticIp(String elasticIp) {
        this.setElasticIp(elasticIp);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreateClusterRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreateClusterRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public CreateClusterRequest withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
        this.enhancedVpcRouting = enhancedVpcRouting;
    }

    public Boolean getEnhancedVpcRouting() {
        return this.enhancedVpcRouting;
    }

    public CreateClusterRequest withEnhancedVpcRouting(Boolean enhancedVpcRouting) {
        this.setEnhancedVpcRouting(enhancedVpcRouting);
        return this;
    }

    public Boolean isEnhancedVpcRouting() {
        return this.enhancedVpcRouting;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public CreateClusterRequest withAdditionalInfo(String additionalInfo) {
        this.setAdditionalInfo(additionalInfo);
        return this;
    }

    public List<String> getIamRoles() {
        if (this.iamRoles == null) {
            this.iamRoles = new SdkInternalList();
        }
        return this.iamRoles;
    }

    public void setIamRoles(Collection<String> iamRoles) {
        if (iamRoles == null) {
            this.iamRoles = null;
            return;
        }
        this.iamRoles = new SdkInternalList(iamRoles);
    }

    public CreateClusterRequest withIamRoles(String ... iamRoles) {
        if (this.iamRoles == null) {
            this.setIamRoles((Collection<String>)new SdkInternalList(iamRoles.length));
        }
        for (String ele : iamRoles) {
            this.iamRoles.add((Object)ele);
        }
        return this;
    }

    public CreateClusterRequest withIamRoles(Collection<String> iamRoles) {
        this.setIamRoles(iamRoles);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDBName() != null) {
            sb.append("DBName: ").append(this.getDBName()).append(",");
        }
        if (this.getClusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.getClusterIdentifier()).append(",");
        }
        if (this.getClusterType() != null) {
            sb.append("ClusterType: ").append(this.getClusterType()).append(",");
        }
        if (this.getNodeType() != null) {
            sb.append("NodeType: ").append(this.getNodeType()).append(",");
        }
        if (this.getMasterUsername() != null) {
            sb.append("MasterUsername: ").append(this.getMasterUsername()).append(",");
        }
        if (this.getMasterUserPassword() != null) {
            sb.append("MasterUserPassword: ").append(this.getMasterUserPassword()).append(",");
        }
        if (this.getClusterSecurityGroups() != null) {
            sb.append("ClusterSecurityGroups: ").append(this.getClusterSecurityGroups()).append(",");
        }
        if (this.getVpcSecurityGroupIds() != null) {
            sb.append("VpcSecurityGroupIds: ").append(this.getVpcSecurityGroupIds()).append(",");
        }
        if (this.getClusterSubnetGroupName() != null) {
            sb.append("ClusterSubnetGroupName: ").append(this.getClusterSubnetGroupName()).append(",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.getAvailabilityZone()).append(",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.getPreferredMaintenanceWindow()).append(",");
        }
        if (this.getClusterParameterGroupName() != null) {
            sb.append("ClusterParameterGroupName: ").append(this.getClusterParameterGroupName()).append(",");
        }
        if (this.getAutomatedSnapshotRetentionPeriod() != null) {
            sb.append("AutomatedSnapshotRetentionPeriod: ").append(this.getAutomatedSnapshotRetentionPeriod()).append(",");
        }
        if (this.getPort() != null) {
            sb.append("Port: ").append(this.getPort()).append(",");
        }
        if (this.getClusterVersion() != null) {
            sb.append("ClusterVersion: ").append(this.getClusterVersion()).append(",");
        }
        if (this.getAllowVersionUpgrade() != null) {
            sb.append("AllowVersionUpgrade: ").append(this.getAllowVersionUpgrade()).append(",");
        }
        if (this.getNumberOfNodes() != null) {
            sb.append("NumberOfNodes: ").append(this.getNumberOfNodes()).append(",");
        }
        if (this.getPubliclyAccessible() != null) {
            sb.append("PubliclyAccessible: ").append(this.getPubliclyAccessible()).append(",");
        }
        if (this.getEncrypted() != null) {
            sb.append("Encrypted: ").append(this.getEncrypted()).append(",");
        }
        if (this.getHsmClientCertificateIdentifier() != null) {
            sb.append("HsmClientCertificateIdentifier: ").append(this.getHsmClientCertificateIdentifier()).append(",");
        }
        if (this.getHsmConfigurationIdentifier() != null) {
            sb.append("HsmConfigurationIdentifier: ").append(this.getHsmConfigurationIdentifier()).append(",");
        }
        if (this.getElasticIp() != null) {
            sb.append("ElasticIp: ").append(this.getElasticIp()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getEnhancedVpcRouting() != null) {
            sb.append("EnhancedVpcRouting: ").append(this.getEnhancedVpcRouting()).append(",");
        }
        if (this.getAdditionalInfo() != null) {
            sb.append("AdditionalInfo: ").append(this.getAdditionalInfo()).append(",");
        }
        if (this.getIamRoles() != null) {
            sb.append("IamRoles: ").append(this.getIamRoles());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest)obj;
        if (other.getDBName() == null ^ this.getDBName() == null) {
            return false;
        }
        if (other.getDBName() != null && !other.getDBName().equals(this.getDBName())) {
            return false;
        }
        if (other.getClusterIdentifier() == null ^ this.getClusterIdentifier() == null) {
            return false;
        }
        if (other.getClusterIdentifier() != null && !other.getClusterIdentifier().equals(this.getClusterIdentifier())) {
            return false;
        }
        if (other.getClusterType() == null ^ this.getClusterType() == null) {
            return false;
        }
        if (other.getClusterType() != null && !other.getClusterType().equals(this.getClusterType())) {
            return false;
        }
        if (other.getNodeType() == null ^ this.getNodeType() == null) {
            return false;
        }
        if (other.getNodeType() != null && !other.getNodeType().equals(this.getNodeType())) {
            return false;
        }
        if (other.getMasterUsername() == null ^ this.getMasterUsername() == null) {
            return false;
        }
        if (other.getMasterUsername() != null && !other.getMasterUsername().equals(this.getMasterUsername())) {
            return false;
        }
        if (other.getMasterUserPassword() == null ^ this.getMasterUserPassword() == null) {
            return false;
        }
        if (other.getMasterUserPassword() != null && !other.getMasterUserPassword().equals(this.getMasterUserPassword())) {
            return false;
        }
        if (other.getClusterSecurityGroups() == null ^ this.getClusterSecurityGroups() == null) {
            return false;
        }
        if (other.getClusterSecurityGroups() != null && !other.getClusterSecurityGroups().equals(this.getClusterSecurityGroups())) {
            return false;
        }
        if (other.getVpcSecurityGroupIds() == null ^ this.getVpcSecurityGroupIds() == null) {
            return false;
        }
        if (other.getVpcSecurityGroupIds() != null && !other.getVpcSecurityGroupIds().equals(this.getVpcSecurityGroupIds())) {
            return false;
        }
        if (other.getClusterSubnetGroupName() == null ^ this.getClusterSubnetGroupName() == null) {
            return false;
        }
        if (other.getClusterSubnetGroupName() != null && !other.getClusterSubnetGroupName().equals(this.getClusterSubnetGroupName())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getClusterParameterGroupName() == null ^ this.getClusterParameterGroupName() == null) {
            return false;
        }
        if (other.getClusterParameterGroupName() != null && !other.getClusterParameterGroupName().equals(this.getClusterParameterGroupName())) {
            return false;
        }
        if (other.getAutomatedSnapshotRetentionPeriod() == null ^ this.getAutomatedSnapshotRetentionPeriod() == null) {
            return false;
        }
        if (other.getAutomatedSnapshotRetentionPeriod() != null && !other.getAutomatedSnapshotRetentionPeriod().equals(this.getAutomatedSnapshotRetentionPeriod())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getClusterVersion() == null ^ this.getClusterVersion() == null) {
            return false;
        }
        if (other.getClusterVersion() != null && !other.getClusterVersion().equals(this.getClusterVersion())) {
            return false;
        }
        if (other.getAllowVersionUpgrade() == null ^ this.getAllowVersionUpgrade() == null) {
            return false;
        }
        if (other.getAllowVersionUpgrade() != null && !other.getAllowVersionUpgrade().equals(this.getAllowVersionUpgrade())) {
            return false;
        }
        if (other.getNumberOfNodes() == null ^ this.getNumberOfNodes() == null) {
            return false;
        }
        if (other.getNumberOfNodes() != null && !other.getNumberOfNodes().equals(this.getNumberOfNodes())) {
            return false;
        }
        if (other.getPubliclyAccessible() == null ^ this.getPubliclyAccessible() == null) {
            return false;
        }
        if (other.getPubliclyAccessible() != null && !other.getPubliclyAccessible().equals(this.getPubliclyAccessible())) {
            return false;
        }
        if (other.getEncrypted() == null ^ this.getEncrypted() == null) {
            return false;
        }
        if (other.getEncrypted() != null && !other.getEncrypted().equals(this.getEncrypted())) {
            return false;
        }
        if (other.getHsmClientCertificateIdentifier() == null ^ this.getHsmClientCertificateIdentifier() == null) {
            return false;
        }
        if (other.getHsmClientCertificateIdentifier() != null && !other.getHsmClientCertificateIdentifier().equals(this.getHsmClientCertificateIdentifier())) {
            return false;
        }
        if (other.getHsmConfigurationIdentifier() == null ^ this.getHsmConfigurationIdentifier() == null) {
            return false;
        }
        if (other.getHsmConfigurationIdentifier() != null && !other.getHsmConfigurationIdentifier().equals(this.getHsmConfigurationIdentifier())) {
            return false;
        }
        if (other.getElasticIp() == null ^ this.getElasticIp() == null) {
            return false;
        }
        if (other.getElasticIp() != null && !other.getElasticIp().equals(this.getElasticIp())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getEnhancedVpcRouting() == null ^ this.getEnhancedVpcRouting() == null) {
            return false;
        }
        if (other.getEnhancedVpcRouting() != null && !other.getEnhancedVpcRouting().equals(this.getEnhancedVpcRouting())) {
            return false;
        }
        if (other.getAdditionalInfo() == null ^ this.getAdditionalInfo() == null) {
            return false;
        }
        if (other.getAdditionalInfo() != null && !other.getAdditionalInfo().equals(this.getAdditionalInfo())) {
            return false;
        }
        if (other.getIamRoles() == null ^ this.getIamRoles() == null) {
            return false;
        }
        return other.getIamRoles() == null || other.getIamRoles().equals(this.getIamRoles());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDBName() == null ? 0 : this.getDBName().hashCode());
        hashCode = 31 * hashCode + (this.getClusterIdentifier() == null ? 0 : this.getClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getClusterType() == null ? 0 : this.getClusterType().hashCode());
        hashCode = 31 * hashCode + (this.getNodeType() == null ? 0 : this.getNodeType().hashCode());
        hashCode = 31 * hashCode + (this.getMasterUsername() == null ? 0 : this.getMasterUsername().hashCode());
        hashCode = 31 * hashCode + (this.getMasterUserPassword() == null ? 0 : this.getMasterUserPassword().hashCode());
        hashCode = 31 * hashCode + (this.getClusterSecurityGroups() == null ? 0 : this.getClusterSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getVpcSecurityGroupIds() == null ? 0 : this.getVpcSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getClusterSubnetGroupName() == null ? 0 : this.getClusterSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getClusterParameterGroupName() == null ? 0 : this.getClusterParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getAutomatedSnapshotRetentionPeriod() == null ? 0 : this.getAutomatedSnapshotRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getClusterVersion() == null ? 0 : this.getClusterVersion().hashCode());
        hashCode = 31 * hashCode + (this.getAllowVersionUpgrade() == null ? 0 : this.getAllowVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfNodes() == null ? 0 : this.getNumberOfNodes().hashCode());
        hashCode = 31 * hashCode + (this.getPubliclyAccessible() == null ? 0 : this.getPubliclyAccessible().hashCode());
        hashCode = 31 * hashCode + (this.getEncrypted() == null ? 0 : this.getEncrypted().hashCode());
        hashCode = 31 * hashCode + (this.getHsmClientCertificateIdentifier() == null ? 0 : this.getHsmClientCertificateIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getHsmConfigurationIdentifier() == null ? 0 : this.getHsmConfigurationIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getElasticIp() == null ? 0 : this.getElasticIp().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getEnhancedVpcRouting() == null ? 0 : this.getEnhancedVpcRouting().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalInfo() == null ? 0 : this.getAdditionalInfo().hashCode());
        hashCode = 31 * hashCode + (this.getIamRoles() == null ? 0 : this.getIamRoles().hashCode());
        return hashCode;
    }

    public CreateClusterRequest clone() {
        return (CreateClusterRequest)super.clone();
    }
}

