/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.redshift.AmazonRedshiftAsync;
import com.amazonaws.services.redshift.AmazonRedshiftClient;
import com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest;
import com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest;
import com.amazonaws.services.redshift.model.Cluster;
import com.amazonaws.services.redshift.model.ClusterParameterGroup;
import com.amazonaws.services.redshift.model.ClusterSecurityGroup;
import com.amazonaws.services.redshift.model.ClusterSubnetGroup;
import com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest;
import com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest;
import com.amazonaws.services.redshift.model.CreateClusterRequest;
import com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest;
import com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest;
import com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest;
import com.amazonaws.services.redshift.model.CreateEventSubscriptionRequest;
import com.amazonaws.services.redshift.model.CreateHsmClientCertificateRequest;
import com.amazonaws.services.redshift.model.CreateHsmConfigurationRequest;
import com.amazonaws.services.redshift.model.CreateSnapshotCopyGrantRequest;
import com.amazonaws.services.redshift.model.CreateTagsRequest;
import com.amazonaws.services.redshift.model.CreateTagsResult;
import com.amazonaws.services.redshift.model.DefaultClusterParameters;
import com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest;
import com.amazonaws.services.redshift.model.DeleteClusterParameterGroupResult;
import com.amazonaws.services.redshift.model.DeleteClusterRequest;
import com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest;
import com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupResult;
import com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest;
import com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest;
import com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupResult;
import com.amazonaws.services.redshift.model.DeleteEventSubscriptionRequest;
import com.amazonaws.services.redshift.model.DeleteEventSubscriptionResult;
import com.amazonaws.services.redshift.model.DeleteHsmClientCertificateRequest;
import com.amazonaws.services.redshift.model.DeleteHsmClientCertificateResult;
import com.amazonaws.services.redshift.model.DeleteHsmConfigurationRequest;
import com.amazonaws.services.redshift.model.DeleteHsmConfigurationResult;
import com.amazonaws.services.redshift.model.DeleteSnapshotCopyGrantRequest;
import com.amazonaws.services.redshift.model.DeleteSnapshotCopyGrantResult;
import com.amazonaws.services.redshift.model.DeleteTagsRequest;
import com.amazonaws.services.redshift.model.DeleteTagsResult;
import com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsResult;
import com.amazonaws.services.redshift.model.DescribeClusterParametersRequest;
import com.amazonaws.services.redshift.model.DescribeClusterParametersResult;
import com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsResult;
import com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterSnapshotsResult;
import com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsResult;
import com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterVersionsResult;
import com.amazonaws.services.redshift.model.DescribeClustersRequest;
import com.amazonaws.services.redshift.model.DescribeClustersResult;
import com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest;
import com.amazonaws.services.redshift.model.DescribeEventCategoriesRequest;
import com.amazonaws.services.redshift.model.DescribeEventCategoriesResult;
import com.amazonaws.services.redshift.model.DescribeEventSubscriptionsRequest;
import com.amazonaws.services.redshift.model.DescribeEventSubscriptionsResult;
import com.amazonaws.services.redshift.model.DescribeEventsRequest;
import com.amazonaws.services.redshift.model.DescribeEventsResult;
import com.amazonaws.services.redshift.model.DescribeHsmClientCertificatesRequest;
import com.amazonaws.services.redshift.model.DescribeHsmClientCertificatesResult;
import com.amazonaws.services.redshift.model.DescribeHsmConfigurationsRequest;
import com.amazonaws.services.redshift.model.DescribeHsmConfigurationsResult;
import com.amazonaws.services.redshift.model.DescribeLoggingStatusRequest;
import com.amazonaws.services.redshift.model.DescribeLoggingStatusResult;
import com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest;
import com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsResult;
import com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest;
import com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsResult;
import com.amazonaws.services.redshift.model.DescribeReservedNodesRequest;
import com.amazonaws.services.redshift.model.DescribeReservedNodesResult;
import com.amazonaws.services.redshift.model.DescribeResizeRequest;
import com.amazonaws.services.redshift.model.DescribeResizeResult;
import com.amazonaws.services.redshift.model.DescribeSnapshotCopyGrantsRequest;
import com.amazonaws.services.redshift.model.DescribeSnapshotCopyGrantsResult;
import com.amazonaws.services.redshift.model.DescribeTableRestoreStatusRequest;
import com.amazonaws.services.redshift.model.DescribeTableRestoreStatusResult;
import com.amazonaws.services.redshift.model.DescribeTagsRequest;
import com.amazonaws.services.redshift.model.DescribeTagsResult;
import com.amazonaws.services.redshift.model.DisableLoggingRequest;
import com.amazonaws.services.redshift.model.DisableLoggingResult;
import com.amazonaws.services.redshift.model.DisableSnapshotCopyRequest;
import com.amazonaws.services.redshift.model.EnableLoggingRequest;
import com.amazonaws.services.redshift.model.EnableLoggingResult;
import com.amazonaws.services.redshift.model.EnableSnapshotCopyRequest;
import com.amazonaws.services.redshift.model.EventSubscription;
import com.amazonaws.services.redshift.model.HsmClientCertificate;
import com.amazonaws.services.redshift.model.HsmConfiguration;
import com.amazonaws.services.redshift.model.ModifyClusterIamRolesRequest;
import com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest;
import com.amazonaws.services.redshift.model.ModifyClusterParameterGroupResult;
import com.amazonaws.services.redshift.model.ModifyClusterRequest;
import com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest;
import com.amazonaws.services.redshift.model.ModifyEventSubscriptionRequest;
import com.amazonaws.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest;
import com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest;
import com.amazonaws.services.redshift.model.RebootClusterRequest;
import com.amazonaws.services.redshift.model.ReservedNode;
import com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest;
import com.amazonaws.services.redshift.model.ResetClusterParameterGroupResult;
import com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest;
import com.amazonaws.services.redshift.model.RestoreTableFromClusterSnapshotRequest;
import com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest;
import com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest;
import com.amazonaws.services.redshift.model.RotateEncryptionKeyRequest;
import com.amazonaws.services.redshift.model.Snapshot;
import com.amazonaws.services.redshift.model.SnapshotCopyGrant;
import com.amazonaws.services.redshift.model.TableRestoreStatus;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonRedshiftAsyncClient
extends AmazonRedshiftClient
implements AmazonRedshiftAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonRedshiftAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonRedshiftAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonRedshiftAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonRedshiftAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AmazonRedshiftAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonRedshiftAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonRedshiftAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonRedshiftAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AmazonRedshiftAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<ClusterSecurityGroup> authorizeClusterSecurityGroupIngressAsync(AuthorizeClusterSecurityGroupIngressRequest request) {
        return this.authorizeClusterSecurityGroupIngressAsync(request, null);
    }

    @Override
    public Future<ClusterSecurityGroup> authorizeClusterSecurityGroupIngressAsync(final AuthorizeClusterSecurityGroupIngressRequest request, final AsyncHandler<AuthorizeClusterSecurityGroupIngressRequest, ClusterSecurityGroup> asyncHandler) {
        return this.executorService.submit(new Callable<ClusterSecurityGroup>(){

            @Override
            public ClusterSecurityGroup call() throws Exception {
                ClusterSecurityGroup result;
                try {
                    result = AmazonRedshiftAsyncClient.this.authorizeClusterSecurityGroupIngress(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Snapshot> authorizeSnapshotAccessAsync(AuthorizeSnapshotAccessRequest request) {
        return this.authorizeSnapshotAccessAsync(request, null);
    }

    @Override
    public Future<Snapshot> authorizeSnapshotAccessAsync(final AuthorizeSnapshotAccessRequest request, final AsyncHandler<AuthorizeSnapshotAccessRequest, Snapshot> asyncHandler) {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                Snapshot result;
                try {
                    result = AmazonRedshiftAsyncClient.this.authorizeSnapshotAccess(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Snapshot> copyClusterSnapshotAsync(CopyClusterSnapshotRequest request) {
        return this.copyClusterSnapshotAsync(request, null);
    }

    @Override
    public Future<Snapshot> copyClusterSnapshotAsync(final CopyClusterSnapshotRequest request, final AsyncHandler<CopyClusterSnapshotRequest, Snapshot> asyncHandler) {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                Snapshot result;
                try {
                    result = AmazonRedshiftAsyncClient.this.copyClusterSnapshot(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Cluster> createClusterAsync(CreateClusterRequest request) {
        return this.createClusterAsync(request, null);
    }

    @Override
    public Future<Cluster> createClusterAsync(final CreateClusterRequest request, final AsyncHandler<CreateClusterRequest, Cluster> asyncHandler) {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createCluster(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ClusterParameterGroup> createClusterParameterGroupAsync(CreateClusterParameterGroupRequest request) {
        return this.createClusterParameterGroupAsync(request, null);
    }

    @Override
    public Future<ClusterParameterGroup> createClusterParameterGroupAsync(final CreateClusterParameterGroupRequest request, final AsyncHandler<CreateClusterParameterGroupRequest, ClusterParameterGroup> asyncHandler) {
        return this.executorService.submit(new Callable<ClusterParameterGroup>(){

            @Override
            public ClusterParameterGroup call() throws Exception {
                ClusterParameterGroup result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createClusterParameterGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ClusterSecurityGroup> createClusterSecurityGroupAsync(CreateClusterSecurityGroupRequest request) {
        return this.createClusterSecurityGroupAsync(request, null);
    }

    @Override
    public Future<ClusterSecurityGroup> createClusterSecurityGroupAsync(final CreateClusterSecurityGroupRequest request, final AsyncHandler<CreateClusterSecurityGroupRequest, ClusterSecurityGroup> asyncHandler) {
        return this.executorService.submit(new Callable<ClusterSecurityGroup>(){

            @Override
            public ClusterSecurityGroup call() throws Exception {
                ClusterSecurityGroup result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createClusterSecurityGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Snapshot> createClusterSnapshotAsync(CreateClusterSnapshotRequest request) {
        return this.createClusterSnapshotAsync(request, null);
    }

    @Override
    public Future<Snapshot> createClusterSnapshotAsync(final CreateClusterSnapshotRequest request, final AsyncHandler<CreateClusterSnapshotRequest, Snapshot> asyncHandler) {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                Snapshot result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createClusterSnapshot(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ClusterSubnetGroup> createClusterSubnetGroupAsync(CreateClusterSubnetGroupRequest request) {
        return this.createClusterSubnetGroupAsync(request, null);
    }

    @Override
    public Future<ClusterSubnetGroup> createClusterSubnetGroupAsync(final CreateClusterSubnetGroupRequest request, final AsyncHandler<CreateClusterSubnetGroupRequest, ClusterSubnetGroup> asyncHandler) {
        return this.executorService.submit(new Callable<ClusterSubnetGroup>(){

            @Override
            public ClusterSubnetGroup call() throws Exception {
                ClusterSubnetGroup result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createClusterSubnetGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EventSubscription> createEventSubscriptionAsync(CreateEventSubscriptionRequest request) {
        return this.createEventSubscriptionAsync(request, null);
    }

    @Override
    public Future<EventSubscription> createEventSubscriptionAsync(final CreateEventSubscriptionRequest request, final AsyncHandler<CreateEventSubscriptionRequest, EventSubscription> asyncHandler) {
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createEventSubscription(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<HsmClientCertificate> createHsmClientCertificateAsync(CreateHsmClientCertificateRequest request) {
        return this.createHsmClientCertificateAsync(request, null);
    }

    @Override
    public Future<HsmClientCertificate> createHsmClientCertificateAsync(final CreateHsmClientCertificateRequest request, final AsyncHandler<CreateHsmClientCertificateRequest, HsmClientCertificate> asyncHandler) {
        return this.executorService.submit(new Callable<HsmClientCertificate>(){

            @Override
            public HsmClientCertificate call() throws Exception {
                HsmClientCertificate result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createHsmClientCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<HsmConfiguration> createHsmConfigurationAsync(CreateHsmConfigurationRequest request) {
        return this.createHsmConfigurationAsync(request, null);
    }

    @Override
    public Future<HsmConfiguration> createHsmConfigurationAsync(final CreateHsmConfigurationRequest request, final AsyncHandler<CreateHsmConfigurationRequest, HsmConfiguration> asyncHandler) {
        return this.executorService.submit(new Callable<HsmConfiguration>(){

            @Override
            public HsmConfiguration call() throws Exception {
                HsmConfiguration result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createHsmConfiguration(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SnapshotCopyGrant> createSnapshotCopyGrantAsync(CreateSnapshotCopyGrantRequest request) {
        return this.createSnapshotCopyGrantAsync(request, null);
    }

    @Override
    public Future<SnapshotCopyGrant> createSnapshotCopyGrantAsync(final CreateSnapshotCopyGrantRequest request, final AsyncHandler<CreateSnapshotCopyGrantRequest, SnapshotCopyGrant> asyncHandler) {
        return this.executorService.submit(new Callable<SnapshotCopyGrant>(){

            @Override
            public SnapshotCopyGrant call() throws Exception {
                SnapshotCopyGrant result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createSnapshotCopyGrant(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTagsResult> createTagsAsync(CreateTagsRequest request) {
        return this.createTagsAsync(request, null);
    }

    @Override
    public Future<CreateTagsResult> createTagsAsync(final CreateTagsRequest request, final AsyncHandler<CreateTagsRequest, CreateTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateTagsResult>(){

            @Override
            public CreateTagsResult call() throws Exception {
                CreateTagsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.createTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Cluster> deleteClusterAsync(DeleteClusterRequest request) {
        return this.deleteClusterAsync(request, null);
    }

    @Override
    public Future<Cluster> deleteClusterAsync(final DeleteClusterRequest request, final AsyncHandler<DeleteClusterRequest, Cluster> asyncHandler) {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.deleteCluster(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteClusterParameterGroupResult> deleteClusterParameterGroupAsync(DeleteClusterParameterGroupRequest request) {
        return this.deleteClusterParameterGroupAsync(request, null);
    }

    @Override
    public Future<DeleteClusterParameterGroupResult> deleteClusterParameterGroupAsync(final DeleteClusterParameterGroupRequest request, final AsyncHandler<DeleteClusterParameterGroupRequest, DeleteClusterParameterGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteClusterParameterGroupResult>(){

            @Override
            public DeleteClusterParameterGroupResult call() throws Exception {
                DeleteClusterParameterGroupResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.deleteClusterParameterGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteClusterSecurityGroupResult> deleteClusterSecurityGroupAsync(DeleteClusterSecurityGroupRequest request) {
        return this.deleteClusterSecurityGroupAsync(request, null);
    }

    @Override
    public Future<DeleteClusterSecurityGroupResult> deleteClusterSecurityGroupAsync(final DeleteClusterSecurityGroupRequest request, final AsyncHandler<DeleteClusterSecurityGroupRequest, DeleteClusterSecurityGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteClusterSecurityGroupResult>(){

            @Override
            public DeleteClusterSecurityGroupResult call() throws Exception {
                DeleteClusterSecurityGroupResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.deleteClusterSecurityGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Snapshot> deleteClusterSnapshotAsync(DeleteClusterSnapshotRequest request) {
        return this.deleteClusterSnapshotAsync(request, null);
    }

    @Override
    public Future<Snapshot> deleteClusterSnapshotAsync(final DeleteClusterSnapshotRequest request, final AsyncHandler<DeleteClusterSnapshotRequest, Snapshot> asyncHandler) {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                Snapshot result;
                try {
                    result = AmazonRedshiftAsyncClient.this.deleteClusterSnapshot(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteClusterSubnetGroupResult> deleteClusterSubnetGroupAsync(DeleteClusterSubnetGroupRequest request) {
        return this.deleteClusterSubnetGroupAsync(request, null);
    }

    @Override
    public Future<DeleteClusterSubnetGroupResult> deleteClusterSubnetGroupAsync(final DeleteClusterSubnetGroupRequest request, final AsyncHandler<DeleteClusterSubnetGroupRequest, DeleteClusterSubnetGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteClusterSubnetGroupResult>(){

            @Override
            public DeleteClusterSubnetGroupResult call() throws Exception {
                DeleteClusterSubnetGroupResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.deleteClusterSubnetGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteEventSubscriptionResult> deleteEventSubscriptionAsync(DeleteEventSubscriptionRequest request) {
        return this.deleteEventSubscriptionAsync(request, null);
    }

    @Override
    public Future<DeleteEventSubscriptionResult> deleteEventSubscriptionAsync(final DeleteEventSubscriptionRequest request, final AsyncHandler<DeleteEventSubscriptionRequest, DeleteEventSubscriptionResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteEventSubscriptionResult>(){

            @Override
            public DeleteEventSubscriptionResult call() throws Exception {
                DeleteEventSubscriptionResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.deleteEventSubscription(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteHsmClientCertificateResult> deleteHsmClientCertificateAsync(DeleteHsmClientCertificateRequest request) {
        return this.deleteHsmClientCertificateAsync(request, null);
    }

    @Override
    public Future<DeleteHsmClientCertificateResult> deleteHsmClientCertificateAsync(final DeleteHsmClientCertificateRequest request, final AsyncHandler<DeleteHsmClientCertificateRequest, DeleteHsmClientCertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteHsmClientCertificateResult>(){

            @Override
            public DeleteHsmClientCertificateResult call() throws Exception {
                DeleteHsmClientCertificateResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.deleteHsmClientCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteHsmConfigurationResult> deleteHsmConfigurationAsync(DeleteHsmConfigurationRequest request) {
        return this.deleteHsmConfigurationAsync(request, null);
    }

    @Override
    public Future<DeleteHsmConfigurationResult> deleteHsmConfigurationAsync(final DeleteHsmConfigurationRequest request, final AsyncHandler<DeleteHsmConfigurationRequest, DeleteHsmConfigurationResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteHsmConfigurationResult>(){

            @Override
            public DeleteHsmConfigurationResult call() throws Exception {
                DeleteHsmConfigurationResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.deleteHsmConfiguration(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSnapshotCopyGrantResult> deleteSnapshotCopyGrantAsync(DeleteSnapshotCopyGrantRequest request) {
        return this.deleteSnapshotCopyGrantAsync(request, null);
    }

    @Override
    public Future<DeleteSnapshotCopyGrantResult> deleteSnapshotCopyGrantAsync(final DeleteSnapshotCopyGrantRequest request, final AsyncHandler<DeleteSnapshotCopyGrantRequest, DeleteSnapshotCopyGrantResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteSnapshotCopyGrantResult>(){

            @Override
            public DeleteSnapshotCopyGrantResult call() throws Exception {
                DeleteSnapshotCopyGrantResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.deleteSnapshotCopyGrant(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTagsResult> deleteTagsAsync(DeleteTagsRequest request) {
        return this.deleteTagsAsync(request, null);
    }

    @Override
    public Future<DeleteTagsResult> deleteTagsAsync(final DeleteTagsRequest request, final AsyncHandler<DeleteTagsRequest, DeleteTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteTagsResult>(){

            @Override
            public DeleteTagsResult call() throws Exception {
                DeleteTagsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.deleteTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterParameterGroupsResult> describeClusterParameterGroupsAsync(DescribeClusterParameterGroupsRequest request) {
        return this.describeClusterParameterGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeClusterParameterGroupsResult> describeClusterParameterGroupsAsync(final DescribeClusterParameterGroupsRequest request, final AsyncHandler<DescribeClusterParameterGroupsRequest, DescribeClusterParameterGroupsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeClusterParameterGroupsResult>(){

            @Override
            public DescribeClusterParameterGroupsResult call() throws Exception {
                DescribeClusterParameterGroupsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeClusterParameterGroups(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterParameterGroupsResult> describeClusterParameterGroupsAsync() {
        return this.describeClusterParameterGroupsAsync(new DescribeClusterParameterGroupsRequest());
    }

    @Override
    public Future<DescribeClusterParameterGroupsResult> describeClusterParameterGroupsAsync(AsyncHandler<DescribeClusterParameterGroupsRequest, DescribeClusterParameterGroupsResult> asyncHandler) {
        return this.describeClusterParameterGroupsAsync(new DescribeClusterParameterGroupsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeClusterParametersResult> describeClusterParametersAsync(DescribeClusterParametersRequest request) {
        return this.describeClusterParametersAsync(request, null);
    }

    @Override
    public Future<DescribeClusterParametersResult> describeClusterParametersAsync(final DescribeClusterParametersRequest request, final AsyncHandler<DescribeClusterParametersRequest, DescribeClusterParametersResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeClusterParametersResult>(){

            @Override
            public DescribeClusterParametersResult call() throws Exception {
                DescribeClusterParametersResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeClusterParameters(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterSecurityGroupsResult> describeClusterSecurityGroupsAsync(DescribeClusterSecurityGroupsRequest request) {
        return this.describeClusterSecurityGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeClusterSecurityGroupsResult> describeClusterSecurityGroupsAsync(final DescribeClusterSecurityGroupsRequest request, final AsyncHandler<DescribeClusterSecurityGroupsRequest, DescribeClusterSecurityGroupsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeClusterSecurityGroupsResult>(){

            @Override
            public DescribeClusterSecurityGroupsResult call() throws Exception {
                DescribeClusterSecurityGroupsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeClusterSecurityGroups(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterSecurityGroupsResult> describeClusterSecurityGroupsAsync() {
        return this.describeClusterSecurityGroupsAsync(new DescribeClusterSecurityGroupsRequest());
    }

    @Override
    public Future<DescribeClusterSecurityGroupsResult> describeClusterSecurityGroupsAsync(AsyncHandler<DescribeClusterSecurityGroupsRequest, DescribeClusterSecurityGroupsResult> asyncHandler) {
        return this.describeClusterSecurityGroupsAsync(new DescribeClusterSecurityGroupsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeClusterSnapshotsResult> describeClusterSnapshotsAsync(DescribeClusterSnapshotsRequest request) {
        return this.describeClusterSnapshotsAsync(request, null);
    }

    @Override
    public Future<DescribeClusterSnapshotsResult> describeClusterSnapshotsAsync(final DescribeClusterSnapshotsRequest request, final AsyncHandler<DescribeClusterSnapshotsRequest, DescribeClusterSnapshotsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeClusterSnapshotsResult>(){

            @Override
            public DescribeClusterSnapshotsResult call() throws Exception {
                DescribeClusterSnapshotsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeClusterSnapshots(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterSnapshotsResult> describeClusterSnapshotsAsync() {
        return this.describeClusterSnapshotsAsync(new DescribeClusterSnapshotsRequest());
    }

    @Override
    public Future<DescribeClusterSnapshotsResult> describeClusterSnapshotsAsync(AsyncHandler<DescribeClusterSnapshotsRequest, DescribeClusterSnapshotsResult> asyncHandler) {
        return this.describeClusterSnapshotsAsync(new DescribeClusterSnapshotsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeClusterSubnetGroupsResult> describeClusterSubnetGroupsAsync(DescribeClusterSubnetGroupsRequest request) {
        return this.describeClusterSubnetGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeClusterSubnetGroupsResult> describeClusterSubnetGroupsAsync(final DescribeClusterSubnetGroupsRequest request, final AsyncHandler<DescribeClusterSubnetGroupsRequest, DescribeClusterSubnetGroupsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeClusterSubnetGroupsResult>(){

            @Override
            public DescribeClusterSubnetGroupsResult call() throws Exception {
                DescribeClusterSubnetGroupsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeClusterSubnetGroups(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterSubnetGroupsResult> describeClusterSubnetGroupsAsync() {
        return this.describeClusterSubnetGroupsAsync(new DescribeClusterSubnetGroupsRequest());
    }

    @Override
    public Future<DescribeClusterSubnetGroupsResult> describeClusterSubnetGroupsAsync(AsyncHandler<DescribeClusterSubnetGroupsRequest, DescribeClusterSubnetGroupsResult> asyncHandler) {
        return this.describeClusterSubnetGroupsAsync(new DescribeClusterSubnetGroupsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeClusterVersionsResult> describeClusterVersionsAsync(DescribeClusterVersionsRequest request) {
        return this.describeClusterVersionsAsync(request, null);
    }

    @Override
    public Future<DescribeClusterVersionsResult> describeClusterVersionsAsync(final DescribeClusterVersionsRequest request, final AsyncHandler<DescribeClusterVersionsRequest, DescribeClusterVersionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeClusterVersionsResult>(){

            @Override
            public DescribeClusterVersionsResult call() throws Exception {
                DescribeClusterVersionsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeClusterVersions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterVersionsResult> describeClusterVersionsAsync() {
        return this.describeClusterVersionsAsync(new DescribeClusterVersionsRequest());
    }

    @Override
    public Future<DescribeClusterVersionsResult> describeClusterVersionsAsync(AsyncHandler<DescribeClusterVersionsRequest, DescribeClusterVersionsResult> asyncHandler) {
        return this.describeClusterVersionsAsync(new DescribeClusterVersionsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync(DescribeClustersRequest request) {
        return this.describeClustersAsync(request, null);
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync(final DescribeClustersRequest request, final AsyncHandler<DescribeClustersRequest, DescribeClustersResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeClustersResult>(){

            @Override
            public DescribeClustersResult call() throws Exception {
                DescribeClustersResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeClusters(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync() {
        return this.describeClustersAsync(new DescribeClustersRequest());
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync(AsyncHandler<DescribeClustersRequest, DescribeClustersResult> asyncHandler) {
        return this.describeClustersAsync(new DescribeClustersRequest(), asyncHandler);
    }

    @Override
    public Future<DefaultClusterParameters> describeDefaultClusterParametersAsync(DescribeDefaultClusterParametersRequest request) {
        return this.describeDefaultClusterParametersAsync(request, null);
    }

    @Override
    public Future<DefaultClusterParameters> describeDefaultClusterParametersAsync(final DescribeDefaultClusterParametersRequest request, final AsyncHandler<DescribeDefaultClusterParametersRequest, DefaultClusterParameters> asyncHandler) {
        return this.executorService.submit(new Callable<DefaultClusterParameters>(){

            @Override
            public DefaultClusterParameters call() throws Exception {
                DefaultClusterParameters result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeDefaultClusterParameters(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventCategoriesResult> describeEventCategoriesAsync(DescribeEventCategoriesRequest request) {
        return this.describeEventCategoriesAsync(request, null);
    }

    @Override
    public Future<DescribeEventCategoriesResult> describeEventCategoriesAsync(final DescribeEventCategoriesRequest request, final AsyncHandler<DescribeEventCategoriesRequest, DescribeEventCategoriesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeEventCategoriesResult>(){

            @Override
            public DescribeEventCategoriesResult call() throws Exception {
                DescribeEventCategoriesResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeEventCategories(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventCategoriesResult> describeEventCategoriesAsync() {
        return this.describeEventCategoriesAsync(new DescribeEventCategoriesRequest());
    }

    @Override
    public Future<DescribeEventCategoriesResult> describeEventCategoriesAsync(AsyncHandler<DescribeEventCategoriesRequest, DescribeEventCategoriesResult> asyncHandler) {
        return this.describeEventCategoriesAsync(new DescribeEventCategoriesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeEventSubscriptionsResult> describeEventSubscriptionsAsync(DescribeEventSubscriptionsRequest request) {
        return this.describeEventSubscriptionsAsync(request, null);
    }

    @Override
    public Future<DescribeEventSubscriptionsResult> describeEventSubscriptionsAsync(final DescribeEventSubscriptionsRequest request, final AsyncHandler<DescribeEventSubscriptionsRequest, DescribeEventSubscriptionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeEventSubscriptionsResult>(){

            @Override
            public DescribeEventSubscriptionsResult call() throws Exception {
                DescribeEventSubscriptionsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeEventSubscriptions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventSubscriptionsResult> describeEventSubscriptionsAsync() {
        return this.describeEventSubscriptionsAsync(new DescribeEventSubscriptionsRequest());
    }

    @Override
    public Future<DescribeEventSubscriptionsResult> describeEventSubscriptionsAsync(AsyncHandler<DescribeEventSubscriptionsRequest, DescribeEventSubscriptionsResult> asyncHandler) {
        return this.describeEventSubscriptionsAsync(new DescribeEventSubscriptionsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(DescribeEventsRequest request) {
        return this.describeEventsAsync(request, null);
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(final DescribeEventsRequest request, final AsyncHandler<DescribeEventsRequest, DescribeEventsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                DescribeEventsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeEvents(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync() {
        return this.describeEventsAsync(new DescribeEventsRequest());
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(AsyncHandler<DescribeEventsRequest, DescribeEventsResult> asyncHandler) {
        return this.describeEventsAsync(new DescribeEventsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeHsmClientCertificatesResult> describeHsmClientCertificatesAsync(DescribeHsmClientCertificatesRequest request) {
        return this.describeHsmClientCertificatesAsync(request, null);
    }

    @Override
    public Future<DescribeHsmClientCertificatesResult> describeHsmClientCertificatesAsync(final DescribeHsmClientCertificatesRequest request, final AsyncHandler<DescribeHsmClientCertificatesRequest, DescribeHsmClientCertificatesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeHsmClientCertificatesResult>(){

            @Override
            public DescribeHsmClientCertificatesResult call() throws Exception {
                DescribeHsmClientCertificatesResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeHsmClientCertificates(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeHsmClientCertificatesResult> describeHsmClientCertificatesAsync() {
        return this.describeHsmClientCertificatesAsync(new DescribeHsmClientCertificatesRequest());
    }

    @Override
    public Future<DescribeHsmClientCertificatesResult> describeHsmClientCertificatesAsync(AsyncHandler<DescribeHsmClientCertificatesRequest, DescribeHsmClientCertificatesResult> asyncHandler) {
        return this.describeHsmClientCertificatesAsync(new DescribeHsmClientCertificatesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeHsmConfigurationsResult> describeHsmConfigurationsAsync(DescribeHsmConfigurationsRequest request) {
        return this.describeHsmConfigurationsAsync(request, null);
    }

    @Override
    public Future<DescribeHsmConfigurationsResult> describeHsmConfigurationsAsync(final DescribeHsmConfigurationsRequest request, final AsyncHandler<DescribeHsmConfigurationsRequest, DescribeHsmConfigurationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeHsmConfigurationsResult>(){

            @Override
            public DescribeHsmConfigurationsResult call() throws Exception {
                DescribeHsmConfigurationsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeHsmConfigurations(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeHsmConfigurationsResult> describeHsmConfigurationsAsync() {
        return this.describeHsmConfigurationsAsync(new DescribeHsmConfigurationsRequest());
    }

    @Override
    public Future<DescribeHsmConfigurationsResult> describeHsmConfigurationsAsync(AsyncHandler<DescribeHsmConfigurationsRequest, DescribeHsmConfigurationsResult> asyncHandler) {
        return this.describeHsmConfigurationsAsync(new DescribeHsmConfigurationsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeLoggingStatusResult> describeLoggingStatusAsync(DescribeLoggingStatusRequest request) {
        return this.describeLoggingStatusAsync(request, null);
    }

    @Override
    public Future<DescribeLoggingStatusResult> describeLoggingStatusAsync(final DescribeLoggingStatusRequest request, final AsyncHandler<DescribeLoggingStatusRequest, DescribeLoggingStatusResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeLoggingStatusResult>(){

            @Override
            public DescribeLoggingStatusResult call() throws Exception {
                DescribeLoggingStatusResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeLoggingStatus(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeOrderableClusterOptionsResult> describeOrderableClusterOptionsAsync(DescribeOrderableClusterOptionsRequest request) {
        return this.describeOrderableClusterOptionsAsync(request, null);
    }

    @Override
    public Future<DescribeOrderableClusterOptionsResult> describeOrderableClusterOptionsAsync(final DescribeOrderableClusterOptionsRequest request, final AsyncHandler<DescribeOrderableClusterOptionsRequest, DescribeOrderableClusterOptionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeOrderableClusterOptionsResult>(){

            @Override
            public DescribeOrderableClusterOptionsResult call() throws Exception {
                DescribeOrderableClusterOptionsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeOrderableClusterOptions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeOrderableClusterOptionsResult> describeOrderableClusterOptionsAsync() {
        return this.describeOrderableClusterOptionsAsync(new DescribeOrderableClusterOptionsRequest());
    }

    @Override
    public Future<DescribeOrderableClusterOptionsResult> describeOrderableClusterOptionsAsync(AsyncHandler<DescribeOrderableClusterOptionsRequest, DescribeOrderableClusterOptionsResult> asyncHandler) {
        return this.describeOrderableClusterOptionsAsync(new DescribeOrderableClusterOptionsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeReservedNodeOfferingsResult> describeReservedNodeOfferingsAsync(DescribeReservedNodeOfferingsRequest request) {
        return this.describeReservedNodeOfferingsAsync(request, null);
    }

    @Override
    public Future<DescribeReservedNodeOfferingsResult> describeReservedNodeOfferingsAsync(final DescribeReservedNodeOfferingsRequest request, final AsyncHandler<DescribeReservedNodeOfferingsRequest, DescribeReservedNodeOfferingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeReservedNodeOfferingsResult>(){

            @Override
            public DescribeReservedNodeOfferingsResult call() throws Exception {
                DescribeReservedNodeOfferingsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeReservedNodeOfferings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedNodeOfferingsResult> describeReservedNodeOfferingsAsync() {
        return this.describeReservedNodeOfferingsAsync(new DescribeReservedNodeOfferingsRequest());
    }

    @Override
    public Future<DescribeReservedNodeOfferingsResult> describeReservedNodeOfferingsAsync(AsyncHandler<DescribeReservedNodeOfferingsRequest, DescribeReservedNodeOfferingsResult> asyncHandler) {
        return this.describeReservedNodeOfferingsAsync(new DescribeReservedNodeOfferingsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeReservedNodesResult> describeReservedNodesAsync(DescribeReservedNodesRequest request) {
        return this.describeReservedNodesAsync(request, null);
    }

    @Override
    public Future<DescribeReservedNodesResult> describeReservedNodesAsync(final DescribeReservedNodesRequest request, final AsyncHandler<DescribeReservedNodesRequest, DescribeReservedNodesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeReservedNodesResult>(){

            @Override
            public DescribeReservedNodesResult call() throws Exception {
                DescribeReservedNodesResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeReservedNodes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedNodesResult> describeReservedNodesAsync() {
        return this.describeReservedNodesAsync(new DescribeReservedNodesRequest());
    }

    @Override
    public Future<DescribeReservedNodesResult> describeReservedNodesAsync(AsyncHandler<DescribeReservedNodesRequest, DescribeReservedNodesResult> asyncHandler) {
        return this.describeReservedNodesAsync(new DescribeReservedNodesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeResizeResult> describeResizeAsync(DescribeResizeRequest request) {
        return this.describeResizeAsync(request, null);
    }

    @Override
    public Future<DescribeResizeResult> describeResizeAsync(final DescribeResizeRequest request, final AsyncHandler<DescribeResizeRequest, DescribeResizeResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeResizeResult>(){

            @Override
            public DescribeResizeResult call() throws Exception {
                DescribeResizeResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeResize(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSnapshotCopyGrantsResult> describeSnapshotCopyGrantsAsync(DescribeSnapshotCopyGrantsRequest request) {
        return this.describeSnapshotCopyGrantsAsync(request, null);
    }

    @Override
    public Future<DescribeSnapshotCopyGrantsResult> describeSnapshotCopyGrantsAsync(final DescribeSnapshotCopyGrantsRequest request, final AsyncHandler<DescribeSnapshotCopyGrantsRequest, DescribeSnapshotCopyGrantsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeSnapshotCopyGrantsResult>(){

            @Override
            public DescribeSnapshotCopyGrantsResult call() throws Exception {
                DescribeSnapshotCopyGrantsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeSnapshotCopyGrants(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSnapshotCopyGrantsResult> describeSnapshotCopyGrantsAsync() {
        return this.describeSnapshotCopyGrantsAsync(new DescribeSnapshotCopyGrantsRequest());
    }

    @Override
    public Future<DescribeSnapshotCopyGrantsResult> describeSnapshotCopyGrantsAsync(AsyncHandler<DescribeSnapshotCopyGrantsRequest, DescribeSnapshotCopyGrantsResult> asyncHandler) {
        return this.describeSnapshotCopyGrantsAsync(new DescribeSnapshotCopyGrantsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeTableRestoreStatusResult> describeTableRestoreStatusAsync(DescribeTableRestoreStatusRequest request) {
        return this.describeTableRestoreStatusAsync(request, null);
    }

    @Override
    public Future<DescribeTableRestoreStatusResult> describeTableRestoreStatusAsync(final DescribeTableRestoreStatusRequest request, final AsyncHandler<DescribeTableRestoreStatusRequest, DescribeTableRestoreStatusResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeTableRestoreStatusResult>(){

            @Override
            public DescribeTableRestoreStatusResult call() throws Exception {
                DescribeTableRestoreStatusResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeTableRestoreStatus(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTableRestoreStatusResult> describeTableRestoreStatusAsync() {
        return this.describeTableRestoreStatusAsync(new DescribeTableRestoreStatusRequest());
    }

    @Override
    public Future<DescribeTableRestoreStatusResult> describeTableRestoreStatusAsync(AsyncHandler<DescribeTableRestoreStatusRequest, DescribeTableRestoreStatusResult> asyncHandler) {
        return this.describeTableRestoreStatusAsync(new DescribeTableRestoreStatusRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(DescribeTagsRequest request) {
        return this.describeTagsAsync(request, null);
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(final DescribeTagsRequest request, final AsyncHandler<DescribeTagsRequest, DescribeTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() throws Exception {
                DescribeTagsResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.describeTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync() {
        return this.describeTagsAsync(new DescribeTagsRequest());
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(AsyncHandler<DescribeTagsRequest, DescribeTagsResult> asyncHandler) {
        return this.describeTagsAsync(new DescribeTagsRequest(), asyncHandler);
    }

    @Override
    public Future<DisableLoggingResult> disableLoggingAsync(DisableLoggingRequest request) {
        return this.disableLoggingAsync(request, null);
    }

    @Override
    public Future<DisableLoggingResult> disableLoggingAsync(final DisableLoggingRequest request, final AsyncHandler<DisableLoggingRequest, DisableLoggingResult> asyncHandler) {
        return this.executorService.submit(new Callable<DisableLoggingResult>(){

            @Override
            public DisableLoggingResult call() throws Exception {
                DisableLoggingResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.disableLogging(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Cluster> disableSnapshotCopyAsync(DisableSnapshotCopyRequest request) {
        return this.disableSnapshotCopyAsync(request, null);
    }

    @Override
    public Future<Cluster> disableSnapshotCopyAsync(final DisableSnapshotCopyRequest request, final AsyncHandler<DisableSnapshotCopyRequest, Cluster> asyncHandler) {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.disableSnapshotCopy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableLoggingResult> enableLoggingAsync(EnableLoggingRequest request) {
        return this.enableLoggingAsync(request, null);
    }

    @Override
    public Future<EnableLoggingResult> enableLoggingAsync(final EnableLoggingRequest request, final AsyncHandler<EnableLoggingRequest, EnableLoggingResult> asyncHandler) {
        return this.executorService.submit(new Callable<EnableLoggingResult>(){

            @Override
            public EnableLoggingResult call() throws Exception {
                EnableLoggingResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.enableLogging(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Cluster> enableSnapshotCopyAsync(EnableSnapshotCopyRequest request) {
        return this.enableSnapshotCopyAsync(request, null);
    }

    @Override
    public Future<Cluster> enableSnapshotCopyAsync(final EnableSnapshotCopyRequest request, final AsyncHandler<EnableSnapshotCopyRequest, Cluster> asyncHandler) {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.enableSnapshotCopy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Cluster> modifyClusterAsync(ModifyClusterRequest request) {
        return this.modifyClusterAsync(request, null);
    }

    @Override
    public Future<Cluster> modifyClusterAsync(final ModifyClusterRequest request, final AsyncHandler<ModifyClusterRequest, Cluster> asyncHandler) {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.modifyCluster(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Cluster> modifyClusterIamRolesAsync(ModifyClusterIamRolesRequest request) {
        return this.modifyClusterIamRolesAsync(request, null);
    }

    @Override
    public Future<Cluster> modifyClusterIamRolesAsync(final ModifyClusterIamRolesRequest request, final AsyncHandler<ModifyClusterIamRolesRequest, Cluster> asyncHandler) {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.modifyClusterIamRoles(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ModifyClusterParameterGroupResult> modifyClusterParameterGroupAsync(ModifyClusterParameterGroupRequest request) {
        return this.modifyClusterParameterGroupAsync(request, null);
    }

    @Override
    public Future<ModifyClusterParameterGroupResult> modifyClusterParameterGroupAsync(final ModifyClusterParameterGroupRequest request, final AsyncHandler<ModifyClusterParameterGroupRequest, ModifyClusterParameterGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<ModifyClusterParameterGroupResult>(){

            @Override
            public ModifyClusterParameterGroupResult call() throws Exception {
                ModifyClusterParameterGroupResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.modifyClusterParameterGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ClusterSubnetGroup> modifyClusterSubnetGroupAsync(ModifyClusterSubnetGroupRequest request) {
        return this.modifyClusterSubnetGroupAsync(request, null);
    }

    @Override
    public Future<ClusterSubnetGroup> modifyClusterSubnetGroupAsync(final ModifyClusterSubnetGroupRequest request, final AsyncHandler<ModifyClusterSubnetGroupRequest, ClusterSubnetGroup> asyncHandler) {
        return this.executorService.submit(new Callable<ClusterSubnetGroup>(){

            @Override
            public ClusterSubnetGroup call() throws Exception {
                ClusterSubnetGroup result;
                try {
                    result = AmazonRedshiftAsyncClient.this.modifyClusterSubnetGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EventSubscription> modifyEventSubscriptionAsync(ModifyEventSubscriptionRequest request) {
        return this.modifyEventSubscriptionAsync(request, null);
    }

    @Override
    public Future<EventSubscription> modifyEventSubscriptionAsync(final ModifyEventSubscriptionRequest request, final AsyncHandler<ModifyEventSubscriptionRequest, EventSubscription> asyncHandler) {
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result;
                try {
                    result = AmazonRedshiftAsyncClient.this.modifyEventSubscription(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Cluster> modifySnapshotCopyRetentionPeriodAsync(ModifySnapshotCopyRetentionPeriodRequest request) {
        return this.modifySnapshotCopyRetentionPeriodAsync(request, null);
    }

    @Override
    public Future<Cluster> modifySnapshotCopyRetentionPeriodAsync(final ModifySnapshotCopyRetentionPeriodRequest request, final AsyncHandler<ModifySnapshotCopyRetentionPeriodRequest, Cluster> asyncHandler) {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.modifySnapshotCopyRetentionPeriod(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReservedNode> purchaseReservedNodeOfferingAsync(PurchaseReservedNodeOfferingRequest request) {
        return this.purchaseReservedNodeOfferingAsync(request, null);
    }

    @Override
    public Future<ReservedNode> purchaseReservedNodeOfferingAsync(final PurchaseReservedNodeOfferingRequest request, final AsyncHandler<PurchaseReservedNodeOfferingRequest, ReservedNode> asyncHandler) {
        return this.executorService.submit(new Callable<ReservedNode>(){

            @Override
            public ReservedNode call() throws Exception {
                ReservedNode result;
                try {
                    result = AmazonRedshiftAsyncClient.this.purchaseReservedNodeOffering(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Cluster> rebootClusterAsync(RebootClusterRequest request) {
        return this.rebootClusterAsync(request, null);
    }

    @Override
    public Future<Cluster> rebootClusterAsync(final RebootClusterRequest request, final AsyncHandler<RebootClusterRequest, Cluster> asyncHandler) {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.rebootCluster(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResetClusterParameterGroupResult> resetClusterParameterGroupAsync(ResetClusterParameterGroupRequest request) {
        return this.resetClusterParameterGroupAsync(request, null);
    }

    @Override
    public Future<ResetClusterParameterGroupResult> resetClusterParameterGroupAsync(final ResetClusterParameterGroupRequest request, final AsyncHandler<ResetClusterParameterGroupRequest, ResetClusterParameterGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<ResetClusterParameterGroupResult>(){

            @Override
            public ResetClusterParameterGroupResult call() throws Exception {
                ResetClusterParameterGroupResult result;
                try {
                    result = AmazonRedshiftAsyncClient.this.resetClusterParameterGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Cluster> restoreFromClusterSnapshotAsync(RestoreFromClusterSnapshotRequest request) {
        return this.restoreFromClusterSnapshotAsync(request, null);
    }

    @Override
    public Future<Cluster> restoreFromClusterSnapshotAsync(final RestoreFromClusterSnapshotRequest request, final AsyncHandler<RestoreFromClusterSnapshotRequest, Cluster> asyncHandler) {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.restoreFromClusterSnapshot(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TableRestoreStatus> restoreTableFromClusterSnapshotAsync(RestoreTableFromClusterSnapshotRequest request) {
        return this.restoreTableFromClusterSnapshotAsync(request, null);
    }

    @Override
    public Future<TableRestoreStatus> restoreTableFromClusterSnapshotAsync(final RestoreTableFromClusterSnapshotRequest request, final AsyncHandler<RestoreTableFromClusterSnapshotRequest, TableRestoreStatus> asyncHandler) {
        return this.executorService.submit(new Callable<TableRestoreStatus>(){

            @Override
            public TableRestoreStatus call() throws Exception {
                TableRestoreStatus result;
                try {
                    result = AmazonRedshiftAsyncClient.this.restoreTableFromClusterSnapshot(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ClusterSecurityGroup> revokeClusterSecurityGroupIngressAsync(RevokeClusterSecurityGroupIngressRequest request) {
        return this.revokeClusterSecurityGroupIngressAsync(request, null);
    }

    @Override
    public Future<ClusterSecurityGroup> revokeClusterSecurityGroupIngressAsync(final RevokeClusterSecurityGroupIngressRequest request, final AsyncHandler<RevokeClusterSecurityGroupIngressRequest, ClusterSecurityGroup> asyncHandler) {
        return this.executorService.submit(new Callable<ClusterSecurityGroup>(){

            @Override
            public ClusterSecurityGroup call() throws Exception {
                ClusterSecurityGroup result;
                try {
                    result = AmazonRedshiftAsyncClient.this.revokeClusterSecurityGroupIngress(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Snapshot> revokeSnapshotAccessAsync(RevokeSnapshotAccessRequest request) {
        return this.revokeSnapshotAccessAsync(request, null);
    }

    @Override
    public Future<Snapshot> revokeSnapshotAccessAsync(final RevokeSnapshotAccessRequest request, final AsyncHandler<RevokeSnapshotAccessRequest, Snapshot> asyncHandler) {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                Snapshot result;
                try {
                    result = AmazonRedshiftAsyncClient.this.revokeSnapshotAccess(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Cluster> rotateEncryptionKeyAsync(RotateEncryptionKeyRequest request) {
        return this.rotateEncryptionKeyAsync(request, null);
    }

    @Override
    public Future<Cluster> rotateEncryptionKeyAsync(final RotateEncryptionKeyRequest request, final AsyncHandler<RotateEncryptionKeyRequest, Cluster> asyncHandler) {
        return this.executorService.submit(new Callable<Cluster>(){

            @Override
            public Cluster call() throws Exception {
                Cluster result;
                try {
                    result = AmazonRedshiftAsyncClient.this.rotateEncryptionKey(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

