/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.recyclebin.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.recyclebin.model.ResourceTag;
import com.amazonaws.services.recyclebin.model.ResourceType;
import com.amazonaws.services.recyclebin.model.RetentionPeriod;
import com.amazonaws.services.recyclebin.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateRuleRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private RetentionPeriod retentionPeriod;
    private String description;
    private List<Tag> tags;
    private String resourceType;
    private List<ResourceTag> resourceTags;

    public void setRetentionPeriod(RetentionPeriod retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    public RetentionPeriod getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public CreateRuleRequest withRetentionPeriod(RetentionPeriod retentionPeriod) {
        this.setRetentionPeriod(retentionPeriod);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateRuleRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateRuleRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateRuleRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public CreateRuleRequest withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public CreateRuleRequest withResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public List<ResourceTag> getResourceTags() {
        return this.resourceTags;
    }

    public void setResourceTags(Collection<ResourceTag> resourceTags) {
        if (resourceTags == null) {
            this.resourceTags = null;
            return;
        }
        this.resourceTags = new ArrayList<ResourceTag>(resourceTags);
    }

    public CreateRuleRequest withResourceTags(ResourceTag ... resourceTags) {
        if (this.resourceTags == null) {
            this.setResourceTags(new ArrayList<ResourceTag>(resourceTags.length));
        }
        for (ResourceTag ele : resourceTags) {
            this.resourceTags.add(ele);
        }
        return this;
    }

    public CreateRuleRequest withResourceTags(Collection<ResourceTag> resourceTags) {
        this.setResourceTags(resourceTags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRetentionPeriod() != null) {
            sb.append("RetentionPeriod: ").append(this.getRetentionPeriod()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getResourceTags() != null) {
            sb.append("ResourceTags: ").append(this.getResourceTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleRequest)) {
            return false;
        }
        CreateRuleRequest other = (CreateRuleRequest)obj;
        if (other.getRetentionPeriod() == null ^ this.getRetentionPeriod() == null) {
            return false;
        }
        if (other.getRetentionPeriod() != null && !other.getRetentionPeriod().equals(this.getRetentionPeriod())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getResourceTags() == null ^ this.getResourceTags() == null) {
            return false;
        }
        return other.getResourceTags() == null || other.getResourceTags().equals(this.getResourceTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRetentionPeriod() == null ? 0 : this.getRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTags() == null ? 0 : this.getResourceTags().hashCode());
        return hashCode;
    }

    public CreateRuleRequest clone() {
        return (CreateRuleRequest)super.clone();
    }
}

