/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.rds.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * A logical grouping of Performance Insights metrics for a related subject area. For example, the <code>db.sql</code>
 * dimension group consists of the following dimensions:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>db.sql.id</code> - The hash of a running SQL statement, generated by Performance Insights.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>db.sql.db_id</code> - Either the SQL ID generated by the database engine, or a value generated by Performance
 * Insights that begins with <code>pi-</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>db.sql.statement</code> - The full text of the SQL statement that is running, for example,
 * <code>SELECT * FROM employees</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>db.sql_tokenized.id</code> - The hash of the SQL digest generated by Performance Insights.
 * </p>
 * </li>
 * </ul>
 * <note>
 * <p>
 * Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements, only the first 500
 * bytes are returned.
 * </p>
 * </note>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PerformanceInsightsMetricDimensionGroup"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PerformanceInsightsMetricDimensionGroup implements Serializable, Cloneable {

    /**
     * <p>
     * A list of specific dimensions from a dimension group. If this list isn't included, then all of the dimensions in
     * the group were requested, or are present in the response.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<String> dimensions;
    /**
     * <p>
     * The available dimension groups for Performance Insights metric type.
     * </p>
     */
    private String group;
    /**
     * <p>
     * The maximum number of items to fetch for this dimension group.
     * </p>
     */
    private Integer limit;

    /**
     * <p>
     * A list of specific dimensions from a dimension group. If this list isn't included, then all of the dimensions in
     * the group were requested, or are present in the response.
     * </p>
     * 
     * @return A list of specific dimensions from a dimension group. If this list isn't included, then all of the
     *         dimensions in the group were requested, or are present in the response.
     */

    public java.util.List<String> getDimensions() {
        if (dimensions == null) {
            dimensions = new com.amazonaws.internal.SdkInternalList<String>();
        }
        return dimensions;
    }

    /**
     * <p>
     * A list of specific dimensions from a dimension group. If this list isn't included, then all of the dimensions in
     * the group were requested, or are present in the response.
     * </p>
     * 
     * @param dimensions
     *        A list of specific dimensions from a dimension group. If this list isn't included, then all of the
     *        dimensions in the group were requested, or are present in the response.
     */

    public void setDimensions(java.util.Collection<String> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }

        this.dimensions = new com.amazonaws.internal.SdkInternalList<String>(dimensions);
    }

    /**
     * <p>
     * A list of specific dimensions from a dimension group. If this list isn't included, then all of the dimensions in
     * the group were requested, or are present in the response.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setDimensions(java.util.Collection)} or {@link #withDimensions(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param dimensions
     *        A list of specific dimensions from a dimension group. If this list isn't included, then all of the
     *        dimensions in the group were requested, or are present in the response.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PerformanceInsightsMetricDimensionGroup withDimensions(String... dimensions) {
        if (this.dimensions == null) {
            setDimensions(new com.amazonaws.internal.SdkInternalList<String>(dimensions.length));
        }
        for (String ele : dimensions) {
            this.dimensions.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of specific dimensions from a dimension group. If this list isn't included, then all of the dimensions in
     * the group were requested, or are present in the response.
     * </p>
     * 
     * @param dimensions
     *        A list of specific dimensions from a dimension group. If this list isn't included, then all of the
     *        dimensions in the group were requested, or are present in the response.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PerformanceInsightsMetricDimensionGroup withDimensions(java.util.Collection<String> dimensions) {
        setDimensions(dimensions);
        return this;
    }

    /**
     * <p>
     * The available dimension groups for Performance Insights metric type.
     * </p>
     * 
     * @param group
     *        The available dimension groups for Performance Insights metric type.
     */

    public void setGroup(String group) {
        this.group = group;
    }

    /**
     * <p>
     * The available dimension groups for Performance Insights metric type.
     * </p>
     * 
     * @return The available dimension groups for Performance Insights metric type.
     */

    public String getGroup() {
        return this.group;
    }

    /**
     * <p>
     * The available dimension groups for Performance Insights metric type.
     * </p>
     * 
     * @param group
     *        The available dimension groups for Performance Insights metric type.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PerformanceInsightsMetricDimensionGroup withGroup(String group) {
        setGroup(group);
        return this;
    }

    /**
     * <p>
     * The maximum number of items to fetch for this dimension group.
     * </p>
     * 
     * @param limit
     *        The maximum number of items to fetch for this dimension group.
     */

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    /**
     * <p>
     * The maximum number of items to fetch for this dimension group.
     * </p>
     * 
     * @return The maximum number of items to fetch for this dimension group.
     */

    public Integer getLimit() {
        return this.limit;
    }

    /**
     * <p>
     * The maximum number of items to fetch for this dimension group.
     * </p>
     * 
     * @param limit
     *        The maximum number of items to fetch for this dimension group.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PerformanceInsightsMetricDimensionGroup withLimit(Integer limit) {
        setLimit(limit);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDimensions() != null)
            sb.append("Dimensions: ").append(getDimensions()).append(",");
        if (getGroup() != null)
            sb.append("Group: ").append(getGroup()).append(",");
        if (getLimit() != null)
            sb.append("Limit: ").append(getLimit());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof PerformanceInsightsMetricDimensionGroup == false)
            return false;
        PerformanceInsightsMetricDimensionGroup other = (PerformanceInsightsMetricDimensionGroup) obj;
        if (other.getDimensions() == null ^ this.getDimensions() == null)
            return false;
        if (other.getDimensions() != null && other.getDimensions().equals(this.getDimensions()) == false)
            return false;
        if (other.getGroup() == null ^ this.getGroup() == null)
            return false;
        if (other.getGroup() != null && other.getGroup().equals(this.getGroup()) == false)
            return false;
        if (other.getLimit() == null ^ this.getLimit() == null)
            return false;
        if (other.getLimit() != null && other.getLimit().equals(this.getLimit()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDimensions() == null) ? 0 : getDimensions().hashCode());
        hashCode = prime * hashCode + ((getGroup() == null) ? 0 : getGroup().hashCode());
        hashCode = prime * hashCode + ((getLimit() == null) ? 0 : getLimit().hashCode());
        return hashCode;
    }

    @Override
    public PerformanceInsightsMetricDimensionGroup clone() {
        try {
            return (PerformanceInsightsMetricDimensionGroup) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
