/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.CreateBlueGreenDeploymentRequest;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateBlueGreenDeploymentRequestMarshaller
implements Marshaller<Request<CreateBlueGreenDeploymentRequest>, CreateBlueGreenDeploymentRequest> {
    public Request<CreateBlueGreenDeploymentRequest> marshall(CreateBlueGreenDeploymentRequest createBlueGreenDeploymentRequest) {
        if (createBlueGreenDeploymentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createBlueGreenDeploymentRequest, "AmazonRDS");
        request.addParameter("Action", "CreateBlueGreenDeployment");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createBlueGreenDeploymentRequest.getBlueGreenDeploymentName() != null) {
            request.addParameter("BlueGreenDeploymentName", StringUtils.fromString((String)createBlueGreenDeploymentRequest.getBlueGreenDeploymentName()));
        }
        if (createBlueGreenDeploymentRequest.getSource() != null) {
            request.addParameter("Source", StringUtils.fromString((String)createBlueGreenDeploymentRequest.getSource()));
        }
        if (createBlueGreenDeploymentRequest.getTargetEngineVersion() != null) {
            request.addParameter("TargetEngineVersion", StringUtils.fromString((String)createBlueGreenDeploymentRequest.getTargetEngineVersion()));
        }
        if (createBlueGreenDeploymentRequest.getTargetDBParameterGroupName() != null) {
            request.addParameter("TargetDBParameterGroupName", StringUtils.fromString((String)createBlueGreenDeploymentRequest.getTargetDBParameterGroupName()));
        }
        if (createBlueGreenDeploymentRequest.getTargetDBClusterParameterGroupName() != null) {
            request.addParameter("TargetDBClusterParameterGroupName", StringUtils.fromString((String)createBlueGreenDeploymentRequest.getTargetDBClusterParameterGroupName()));
        }
        if (!createBlueGreenDeploymentRequest.getTags().isEmpty() || !((SdkInternalList)createBlueGreenDeploymentRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createBlueGreenDeploymentRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

