/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DescribeOrderableDBInstanceOptionsRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeOrderableDBInstanceOptionsRequestMarshaller
implements Marshaller<Request<DescribeOrderableDBInstanceOptionsRequest>, DescribeOrderableDBInstanceOptionsRequest> {
    public Request<DescribeOrderableDBInstanceOptionsRequest> marshall(DescribeOrderableDBInstanceOptionsRequest describeOrderableDBInstanceOptionsRequest) {
        SdkInternalList filtersList;
        if (describeOrderableDBInstanceOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeOrderableDBInstanceOptionsRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeOrderableDBInstanceOptions");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeOrderableDBInstanceOptionsRequest.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)describeOrderableDBInstanceOptionsRequest.getEngine()));
        }
        if (describeOrderableDBInstanceOptionsRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)describeOrderableDBInstanceOptionsRequest.getEngineVersion()));
        }
        if (describeOrderableDBInstanceOptionsRequest.getDBInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringUtils.fromString((String)describeOrderableDBInstanceOptionsRequest.getDBInstanceClass()));
        }
        if (describeOrderableDBInstanceOptionsRequest.getLicenseModel() != null) {
            request.addParameter("LicenseModel", StringUtils.fromString((String)describeOrderableDBInstanceOptionsRequest.getLicenseModel()));
        }
        if (describeOrderableDBInstanceOptionsRequest.getVpc() != null) {
            request.addParameter("Vpc", StringUtils.fromBoolean((Boolean)describeOrderableDBInstanceOptionsRequest.getVpc()));
        }
        if (!(filtersList = (SdkInternalList)describeOrderableDBInstanceOptionsRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeOrderableDBInstanceOptionsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeOrderableDBInstanceOptionsRequest.getMaxRecords()));
        }
        if (describeOrderableDBInstanceOptionsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeOrderableDBInstanceOptionsRequest.getMarker()));
        }
        return request;
    }
}

