/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ram.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ram.model.ResourceOwner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListPrincipalsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String resourceOwner;
    private String resourceArn;
    private List<String> principals;
    private String resourceType;
    private List<String> resourceShareArns;
    private String nextToken;
    private Integer maxResults;

    public void setResourceOwner(String resourceOwner) {
        this.resourceOwner = resourceOwner;
    }

    public String getResourceOwner() {
        return this.resourceOwner;
    }

    public ListPrincipalsRequest withResourceOwner(String resourceOwner) {
        this.setResourceOwner(resourceOwner);
        return this;
    }

    public ListPrincipalsRequest withResourceOwner(ResourceOwner resourceOwner) {
        this.resourceOwner = resourceOwner.toString();
        return this;
    }

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public ListPrincipalsRequest withResourceArn(String resourceArn) {
        this.setResourceArn(resourceArn);
        return this;
    }

    public List<String> getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(Collection<String> principals) {
        if (principals == null) {
            this.principals = null;
            return;
        }
        this.principals = new ArrayList<String>(principals);
    }

    public ListPrincipalsRequest withPrincipals(String ... principals) {
        if (this.principals == null) {
            this.setPrincipals(new ArrayList<String>(principals.length));
        }
        for (String ele : principals) {
            this.principals.add(ele);
        }
        return this;
    }

    public ListPrincipalsRequest withPrincipals(Collection<String> principals) {
        this.setPrincipals(principals);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public ListPrincipalsRequest withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public List<String> getResourceShareArns() {
        return this.resourceShareArns;
    }

    public void setResourceShareArns(Collection<String> resourceShareArns) {
        if (resourceShareArns == null) {
            this.resourceShareArns = null;
            return;
        }
        this.resourceShareArns = new ArrayList<String>(resourceShareArns);
    }

    public ListPrincipalsRequest withResourceShareArns(String ... resourceShareArns) {
        if (this.resourceShareArns == null) {
            this.setResourceShareArns(new ArrayList<String>(resourceShareArns.length));
        }
        for (String ele : resourceShareArns) {
            this.resourceShareArns.add(ele);
        }
        return this;
    }

    public ListPrincipalsRequest withResourceShareArns(Collection<String> resourceShareArns) {
        this.setResourceShareArns(resourceShareArns);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListPrincipalsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListPrincipalsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceOwner() != null) {
            sb.append("ResourceOwner: ").append(this.getResourceOwner()).append(",");
        }
        if (this.getResourceArn() != null) {
            sb.append("ResourceArn: ").append(this.getResourceArn()).append(",");
        }
        if (this.getPrincipals() != null) {
            sb.append("Principals: ").append(this.getPrincipals()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getResourceShareArns() != null) {
            sb.append("ResourceShareArns: ").append(this.getResourceShareArns()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPrincipalsRequest)) {
            return false;
        }
        ListPrincipalsRequest other = (ListPrincipalsRequest)obj;
        if (other.getResourceOwner() == null ^ this.getResourceOwner() == null) {
            return false;
        }
        if (other.getResourceOwner() != null && !other.getResourceOwner().equals(this.getResourceOwner())) {
            return false;
        }
        if (other.getResourceArn() == null ^ this.getResourceArn() == null) {
            return false;
        }
        if (other.getResourceArn() != null && !other.getResourceArn().equals(this.getResourceArn())) {
            return false;
        }
        if (other.getPrincipals() == null ^ this.getPrincipals() == null) {
            return false;
        }
        if (other.getPrincipals() != null && !other.getPrincipals().equals(this.getPrincipals())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getResourceShareArns() == null ^ this.getResourceShareArns() == null) {
            return false;
        }
        if (other.getResourceShareArns() != null && !other.getResourceShareArns().equals(this.getResourceShareArns())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceOwner() == null ? 0 : this.getResourceOwner().hashCode());
        hashCode = 31 * hashCode + (this.getResourceArn() == null ? 0 : this.getResourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getPrincipals() == null ? 0 : this.getPrincipals().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getResourceShareArns() == null ? 0 : this.getResourceShareArns().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    public ListPrincipalsRequest clone() {
        return (ListPrincipalsRequest)super.clone();
    }
}

