/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ram;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.ram.AWSRAM;
import com.amazonaws.services.ram.AWSRAMClientBuilder;
import com.amazonaws.services.ram.model.AWSRAMException;
import com.amazonaws.services.ram.model.AcceptResourceShareInvitationRequest;
import com.amazonaws.services.ram.model.AcceptResourceShareInvitationResult;
import com.amazonaws.services.ram.model.AssociateResourceShareRequest;
import com.amazonaws.services.ram.model.AssociateResourceShareResult;
import com.amazonaws.services.ram.model.CreateResourceShareRequest;
import com.amazonaws.services.ram.model.CreateResourceShareResult;
import com.amazonaws.services.ram.model.DeleteResourceShareRequest;
import com.amazonaws.services.ram.model.DeleteResourceShareResult;
import com.amazonaws.services.ram.model.DisassociateResourceShareRequest;
import com.amazonaws.services.ram.model.DisassociateResourceShareResult;
import com.amazonaws.services.ram.model.EnableSharingWithAwsOrganizationRequest;
import com.amazonaws.services.ram.model.EnableSharingWithAwsOrganizationResult;
import com.amazonaws.services.ram.model.GetResourcePoliciesRequest;
import com.amazonaws.services.ram.model.GetResourcePoliciesResult;
import com.amazonaws.services.ram.model.GetResourceShareAssociationsRequest;
import com.amazonaws.services.ram.model.GetResourceShareAssociationsResult;
import com.amazonaws.services.ram.model.GetResourceShareInvitationsRequest;
import com.amazonaws.services.ram.model.GetResourceShareInvitationsResult;
import com.amazonaws.services.ram.model.GetResourceSharesRequest;
import com.amazonaws.services.ram.model.GetResourceSharesResult;
import com.amazonaws.services.ram.model.IdempotentParameterMismatchException;
import com.amazonaws.services.ram.model.InvalidClientTokenException;
import com.amazonaws.services.ram.model.InvalidMaxResultsException;
import com.amazonaws.services.ram.model.InvalidNextTokenException;
import com.amazonaws.services.ram.model.InvalidParameterException;
import com.amazonaws.services.ram.model.InvalidResourceTypeException;
import com.amazonaws.services.ram.model.InvalidStateTransitionException;
import com.amazonaws.services.ram.model.ListPrincipalsRequest;
import com.amazonaws.services.ram.model.ListPrincipalsResult;
import com.amazonaws.services.ram.model.ListResourcesRequest;
import com.amazonaws.services.ram.model.ListResourcesResult;
import com.amazonaws.services.ram.model.MalformedArnException;
import com.amazonaws.services.ram.model.MissingRequiredParameterException;
import com.amazonaws.services.ram.model.OperationNotPermittedException;
import com.amazonaws.services.ram.model.RejectResourceShareInvitationRequest;
import com.amazonaws.services.ram.model.RejectResourceShareInvitationResult;
import com.amazonaws.services.ram.model.ResourceArnNotFoundException;
import com.amazonaws.services.ram.model.ResourceShareInvitationAlreadyAcceptedException;
import com.amazonaws.services.ram.model.ResourceShareInvitationAlreadyRejectedException;
import com.amazonaws.services.ram.model.ResourceShareInvitationArnNotFoundException;
import com.amazonaws.services.ram.model.ResourceShareInvitationExpiredException;
import com.amazonaws.services.ram.model.ResourceShareLimitExceededException;
import com.amazonaws.services.ram.model.ServerInternalException;
import com.amazonaws.services.ram.model.ServiceUnavailableException;
import com.amazonaws.services.ram.model.TagLimitExceededException;
import com.amazonaws.services.ram.model.TagResourceRequest;
import com.amazonaws.services.ram.model.TagResourceResult;
import com.amazonaws.services.ram.model.UnknownResourceException;
import com.amazonaws.services.ram.model.UntagResourceRequest;
import com.amazonaws.services.ram.model.UntagResourceResult;
import com.amazonaws.services.ram.model.UpdateResourceShareRequest;
import com.amazonaws.services.ram.model.UpdateResourceShareResult;
import com.amazonaws.services.ram.model.transform.AcceptResourceShareInvitationRequestProtocolMarshaller;
import com.amazonaws.services.ram.model.transform.AcceptResourceShareInvitationResultJsonUnmarshaller;
import com.amazonaws.services.ram.model.transform.AssociateResourceShareRequestProtocolMarshaller;
import com.amazonaws.services.ram.model.transform.AssociateResourceShareResultJsonUnmarshaller;
import com.amazonaws.services.ram.model.transform.CreateResourceShareRequestProtocolMarshaller;
import com.amazonaws.services.ram.model.transform.CreateResourceShareResultJsonUnmarshaller;
import com.amazonaws.services.ram.model.transform.DeleteResourceShareRequestProtocolMarshaller;
import com.amazonaws.services.ram.model.transform.DeleteResourceShareResultJsonUnmarshaller;
import com.amazonaws.services.ram.model.transform.DisassociateResourceShareRequestProtocolMarshaller;
import com.amazonaws.services.ram.model.transform.DisassociateResourceShareResultJsonUnmarshaller;
import com.amazonaws.services.ram.model.transform.EnableSharingWithAwsOrganizationRequestProtocolMarshaller;
import com.amazonaws.services.ram.model.transform.EnableSharingWithAwsOrganizationResultJsonUnmarshaller;
import com.amazonaws.services.ram.model.transform.GetResourcePoliciesRequestProtocolMarshaller;
import com.amazonaws.services.ram.model.transform.GetResourcePoliciesResultJsonUnmarshaller;
import com.amazonaws.services.ram.model.transform.GetResourceShareAssociationsRequestProtocolMarshaller;
import com.amazonaws.services.ram.model.transform.GetResourceShareAssociationsResultJsonUnmarshaller;
import com.amazonaws.services.ram.model.transform.GetResourceShareInvitationsRequestProtocolMarshaller;
import com.amazonaws.services.ram.model.transform.GetResourceShareInvitationsResultJsonUnmarshaller;
import com.amazonaws.services.ram.model.transform.GetResourceSharesRequestProtocolMarshaller;
import com.amazonaws.services.ram.model.transform.GetResourceSharesResultJsonUnmarshaller;
import com.amazonaws.services.ram.model.transform.ListPrincipalsRequestProtocolMarshaller;
import com.amazonaws.services.ram.model.transform.ListPrincipalsResultJsonUnmarshaller;
import com.amazonaws.services.ram.model.transform.ListResourcesRequestProtocolMarshaller;
import com.amazonaws.services.ram.model.transform.ListResourcesResultJsonUnmarshaller;
import com.amazonaws.services.ram.model.transform.RejectResourceShareInvitationRequestProtocolMarshaller;
import com.amazonaws.services.ram.model.transform.RejectResourceShareInvitationResultJsonUnmarshaller;
import com.amazonaws.services.ram.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.ram.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.ram.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.ram.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.ram.model.transform.UpdateResourceShareRequestProtocolMarshaller;
import com.amazonaws.services.ram.model.transform.UpdateResourceShareResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSRAMClient
extends AmazonWebServiceClient
implements AWSRAM {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSRAM.class);
    private static final String DEFAULT_SIGNING_NAME = "ram";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidClientTokenException").withModeledClass(InvalidClientTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnknownResourceException").withModeledClass(UnknownResourceException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServerInternalException").withModeledClass(ServerInternalException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IdempotentParameterMismatchException").withModeledClass(IdempotentParameterMismatchException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidMaxResultsException").withModeledClass(InvalidMaxResultsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidResourceTypeException").withModeledClass(InvalidResourceTypeException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withModeledClass(ServiceUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceShareInvitationExpiredException").withModeledClass(ResourceShareInvitationExpiredException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MissingRequiredParameterException").withModeledClass(MissingRequiredParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TagLimitExceededException").withModeledClass(TagLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceArnNotFoundException").withModeledClass(ResourceArnNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OperationNotPermittedException").withModeledClass(OperationNotPermittedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceShareLimitExceededException").withModeledClass(ResourceShareLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceShareInvitationAlreadyRejectedException").withModeledClass(ResourceShareInvitationAlreadyRejectedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MalformedArnException").withModeledClass(MalformedArnException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidStateTransitionException").withModeledClass(InvalidStateTransitionException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceShareInvitationAlreadyAcceptedException").withModeledClass(ResourceShareInvitationAlreadyAcceptedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceShareInvitationArnNotFoundException").withModeledClass(ResourceShareInvitationArnNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).withBaseServiceExceptionClass(AWSRAMException.class));

    public static AWSRAMClientBuilder builder() {
        return AWSRAMClientBuilder.standard();
    }

    AWSRAMClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSRAMClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("ram.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/ram/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/ram/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AcceptResourceShareInvitationResult acceptResourceShareInvitation(AcceptResourceShareInvitationRequest request) {
        request = (AcceptResourceShareInvitationRequest)this.beforeClientExecution(request);
        return this.executeAcceptResourceShareInvitation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AcceptResourceShareInvitationResult executeAcceptResourceShareInvitation(AcceptResourceShareInvitationRequest acceptResourceShareInvitationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(acceptResourceShareInvitationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AcceptResourceShareInvitationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AcceptResourceShareInvitationRequestProtocolMarshaller(protocolFactory).marshall((AcceptResourceShareInvitationRequest)super.beforeMarshalling((AmazonWebServiceRequest)acceptResourceShareInvitationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AcceptResourceShareInvitation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AcceptResourceShareInvitationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AcceptResourceShareInvitationResult acceptResourceShareInvitationResult = (AcceptResourceShareInvitationResult)response.getAwsResponse();
            return acceptResourceShareInvitationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AssociateResourceShareResult associateResourceShare(AssociateResourceShareRequest request) {
        request = (AssociateResourceShareRequest)this.beforeClientExecution(request);
        return this.executeAssociateResourceShare(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateResourceShareResult executeAssociateResourceShare(AssociateResourceShareRequest associateResourceShareRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateResourceShareRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateResourceShareRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateResourceShareRequestProtocolMarshaller(protocolFactory).marshall((AssociateResourceShareRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateResourceShareRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AssociateResourceShare");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateResourceShareResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateResourceShareResult associateResourceShareResult = (AssociateResourceShareResult)response.getAwsResponse();
            return associateResourceShareResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateResourceShareResult createResourceShare(CreateResourceShareRequest request) {
        request = (CreateResourceShareRequest)this.beforeClientExecution(request);
        return this.executeCreateResourceShare(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateResourceShareResult executeCreateResourceShare(CreateResourceShareRequest createResourceShareRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createResourceShareRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateResourceShareRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateResourceShareRequestProtocolMarshaller(protocolFactory).marshall((CreateResourceShareRequest)super.beforeMarshalling((AmazonWebServiceRequest)createResourceShareRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateResourceShare");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateResourceShareResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateResourceShareResult createResourceShareResult = (CreateResourceShareResult)response.getAwsResponse();
            return createResourceShareResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteResourceShareResult deleteResourceShare(DeleteResourceShareRequest request) {
        request = (DeleteResourceShareRequest)this.beforeClientExecution(request);
        return this.executeDeleteResourceShare(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteResourceShareResult executeDeleteResourceShare(DeleteResourceShareRequest deleteResourceShareRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteResourceShareRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteResourceShareRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteResourceShareRequestProtocolMarshaller(protocolFactory).marshall((DeleteResourceShareRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteResourceShareRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteResourceShare");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteResourceShareResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteResourceShareResult deleteResourceShareResult = (DeleteResourceShareResult)response.getAwsResponse();
            return deleteResourceShareResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateResourceShareResult disassociateResourceShare(DisassociateResourceShareRequest request) {
        request = (DisassociateResourceShareRequest)this.beforeClientExecution(request);
        return this.executeDisassociateResourceShare(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateResourceShareResult executeDisassociateResourceShare(DisassociateResourceShareRequest disassociateResourceShareRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateResourceShareRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateResourceShareRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateResourceShareRequestProtocolMarshaller(protocolFactory).marshall((DisassociateResourceShareRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateResourceShareRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateResourceShare");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateResourceShareResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateResourceShareResult disassociateResourceShareResult = (DisassociateResourceShareResult)response.getAwsResponse();
            return disassociateResourceShareResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public EnableSharingWithAwsOrganizationResult enableSharingWithAwsOrganization(EnableSharingWithAwsOrganizationRequest request) {
        request = (EnableSharingWithAwsOrganizationRequest)this.beforeClientExecution(request);
        return this.executeEnableSharingWithAwsOrganization(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final EnableSharingWithAwsOrganizationResult executeEnableSharingWithAwsOrganization(EnableSharingWithAwsOrganizationRequest enableSharingWithAwsOrganizationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableSharingWithAwsOrganizationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableSharingWithAwsOrganizationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableSharingWithAwsOrganizationRequestProtocolMarshaller(protocolFactory).marshall((EnableSharingWithAwsOrganizationRequest)super.beforeMarshalling((AmazonWebServiceRequest)enableSharingWithAwsOrganizationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"EnableSharingWithAwsOrganization");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EnableSharingWithAwsOrganizationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            EnableSharingWithAwsOrganizationResult enableSharingWithAwsOrganizationResult = (EnableSharingWithAwsOrganizationResult)response.getAwsResponse();
            return enableSharingWithAwsOrganizationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetResourcePoliciesResult getResourcePolicies(GetResourcePoliciesRequest request) {
        request = (GetResourcePoliciesRequest)this.beforeClientExecution(request);
        return this.executeGetResourcePolicies(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetResourcePoliciesResult executeGetResourcePolicies(GetResourcePoliciesRequest getResourcePoliciesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getResourcePoliciesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetResourcePoliciesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetResourcePoliciesRequestProtocolMarshaller(protocolFactory).marshall((GetResourcePoliciesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getResourcePoliciesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetResourcePolicies");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetResourcePoliciesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetResourcePoliciesResult getResourcePoliciesResult = (GetResourcePoliciesResult)response.getAwsResponse();
            return getResourcePoliciesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetResourceShareAssociationsResult getResourceShareAssociations(GetResourceShareAssociationsRequest request) {
        request = (GetResourceShareAssociationsRequest)this.beforeClientExecution(request);
        return this.executeGetResourceShareAssociations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetResourceShareAssociationsResult executeGetResourceShareAssociations(GetResourceShareAssociationsRequest getResourceShareAssociationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getResourceShareAssociationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetResourceShareAssociationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetResourceShareAssociationsRequestProtocolMarshaller(protocolFactory).marshall((GetResourceShareAssociationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getResourceShareAssociationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetResourceShareAssociations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetResourceShareAssociationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetResourceShareAssociationsResult getResourceShareAssociationsResult = (GetResourceShareAssociationsResult)response.getAwsResponse();
            return getResourceShareAssociationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetResourceShareInvitationsResult getResourceShareInvitations(GetResourceShareInvitationsRequest request) {
        request = (GetResourceShareInvitationsRequest)this.beforeClientExecution(request);
        return this.executeGetResourceShareInvitations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetResourceShareInvitationsResult executeGetResourceShareInvitations(GetResourceShareInvitationsRequest getResourceShareInvitationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getResourceShareInvitationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetResourceShareInvitationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetResourceShareInvitationsRequestProtocolMarshaller(protocolFactory).marshall((GetResourceShareInvitationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getResourceShareInvitationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetResourceShareInvitations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetResourceShareInvitationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetResourceShareInvitationsResult getResourceShareInvitationsResult = (GetResourceShareInvitationsResult)response.getAwsResponse();
            return getResourceShareInvitationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetResourceSharesResult getResourceShares(GetResourceSharesRequest request) {
        request = (GetResourceSharesRequest)this.beforeClientExecution(request);
        return this.executeGetResourceShares(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetResourceSharesResult executeGetResourceShares(GetResourceSharesRequest getResourceSharesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getResourceSharesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetResourceSharesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetResourceSharesRequestProtocolMarshaller(protocolFactory).marshall((GetResourceSharesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getResourceSharesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetResourceShares");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetResourceSharesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetResourceSharesResult getResourceSharesResult = (GetResourceSharesResult)response.getAwsResponse();
            return getResourceSharesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPrincipalsResult listPrincipals(ListPrincipalsRequest request) {
        request = (ListPrincipalsRequest)this.beforeClientExecution(request);
        return this.executeListPrincipals(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPrincipalsResult executeListPrincipals(ListPrincipalsRequest listPrincipalsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPrincipalsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPrincipalsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPrincipalsRequestProtocolMarshaller(protocolFactory).marshall((ListPrincipalsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPrincipalsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPrincipals");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPrincipalsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPrincipalsResult listPrincipalsResult = (ListPrincipalsResult)response.getAwsResponse();
            return listPrincipalsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListResourcesResult listResources(ListResourcesRequest request) {
        request = (ListResourcesRequest)this.beforeClientExecution(request);
        return this.executeListResources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListResourcesResult executeListResources(ListResourcesRequest listResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListResourcesRequestProtocolMarshaller(protocolFactory).marshall((ListResourcesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListResources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListResourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListResourcesResult listResourcesResult = (ListResourcesResult)response.getAwsResponse();
            return listResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RejectResourceShareInvitationResult rejectResourceShareInvitation(RejectResourceShareInvitationRequest request) {
        request = (RejectResourceShareInvitationRequest)this.beforeClientExecution(request);
        return this.executeRejectResourceShareInvitation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RejectResourceShareInvitationResult executeRejectResourceShareInvitation(RejectResourceShareInvitationRequest rejectResourceShareInvitationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(rejectResourceShareInvitationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RejectResourceShareInvitationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RejectResourceShareInvitationRequestProtocolMarshaller(protocolFactory).marshall((RejectResourceShareInvitationRequest)super.beforeMarshalling((AmazonWebServiceRequest)rejectResourceShareInvitationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RejectResourceShareInvitation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RejectResourceShareInvitationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RejectResourceShareInvitationResult rejectResourceShareInvitationResult = (RejectResourceShareInvitationResult)response.getAwsResponse();
            return rejectResourceShareInvitationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateResourceShareResult updateResourceShare(UpdateResourceShareRequest request) {
        request = (UpdateResourceShareRequest)this.beforeClientExecution(request);
        return this.executeUpdateResourceShare(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateResourceShareResult executeUpdateResourceShare(UpdateResourceShareRequest updateResourceShareRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateResourceShareRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateResourceShareRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateResourceShareRequestProtocolMarshaller(protocolFactory).marshall((UpdateResourceShareRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateResourceShareRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RAM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateResourceShare");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateResourceShareResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateResourceShareResult updateResourceShareResult = (UpdateResourceShareResult)response.getAwsResponse();
            return updateResourceShareResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

