/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.quicksight.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The exclude period of <code>TimeRangeFilter</code> or <code>RelativeDatesFilter</code>.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ExcludePeriodConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ExcludePeriodConfiguration implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The amount or number of the exclude period.
     * </p>
     */
    private Integer amount;
    /**
     * <p>
     * The granularity or unit (day, month, year) of the exclude period.
     * </p>
     */
    private String granularity;
    /**
     * <p>
     * The status of the exclude period. Choose from the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code>
     * </p>
     * </li>
     * </ul>
     */
    private String status;

    /**
     * <p>
     * The amount or number of the exclude period.
     * </p>
     * 
     * @param amount
     *        The amount or number of the exclude period.
     */

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    /**
     * <p>
     * The amount or number of the exclude period.
     * </p>
     * 
     * @return The amount or number of the exclude period.
     */

    public Integer getAmount() {
        return this.amount;
    }

    /**
     * <p>
     * The amount or number of the exclude period.
     * </p>
     * 
     * @param amount
     *        The amount or number of the exclude period.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ExcludePeriodConfiguration withAmount(Integer amount) {
        setAmount(amount);
        return this;
    }

    /**
     * <p>
     * The granularity or unit (day, month, year) of the exclude period.
     * </p>
     * 
     * @param granularity
     *        The granularity or unit (day, month, year) of the exclude period.
     * @see TimeGranularity
     */

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    /**
     * <p>
     * The granularity or unit (day, month, year) of the exclude period.
     * </p>
     * 
     * @return The granularity or unit (day, month, year) of the exclude period.
     * @see TimeGranularity
     */

    public String getGranularity() {
        return this.granularity;
    }

    /**
     * <p>
     * The granularity or unit (day, month, year) of the exclude period.
     * </p>
     * 
     * @param granularity
     *        The granularity or unit (day, month, year) of the exclude period.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TimeGranularity
     */

    public ExcludePeriodConfiguration withGranularity(String granularity) {
        setGranularity(granularity);
        return this;
    }

    /**
     * <p>
     * The granularity or unit (day, month, year) of the exclude period.
     * </p>
     * 
     * @param granularity
     *        The granularity or unit (day, month, year) of the exclude period.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TimeGranularity
     */

    public ExcludePeriodConfiguration withGranularity(TimeGranularity granularity) {
        this.granularity = granularity.toString();
        return this;
    }

    /**
     * <p>
     * The status of the exclude period. Choose from the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @param status
     *        The status of the exclude period. Choose from the following options:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>ENABLED</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>DISABLED</code>
     *        </p>
     *        </li>
     * @see WidgetStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * The status of the exclude period. Choose from the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the exclude period. Choose from the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code>
     *         </p>
     *         </li>
     * @see WidgetStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The status of the exclude period. Choose from the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @param status
     *        The status of the exclude period. Choose from the following options:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>ENABLED</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>DISABLED</code>
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see WidgetStatus
     */

    public ExcludePeriodConfiguration withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * The status of the exclude period. Choose from the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @param status
     *        The status of the exclude period. Choose from the following options:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>ENABLED</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>DISABLED</code>
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see WidgetStatus
     */

    public ExcludePeriodConfiguration withStatus(WidgetStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAmount() != null)
            sb.append("Amount: ").append(getAmount()).append(",");
        if (getGranularity() != null)
            sb.append("Granularity: ").append(getGranularity()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ExcludePeriodConfiguration == false)
            return false;
        ExcludePeriodConfiguration other = (ExcludePeriodConfiguration) obj;
        if (other.getAmount() == null ^ this.getAmount() == null)
            return false;
        if (other.getAmount() != null && other.getAmount().equals(this.getAmount()) == false)
            return false;
        if (other.getGranularity() == null ^ this.getGranularity() == null)
            return false;
        if (other.getGranularity() != null && other.getGranularity().equals(this.getGranularity()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAmount() == null) ? 0 : getAmount().hashCode());
        hashCode = prime * hashCode + ((getGranularity() == null) ? 0 : getGranularity().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        return hashCode;
    }

    @Override
    public ExcludePeriodConfiguration clone() {
        try {
            return (ExcludePeriodConfiguration) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.quicksight.model.transform.ExcludePeriodConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
