/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.ColumnTag;
import com.amazonaws.services.quicksight.model.transform.TagColumnOperationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TagColumnOperation
implements Serializable,
Cloneable,
StructuredPojo {
    private String columnName;
    private List<ColumnTag> tags;

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public TagColumnOperation withColumnName(String columnName) {
        this.setColumnName(columnName);
        return this;
    }

    public List<ColumnTag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<ColumnTag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<ColumnTag>(tags);
    }

    public TagColumnOperation withTags(ColumnTag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<ColumnTag>(tags.length));
        }
        for (ColumnTag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public TagColumnOperation withTags(Collection<ColumnTag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getColumnName() != null) {
            sb.append("ColumnName: ").append(this.getColumnName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagColumnOperation)) {
            return false;
        }
        TagColumnOperation other = (TagColumnOperation)obj;
        if (other.getColumnName() == null ^ this.getColumnName() == null) {
            return false;
        }
        if (other.getColumnName() != null && !other.getColumnName().equals(this.getColumnName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getColumnName() == null ? 0 : this.getColumnName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public TagColumnOperation clone() {
        try {
            return (TagColumnOperation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TagColumnOperationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

