/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.NetworkInterface;
import com.amazonaws.services.quicksight.model.VPCConnectionAvailabilityStatus;
import com.amazonaws.services.quicksight.model.VPCConnectionResourceStatus;
import com.amazonaws.services.quicksight.model.transform.VPCConnectionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class VPCConnection
implements Serializable,
Cloneable,
StructuredPojo {
    private String vPCConnectionId;
    private String arn;
    private String name;
    private String vPCId;
    private List<String> securityGroupIds;
    private List<String> dnsResolvers;
    private String status;
    private String availabilityStatus;
    private List<NetworkInterface> networkInterfaces;
    private String roleArn;
    private Date createdTime;
    private Date lastUpdatedTime;

    public void setVPCConnectionId(String vPCConnectionId) {
        this.vPCConnectionId = vPCConnectionId;
    }

    public String getVPCConnectionId() {
        return this.vPCConnectionId;
    }

    public VPCConnection withVPCConnectionId(String vPCConnectionId) {
        this.setVPCConnectionId(vPCConnectionId);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public VPCConnection withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public VPCConnection withName(String name) {
        this.setName(name);
        return this;
    }

    public void setVPCId(String vPCId) {
        this.vPCId = vPCId;
    }

    public String getVPCId() {
        return this.vPCId;
    }

    public VPCConnection withVPCId(String vPCId) {
        this.setVPCId(vPCId);
        return this;
    }

    public List<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }
        this.securityGroupIds = new ArrayList<String>(securityGroupIds);
    }

    public VPCConnection withSecurityGroupIds(String ... securityGroupIds) {
        if (this.securityGroupIds == null) {
            this.setSecurityGroupIds(new ArrayList<String>(securityGroupIds.length));
        }
        for (String ele : securityGroupIds) {
            this.securityGroupIds.add(ele);
        }
        return this;
    }

    public VPCConnection withSecurityGroupIds(Collection<String> securityGroupIds) {
        this.setSecurityGroupIds(securityGroupIds);
        return this;
    }

    public List<String> getDnsResolvers() {
        return this.dnsResolvers;
    }

    public void setDnsResolvers(Collection<String> dnsResolvers) {
        if (dnsResolvers == null) {
            this.dnsResolvers = null;
            return;
        }
        this.dnsResolvers = new ArrayList<String>(dnsResolvers);
    }

    public VPCConnection withDnsResolvers(String ... dnsResolvers) {
        if (this.dnsResolvers == null) {
            this.setDnsResolvers(new ArrayList<String>(dnsResolvers.length));
        }
        for (String ele : dnsResolvers) {
            this.dnsResolvers.add(ele);
        }
        return this;
    }

    public VPCConnection withDnsResolvers(Collection<String> dnsResolvers) {
        this.setDnsResolvers(dnsResolvers);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public VPCConnection withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public VPCConnection withStatus(VPCConnectionResourceStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setAvailabilityStatus(String availabilityStatus) {
        this.availabilityStatus = availabilityStatus;
    }

    public String getAvailabilityStatus() {
        return this.availabilityStatus;
    }

    public VPCConnection withAvailabilityStatus(String availabilityStatus) {
        this.setAvailabilityStatus(availabilityStatus);
        return this;
    }

    public VPCConnection withAvailabilityStatus(VPCConnectionAvailabilityStatus availabilityStatus) {
        this.availabilityStatus = availabilityStatus.toString();
        return this;
    }

    public List<NetworkInterface> getNetworkInterfaces() {
        return this.networkInterfaces;
    }

    public void setNetworkInterfaces(Collection<NetworkInterface> networkInterfaces) {
        if (networkInterfaces == null) {
            this.networkInterfaces = null;
            return;
        }
        this.networkInterfaces = new ArrayList<NetworkInterface>(networkInterfaces);
    }

    public VPCConnection withNetworkInterfaces(NetworkInterface ... networkInterfaces) {
        if (this.networkInterfaces == null) {
            this.setNetworkInterfaces(new ArrayList<NetworkInterface>(networkInterfaces.length));
        }
        for (NetworkInterface ele : networkInterfaces) {
            this.networkInterfaces.add(ele);
        }
        return this;
    }

    public VPCConnection withNetworkInterfaces(Collection<NetworkInterface> networkInterfaces) {
        this.setNetworkInterfaces(networkInterfaces);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public VPCConnection withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public VPCConnection withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public VPCConnection withLastUpdatedTime(Date lastUpdatedTime) {
        this.setLastUpdatedTime(lastUpdatedTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVPCConnectionId() != null) {
            sb.append("VPCConnectionId: ").append(this.getVPCConnectionId()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getVPCId() != null) {
            sb.append("VPCId: ").append(this.getVPCId()).append(",");
        }
        if (this.getSecurityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.getSecurityGroupIds()).append(",");
        }
        if (this.getDnsResolvers() != null) {
            sb.append("DnsResolvers: ").append(this.getDnsResolvers()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getAvailabilityStatus() != null) {
            sb.append("AvailabilityStatus: ").append(this.getAvailabilityStatus()).append(",");
        }
        if (this.getNetworkInterfaces() != null) {
            sb.append("NetworkInterfaces: ").append(this.getNetworkInterfaces()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getLastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: ").append(this.getLastUpdatedTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VPCConnection)) {
            return false;
        }
        VPCConnection other = (VPCConnection)obj;
        if (other.getVPCConnectionId() == null ^ this.getVPCConnectionId() == null) {
            return false;
        }
        if (other.getVPCConnectionId() != null && !other.getVPCConnectionId().equals(this.getVPCConnectionId())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getVPCId() == null ^ this.getVPCId() == null) {
            return false;
        }
        if (other.getVPCId() != null && !other.getVPCId().equals(this.getVPCId())) {
            return false;
        }
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null) {
            return false;
        }
        if (other.getSecurityGroupIds() != null && !other.getSecurityGroupIds().equals(this.getSecurityGroupIds())) {
            return false;
        }
        if (other.getDnsResolvers() == null ^ this.getDnsResolvers() == null) {
            return false;
        }
        if (other.getDnsResolvers() != null && !other.getDnsResolvers().equals(this.getDnsResolvers())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getAvailabilityStatus() == null ^ this.getAvailabilityStatus() == null) {
            return false;
        }
        if (other.getAvailabilityStatus() != null && !other.getAvailabilityStatus().equals(this.getAvailabilityStatus())) {
            return false;
        }
        if (other.getNetworkInterfaces() == null ^ this.getNetworkInterfaces() == null) {
            return false;
        }
        if (other.getNetworkInterfaces() != null && !other.getNetworkInterfaces().equals(this.getNetworkInterfaces())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getLastUpdatedTime() == null ^ this.getLastUpdatedTime() == null) {
            return false;
        }
        return other.getLastUpdatedTime() == null || other.getLastUpdatedTime().equals(this.getLastUpdatedTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVPCConnectionId() == null ? 0 : this.getVPCConnectionId().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getVPCId() == null ? 0 : this.getVPCId().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupIds() == null ? 0 : this.getSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getDnsResolvers() == null ? 0 : this.getDnsResolvers().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityStatus() == null ? 0 : this.getAvailabilityStatus().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkInterfaces() == null ? 0 : this.getNetworkInterfaces().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedTime() == null ? 0 : this.getLastUpdatedTime().hashCode());
        return hashCode;
    }

    public VPCConnection clone() {
        try {
            return (VPCConnection)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VPCConnectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

