/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.VisualCustomAction;
import com.amazonaws.services.quicksight.model.transform.EmptyVisualMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EmptyVisual
implements Serializable,
Cloneable,
StructuredPojo {
    private String visualId;
    private String dataSetIdentifier;
    private List<VisualCustomAction> actions;

    public void setVisualId(String visualId) {
        this.visualId = visualId;
    }

    public String getVisualId() {
        return this.visualId;
    }

    public EmptyVisual withVisualId(String visualId) {
        this.setVisualId(visualId);
        return this;
    }

    public void setDataSetIdentifier(String dataSetIdentifier) {
        this.dataSetIdentifier = dataSetIdentifier;
    }

    public String getDataSetIdentifier() {
        return this.dataSetIdentifier;
    }

    public EmptyVisual withDataSetIdentifier(String dataSetIdentifier) {
        this.setDataSetIdentifier(dataSetIdentifier);
        return this;
    }

    public List<VisualCustomAction> getActions() {
        return this.actions;
    }

    public void setActions(Collection<VisualCustomAction> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<VisualCustomAction>(actions);
    }

    public EmptyVisual withActions(VisualCustomAction ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<VisualCustomAction>(actions.length));
        }
        for (VisualCustomAction ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public EmptyVisual withActions(Collection<VisualCustomAction> actions) {
        this.setActions(actions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVisualId() != null) {
            sb.append("VisualId: ").append(this.getVisualId()).append(",");
        }
        if (this.getDataSetIdentifier() != null) {
            sb.append("DataSetIdentifier: ").append(this.getDataSetIdentifier()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmptyVisual)) {
            return false;
        }
        EmptyVisual other = (EmptyVisual)obj;
        if (other.getVisualId() == null ^ this.getVisualId() == null) {
            return false;
        }
        if (other.getVisualId() != null && !other.getVisualId().equals(this.getVisualId())) {
            return false;
        }
        if (other.getDataSetIdentifier() == null ^ this.getDataSetIdentifier() == null) {
            return false;
        }
        if (other.getDataSetIdentifier() != null && !other.getDataSetIdentifier().equals(this.getDataSetIdentifier())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        return other.getActions() == null || other.getActions().equals(this.getActions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVisualId() == null ? 0 : this.getVisualId().hashCode());
        hashCode = 31 * hashCode + (this.getDataSetIdentifier() == null ? 0 : this.getDataSetIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        return hashCode;
    }

    public EmptyVisual clone() {
        try {
            return (EmptyVisual)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EmptyVisualMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

